/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComOrderDelAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderDelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDelAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderDelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderDelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderDelBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderDelAbilityService"})
public class FscComOrderDelAbilityServiceImpl
implements FscComOrderDelAbilityService {
    @Autowired
    private FscComOrderDelBusiService fscComOrderDelBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"delFscOrder"})
    public FscComOrderDelAbilityRspBO delFscOrder(@RequestBody FscComOrderDelAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderDelBusiReqBO busiReqBO = (FscComOrderDelBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderDelBusiReqBO.class));
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            busiReqBO.setFscOrderId(fscOrderId);
            FscComOrderDelBusiRspBO busiRspBO = this.fscComOrderDelBusiService.delFscOrder(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                sb.append("[\u7ed3\u7b97\u5355").append(fscOrderId).append("\u5220\u9664\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc()).append("]");
            }
            this.sendMq(fscOrderId);
        }
        FscComOrderDelAbilityRspBO abilityRspBO = new FscComOrderDelAbilityRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            abilityRspBO.setRespCode("0000");
            abilityRspBO.setRespDesc("\u6210\u529f");
        } else {
            abilityRspBO.setRespCode("190000");
            abilityRspBO.setRespDesc(sb.toString());
        }
        return abilityRspBO;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

