/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderApprovalListPageAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderApprovalListPageAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderApprovalListPageAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderApprovalListPageAbilityService"})
public class FscOrderApprovalListPageAbilityServiceImpl
implements FscOrderApprovalListPageAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderApprovalListPageAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"getFscOrderApprovalListPage"})
    public FscOrderApprovalListPageAbilityRspBO getFscOrderApprovalListPage(@RequestBody FscOrderApprovalListPageAbilityReqBO reqBO) {
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        fscOrderPO.setSignOperId(reqBO.getUserId().toString());
        fscOrderPO.setSignApplyTimeStart(reqBO.getSignTimeBegin());
        fscOrderPO.setSignApplyTimeEnd(reqBO.getSignTimeEnd());
        fscOrderPO.setSendOperName(reqBO.getAuditOperName());
        if (!StringUtils.isEmpty((Object)reqBO.getInvoiceNo()) && !reqBO.getInvoiceNo().startsWith(",")) {
            reqBO.setInvoiceNo("," + reqBO.getInvoiceNo());
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (reqBO.getBusiType() == 1) {
            if (!StringUtils.isEmpty((Object)reqBO.getTabId()) && reqBO.getTabId().equals("20015")) {
                fscOrderPO.setOrderBy("send_oper_time desc");
            } else {
                fscOrderPO.setOrderBy("send_apply_time desc");
            }
        } else if (reqBO.getBusiType() == 2) {
            if (!StringUtils.isEmpty((Object)reqBO.getTabId()) && reqBO.getTabId().equals("20012")) {
                fscOrderPO.setOrderBy("sign_oper_time desc");
            } else {
                fscOrderPO.setOrderBy("sign_apply_time desc");
            }
        }
        List fscOrderPOList = !CollectionUtils.isEmpty((Collection)reqBO.getAuditedTaskOperIdList()) ? this.fscOrderMapper.queryWithApproveListPage(fscOrderPO, page) : this.fscOrderMapper.getListPage(fscOrderPO, page);
        ArrayList<FscComOrderListBO> rows = new ArrayList<FscComOrderListBO>();
        if (!CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
            for (FscOrderPO f : fscOrderPOList) {
                FscComOrderListBO row = (FscComOrderListBO)JSON.parseObject((String)JSONObject.toJSONString((Object)f), FscComOrderListBO.class);
                this.getOrderInfo(row);
                if (reqBO.getQueryType() == 2) {
                    if (FscConstants.FscServiceOrderState.WAIT_BILL_INVOICE.equals(row.getSendState())) {
                        row.setSendStateStr("\u5ba1\u6279\u901a\u8fc7");
                    } else if (FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(row.getOrderState())) {
                        row.setOrderStateStr("\u5ba1\u6279\u901a\u8fc7");
                    }
                }
                rows.add(row);
            }
        }
        FscOrderApprovalListPageAbilityRspBO rspBO = new FscOrderApprovalListPageAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(rows);
        return rspBO;
    }

    private void getOrderInfo(FscComOrderListBO fscComOrderListBO) {
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderId(fscComOrderListBO.getFscOrderId());
        List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
        Map buildActionMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUILD_ACTION");
        Map orderSourceMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SOURCE");
        Map shouldPayTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("SHOULD_PAY_TYPE");
        Map payTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CFC_PAY_TYPE_ALLOW");
        Map busiCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("BUSI_CATEGORY");
        Map signStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SIGN_APPROVAL");
        Map sendStateMap = this.fscDictionaryAbilityService.queryBypCodeBackMap("FSC_ORDER_INVOICE_APPROVAL");
        if (null != fscComOrderListBO.getPayChannel()) {
            FscPayTransPayInsReqBo fscPayTransPayInsReqBo = new FscPayTransPayInsReqBo();
            fscPayTransPayInsReqBo.setPaymentInsId(Collections.singletonList(Long.parseLong(fscComOrderListBO.getPayChannel())));
            FscPayTransPayInsRspBo fscPayTransPayInsRspBo = this.fscPayTransPayInsService.tranPayIns(fscPayTransPayInsReqBo);
            if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo)) {
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayInsMap())) {
                    fscComOrderListBO.setPayChannelStr((String)fscPayTransPayInsRspBo.getPayInsMap().get(fscComOrderListBO.getPayChannel()));
                }
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayMethodMap())) {
                    fscComOrderListBO.setPayMethodStr((String)fscPayTransPayInsRspBo.getPayMethodMap().get(fscComOrderListBO.getPayMethod()));
                }
            }
        }
        BigDecimal totalChargeBill = new BigDecimal("0");
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            String invoiceCodeStr;
            ArrayList<Long> mailIdList = new ArrayList<Long>(fscInvoicePOS.size());
            ArrayList<String> billDate = new ArrayList<String>(fscInvoicePOS.size());
            for (FscInvoicePO fscInvoicePO : fscInvoicePOS) {
                totalChargeBill = totalChargeBill.add(fscInvoicePO.getAmt());
                mailIdList.add(fscInvoicePO.getMailId());
                invoiceNo.append(",").append(fscInvoicePO.getInvoiceNo());
                invoiceCode.append(",").append(fscInvoicePO.getInvoiceCode());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fscInvoicePO.getBillDate())) continue;
                billDate.add(fscInvoicePO.getBillDate());
            }
            fscComOrderListBO.setTotalChargeBill(totalChargeBill);
            String invoiceNoStr = invoiceNo.toString();
            if (invoiceNoStr.startsWith(",")) {
                invoiceNoStr = invoiceNoStr.replaceFirst(",", "");
            }
            if ((invoiceCodeStr = invoiceCode.toString()).startsWith(",")) {
                invoiceCodeStr = invoiceCodeStr.replaceFirst(",", "");
            }
            fscComOrderListBO.setInvoiceNo(invoiceNoStr);
            fscComOrderListBO.setInvoiceCode(invoiceCodeStr);
            fscComOrderListBO.setBillDate((String)billDate.get(0));
            List InvoicePostPOList = this.fscInvoicePostMapper.getListByIds(mailIdList);
            if (!CollectionUtils.isEmpty((Collection)InvoicePostPOList)) {
                ArrayList<String> sendInfoStr = new ArrayList<String>(InvoicePostPOList.size());
                for (FscInvoicePostPO fscInvoicePostPO : InvoicePostPOList) {
                    String sendCompany = fscInvoicePostPO.getSendCompany();
                    String sendOrder = fscInvoicePostPO.getSendOrder();
                    if (StringUtils.isEmpty((Object)sendCompany) || StringUtils.isEmpty((Object)sendOrder)) continue;
                    sendInfoStr.add((String)sendCompany + "," + sendOrder);
                }
                fscComOrderListBO.setSendInfoStr(sendInfoStr);
            }
        }
        Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
        Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
        if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceCategory())) {
            fscComOrderListBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(fscComOrderListBO.getInvoiceCategory())));
        }
        if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceType())) {
            fscComOrderListBO.setInvoiceTypeStr((String)invoiceTypeMap.get(fscComOrderListBO.getInvoiceType()));
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(fscComOrderListBO.getFscOrderId());
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        ArrayList<String> attUrls = null;
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            attUrls = new ArrayList<String>(fscAttachmentPOS.size());
            for (FscAttachmentPO fscAttachmentPO : fscAttachmentPOS) {
                attUrls.add(fscAttachmentPO.getAttachmentUrl());
            }
        }
        fscComOrderListBO.setOrderFlowStr(Objects.requireNonNull(FscOrderFlowEnum.getInstance((Integer)fscComOrderListBO.getOrderFlow())).getDescr());
        fscComOrderListBO.setBusiCategoryStr((String)busiCategoryMap.get(fscComOrderListBO.getBusiCategory() + ""));
        fscComOrderListBO.setBuildActionStr((String)buildActionMap.get(fscComOrderListBO.getBuildAction() + ""));
        String orderState = (String)signStateMap.get(fscComOrderListBO.getOrderState() + "");
        fscComOrderListBO.setOrderStateStr(StringUtils.isEmpty((Object)orderState) ? "\u5ba1\u6838\u901a\u8fc7" : orderState);
        fscComOrderListBO.setShouldPayTypeStr((String)shouldPayTypeMap.get(fscComOrderListBO.getShouldPayType() + ""));
        fscComOrderListBO.setOrderSourceStr((String)orderSourceMap.get(fscComOrderListBO.getOrderSource() + ""));
        fscComOrderListBO.setPayTypeStr((String)payTypeMap.get(fscComOrderListBO.getPayType() + ""));
        fscComOrderListBO.setSendStateStr((String)sendStateMap.get(fscComOrderListBO.getSendState() + ""));
        fscComOrderListBO.setAttachmentList(attUrls);
        fscComOrderListBO.setPayEvidenceUrls(attUrls);
    }
}

