/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.common.busi.api.FscComOrderDelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderDelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderDelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscComOrderDelBusiServiceImpl
implements FscComOrderDelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderDelBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscEsConfig fscEsConfig;
    @Autowired
    private FscElasticsearchUtil fscElasticsearchUtil;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @Override
    public FscComOrderDelBusiRspBO delFscOrder(FscComOrderDelBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPo = this.fscOrderMapper.getModelBy(orderPO);
        if (fscOrderPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (!fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.ROLL_BACK)) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u8fd0\u8425\u56de\u9000\u72b6\u6001\u7684\u7ed3\u7b97\u5355\u53ef\u4ee5\u5220\u9664\uff01");
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo.setOrderState(FscConstants.FscInvoiceOrderState.DEL);
        fscOrderPo.setUpdateOperId(reqBO.getUserId().toString());
        fscOrderPo.setUpdateOperName(reqBO.getName());
        fscOrderPo.setUpdateTime(new Date());
        this.fscOrderMapper.updateById(fscOrderPo);
        FscOrderItemPO itemQueryVo = new FscOrderItemPO();
        itemQueryVo.setFscOrderId(fscOrderPo.getFscOrderId());
        List orderItemPOList = this.fscOrderItemMapper.getList(itemQueryVo);
        List inspectionIdList = orderItemPOList.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toList());
        FscShouldPayPO shouldPayQueryVo = new FscShouldPayPO();
        shouldPayQueryVo.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_FREEZE);
        shouldPayQueryVo.setInspectionIdList(inspectionIdList);
        List shouldPayPOList = this.fscShouldPayMapper.getList(shouldPayQueryVo);
        for (FscShouldPayPO fscShouldPayPO : shouldPayPOList) {
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        }
        if (!CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            this.fscShouldPayMapper.updateStatusByBatch(shouldPayPOList);
        }
        this.syncOrderStatus(reqBO.getFscOrderId());
        FscComOrderDelBusiRspBO busiRspBO = new FscComOrderDelBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void delOrderEs(Long fscOrderId) {
        String endPoint = "/" + this.fscEsConfig.getInvoiceIndexName() + "/" + this.fscEsConfig.getInvoiceIndexType() + "/_delete_by_query";
        JSONObject deleteConditionJson = new JSONObject();
        deleteConditionJson.put("fscOrderId", (Object)fscOrderId);
        JSONObject termJson = new JSONObject();
        termJson.put("term", (Object)deleteConditionJson);
        JSONObject qryJson = new JSONObject();
        qryJson.put("query", (Object)termJson);
        Boolean aBoolean = this.fscElasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
        if (!aBoolean.booleanValue()) {
            log.debug("---------------\u5220\u9664\u5931\u8d25---------------");
        }
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }
}

