/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscComOrderItemDeleteBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderItemDeleteBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderItemDeleteBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderItemDeleteBusiServiceImpl
implements FscComOrderItemDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderItemDeleteBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @Override
    public FscComOrderItemDeleteBusiRspBO dealOrderItemDelete(FscComOrderItemDeleteBusiReqBO reqBO) {
        FscComOrderItemDeleteBusiRspBO busiRspBO = new FscComOrderItemDeleteBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemPO.setAcceptOrderIds(reqBO.getAcceptOrderIds());
        BigDecimal amt = this.fscOrderItemMapper.getItemAmt(fscOrderItemPO);
        this.fscOrderItemMapper.deleteItemList(fscOrderItemPO);
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderRelationPO.setAcceptOrderIds(reqBO.getAcceptOrderIds());
        this.fscOrderRelationMapper.deleteByAccept(fscOrderRelationPO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        fscOrderPO.setTotalCharge(amt);
        this.fscOrderMapper.updateTotalCharge(fscOrderPO);
        FscShouldPayPO shouldPayQueryVo = new FscShouldPayPO();
        shouldPayQueryVo.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_FREEZE);
        shouldPayQueryVo.setInspectionIdList(reqBO.getAcceptOrderIds());
        List shouldPayPOList = this.fscShouldPayMapper.getList(shouldPayQueryVo);
        for (FscShouldPayPO fscShouldPayPO : shouldPayPOList) {
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        }
        if (!CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            this.fscShouldPayMapper.updateStatusByBatch(shouldPayPOList);
        }
        return busiRspBO;
    }
}

