/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscCfcUniteParamQryListDetailRspBO;
import com.tydic.fsc.common.ability.bo.FscClaimDetailBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiRspBO;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRecvClaimConfirmBusiServiceImpl
implements FscRecvClaimConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimConfirmBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private CfcUniteParamQryListDetailAbilityService cfcUniteParamQryListDetailAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public FscRecvClaimConfirmBusiRspBO recvClaimConfirm(FscRecvClaimConfirmBusiReqBO reqBO) {
        Integer operationClaimType = 2;
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u6536\u6b3e\u8ba4\u9886\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (fscRecvClaimPo.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886\uff0c\u8bf7\u52ff\u91cd\u590d\u8ba4\u9886\uff01");
        }
        BigDecimal claimAmt = BigDecimal.ZERO;
        for (FscClaimDetailBO fscClaimDetailBO : reqBO.getClaimDetailList()) {
            if (fscClaimDetailBO.getOperationType() == 1) {
                claimAmt = claimAmt.add(fscClaimDetailBO.getClaimAmt());
            } else if (fscClaimDetailBO.getOperationType() == 2) {
                claimAmt = claimAmt.subtract(fscClaimDetailBO.getClaimAmt());
            }
            if (claimAmt.compareTo(fscRecvClaimPo.getNoClaimAmt()) <= 0) continue;
            throw new FscBusinessException("190000", "\u672c\u6b21\u8ba4\u9886\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba4\u9886\u5355\u672a\u8ba4\u9886\u91d1\u989d\uff01");
        }
        ArrayList<Object> settleNoList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo()) && fscRecvClaimPo.getSettleNo().contains(",")) {
            settleNoList = new ArrayList<String>(Arrays.asList(fscRecvClaimPo.getSettleNo().split(",")));
        } else if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo())) {
            settleNoList.add(fscRecvClaimPo.getSettleNo());
        }
        if (!CollectionUtils.isEmpty(reqBO.getClaimDetailList()) && !StringUtils.isEmpty((Object)reqBO.getClaimDetailList().get(0).getFscOrderNo())) {
            operationClaimType = 1;
        }
        FscRecvClaimConfirmBusiRspBO rspBO = new FscRecvClaimConfirmBusiRspBO();
        rspBO.setPushFlag(false);
        LinkedList<FscClaimDetailPO> addClaimDetailList = new LinkedList<FscClaimDetailPO>();
        LinkedList<FscClaimDetailPO> updateClaimDetailList = new LinkedList<FscClaimDetailPO>();
        LinkedList<FscOrderItemPO> orderAddItemList = new LinkedList<FscOrderItemPO>();
        LinkedList<FscOrderItemPO> orderSubItemList = new LinkedList<FscOrderItemPO>();
        LinkedList<FscShouldPayPO> shouldPayAddList = new LinkedList<FscShouldPayPO>();
        LinkedList<FscShouldPayPO> shouldPaySubList = new LinkedList<FscShouldPayPO>();
        FscAccountSerialPO serialPo = new FscAccountSerialPO();
        serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
        serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
        Integer serialNumber = 0;
        if (serialPo != null) {
            serialNumber = serialPo.getSerialNumber();
        }
        for (FscClaimDetailBO fscClaimDetailBO : reqBO.getClaimDetailList()) {
            FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
            BeanUtils.copyProperties((Object)fscClaimDetailBO, (Object)fscClaimDetailPo);
            fscClaimDetailPo.setClaimId(reqBO.getClaimId());
            if (fscClaimDetailBO.getOperationType() == null || fscClaimDetailBO.getOperationType() == 1) {
                if (StringUtils.isEmpty((Object)fscClaimDetailPo.getClaimDetailId())) {
                    Object[] objectArray = new Object[1];
                    serialNumber = serialNumber + 1;
                    objectArray[0] = serialNumber;
                    String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
                    fscClaimDetailPo.setDetailNo(detailNo);
                    fscClaimDetailPo.setStatus("1");
                    fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                    addClaimDetailList.add(fscClaimDetailPo);
                } else {
                    fscClaimDetailPo.setStatus("1");
                    updateClaimDetailList.add(fscClaimDetailPo);
                }
                if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderNo())) {
                    settleNoList.add(fscClaimDetailBO.getFscOrderNo());
                }
                if (operationClaimType == 1) {
                    FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
                    fscOrderItemPo.setAcceptOrderId(fscClaimDetailPo.getObjectId());
                    fscOrderItemPo.setClaimAmt(fscClaimDetailBO.getClaimAmt());
                    orderAddItemList.add(fscOrderItemPo);
                    continue;
                }
                FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
                fscShouldPayPo.setShouldPayId(fscClaimDetailBO.getObjectId());
                fscShouldPayPo.setClaimAmt(fscClaimDetailBO.getClaimAmt());
                shouldPayAddList.add(fscShouldPayPo);
                continue;
            }
            if (fscClaimDetailBO.getOperationType() != 2) continue;
            FscClaimDetailPO addClaim = new FscClaimDetailPO();
            BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)addClaim);
            addClaim.setCancelClaimDate(null);
            addClaim.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            addClaim.setClaimDate(null);
            addClaim.setClaimAmt(null);
            addClaim.setStatus(null);
            addClaimDetailList.add(addClaim);
            if (fscClaimDetailPo.getClaimId() == null) {
                fscClaimDetailPo.setClaimId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderNo()) && settleNoList.size() > 0) {
                settleNoList.remove(fscClaimDetailBO.getFscOrderNo());
            }
            fscClaimDetailPo.setStatus("0");
            fscClaimDetailPo.setClaimAmt(fscClaimDetailBO.getClaimAmt());
            fscClaimDetailPo.setCancelClaimDate(fscClaimDetailBO.getCancelClaimDate());
            updateClaimDetailList.add(fscClaimDetailPo);
            if (operationClaimType == 1 && fscClaimDetailPo.getClaimDetailId() != null) {
                FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
                fscOrderItemPo.setAcceptOrderId(fscClaimDetailPo.getObjectId());
                if (fscClaimDetailBO.getCancelAmt() == null) {
                    fscOrderItemPo.setClaimAmt(BigDecimal.ZERO);
                } else {
                    fscOrderItemPo.setClaimAmt(fscClaimDetailBO.getCancelAmt());
                }
                orderSubItemList.add(fscOrderItemPo);
                continue;
            }
            if (fscClaimDetailPo.getClaimDetailId() == null) continue;
            FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
            fscShouldPayPo.setShouldPayId(fscClaimDetailBO.getObjectId());
            if (fscClaimDetailBO.getCancelAmt() == null) {
                fscShouldPayPo.setClaimAmt(BigDecimal.ZERO);
            } else {
                fscShouldPayPo.setClaimAmt(fscClaimDetailBO.getCancelAmt());
            }
            shouldPaySubList.add(fscShouldPayPo);
        }
        if (!CollectionUtils.isEmpty(addClaimDetailList)) {
            this.fscClaimDetailMapper.insertBatch(addClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(updateClaimDetailList)) {
            this.fscClaimDetailMapper.updateBatch(updateClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(orderAddItemList)) {
            this.fscOrderItemMapper.updateClaimAmtAddBatch(orderAddItemList);
        }
        if (!CollectionUtils.isEmpty(orderSubItemList)) {
            this.fscOrderItemMapper.updateClaimAmtSubBatch(orderSubItemList);
        }
        if (!CollectionUtils.isEmpty(shouldPayAddList)) {
            this.fscShouldPayMapper.updateClaimAmountAdd(shouldPayAddList);
        }
        if (!CollectionUtils.isEmpty(shouldPaySubList)) {
            this.fscShouldPayMapper.updateClaimAmountSub(shouldPaySubList);
        }
        FscRecvClaimPO fscRecvClaim = new FscRecvClaimPO();
        fscRecvClaim.setClaimId(reqBO.getClaimId());
        fscRecvClaim.setStatus(Integer.valueOf(0));
        fscRecvClaim.setNoClaimAmt(reqBO.getNoClaimAmt());
        if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
            rspBO.setPushFlag(true);
        } else if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) > 0) {
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(reqBO.getRecvAmt()) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        }
        if (!CollectionUtils.isEmpty(settleNoList)) {
            fscRecvClaim.setSettleNo(settleNoList.stream().distinct().collect(Collectors.joining(",")));
        }
        this.fscRecvClaimMapper.update(fscRecvClaim);
        if (serialPo == null) {
            serialPo = new FscAccountSerialPO();
            serialPo.setSerialNumber(serialNumber);
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
            this.fscAccountSerialMapper.insert(serialPo);
        } else {
            serialPo.setSerialNumber(serialNumber);
            this.fscAccountSerialMapper.update(serialPo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (rspBO.getPushFlag().booleanValue()) {
            this.dealPushYc(reqBO);
        }
        return rspBO;
    }

    private void dealPushYc(FscRecvClaimConfirmBusiReqBO reqBO) {
        FscCfcUniteParamQryListDetailRspBO rspBO = this.queryConfig(reqBO.getOrgId());
        if (rspBO != null && "1".equals(rspBO.getAllowSettle())) {
            FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
            abilityReqBO.setClaimId(reqBO.getClaimId());
            FscPushYcRecvClaimBillAbilityRspBO abilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("190000", abilityRspBO.getRespDesc());
            }
            FscRecvClaimPO fscRecvClaimPo = new FscRecvClaimPO();
            fscRecvClaimPo.setClaimId(reqBO.getClaimId());
            fscRecvClaimPo.setStatus(Integer.valueOf(1));
            this.fscRecvClaimMapper.update(fscRecvClaimPo);
        }
    }

    private FscCfcUniteParamQryListDetailRspBO queryConfig(Long orgId) {
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u5165\u53c2");
        CfcUniteParamQryListDetailAbilityReqBO cfcUniteParamQryListDetailAbilityReqBO = new CfcUniteParamQryListDetailAbilityReqBO();
        cfcUniteParamQryListDetailAbilityReqBO.setParamCode("IS_CONFIRM_AGAIN_AFTER_CLAIM");
        cfcUniteParamQryListDetailAbilityReqBO.setCenter("FSC");
        CfcUniteParamQryListDetailAbilityRspBO cfcUniteParamQryListDetailAbilityRspBO = this.cfcUniteParamQryListDetailAbilityService.qryListDetail(cfcUniteParamQryListDetailAbilityReqBO);
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u51fa\u53c2:" + JSONObject.toJSONString((Object)cfcUniteParamQryListDetailAbilityRspBO));
        if (null == cfcUniteParamQryListDetailAbilityRspBO || null == cfcUniteParamQryListDetailAbilityRspBO.getJsonObject() || cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().isEmpty()) {
            return null;
        }
        return (FscCfcUniteParamQryListDetailRspBO)JSON.parseObject((String)cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().toJSONString(), FscCfcUniteParamQryListDetailRspBO.class);
    }
}

