/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscRecvClaimCreateImportBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimCreateImportBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimCreateImportBusiRspBO;
import com.tydic.fsc.common.util.ExcelUtils;
import com.tydic.fsc.common.util.HttpUtil;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscRecvTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FscRecvClaimCreateImportBusiServiceImpl
implements FscRecvClaimCreateImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimCreateImportBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public FscRecvClaimCreateImportBusiRspBO dealCreateImport(FscRecvClaimCreateImportBusiReqBO reqBO) {
        List fscRecvClaimPOs;
        FscRecvClaimCreateImportBusiRspBO rspBO = new FscRecvClaimCreateImportBusiRspBO();
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xls");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xls");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (data.size() > 1000) {
            throw new BusinessException("22052", "\u6bcf\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u6761\uff01");
        }
        ArrayList importDataMaps = new ArrayList();
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("COLLECTION_CLAIM");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(data.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        Integer index = 0;
        for (List list : data) {
            this.valit(list);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("claimId", Sequence.getInstance().nextId());
            dataMap.put("claimNo", encodedSerialGetServiceRspBO.getSerialNoList().get(index));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            dataMap.put("recvDeptName", list.get(2));
            dataMap.put("serialNumber", list.get(3));
            if (FscRecvTypeEnum.BANK_RECV.getCodeDesc().equals(list.get(4))) {
                dataMap.put("recvType", FscRecvTypeEnum.BANK_RECV.getCode());
            }
            if (FscRecvTypeEnum.SHOULD_RECV.getCodeDesc().equals(list.get(4))) {
                dataMap.put("recvType", FscRecvTypeEnum.SHOULD_RECV.getCode());
            }
            dataMap.put("customerName", list.get(5));
            dataMap.put("childAccount", list.get(6));
            dataMap.put("currency", list.get(7));
            dataMap.put("recvAmt", list.get(8));
            dataMap.put("recvDate", list.get(9));
            dataMap.put("createTime", new Date());
            importDataMaps.add(dataMap);
        }
        String jsonStr = JSON.toJSONString(importDataMaps);
        log.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a" + jsonStr);
        try {
            fscRecvClaimPOs = JSON.parseArray((String)jsonStr, FscRecvClaimPO.class);
        }
        catch (Exception exception) {
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        Integer n = this.fscRecvClaimMapper.insertBatch(fscRecvClaimPOs);
        rspBO.setTotal(data.size());
        rspBO.setSuccess(n);
        rspBO.setFailed(data.size() - n);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bfc\u5165\u6210\u529f");
        return rspBO;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == 0) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < 0) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }

    private void valit(List<String> sheet) {
        if (StringUtils.isEmpty((Object)sheet.get(2)) || "null".equals(sheet.get(2))) {
            throw new FscBusinessException("22052", "\u6536\u6b3e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e8f\u53f7\uff1a" + sheet.get(0));
        }
        if (StringUtils.isEmpty((Object)sheet.get(3)) || "null".equals(sheet.get(3))) {
            throw new FscBusinessException("22052", "\u94f6\u884c\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e8f\u53f7\uff1a" + sheet.get(0));
        }
        if (StringUtils.isEmpty((Object)sheet.get(4)) || "null".equals(sheet.get(4))) {
            throw new FscBusinessException("22052", "\u6536\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e8f\u53f7\uff1a" + sheet.get(0));
        }
        if (StringUtils.isEmpty((Object)sheet.get(5)) || "null".equals(sheet.get(5))) {
            throw new FscBusinessException("22052", "\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e8f\u53f7\uff1a" + sheet.get(0));
        }
        if (StringUtils.isEmpty((Object)sheet.get(6)) || "null".equals(sheet.get(6))) {
            throw new FscBusinessException("22052", "\u5b50\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e8f\u53f7\uff1a" + sheet.get(0));
        }
        if (StringUtils.isEmpty((Object)sheet.get(8)) || "null".equals(sheet.get(8))) {
            throw new FscBusinessException("22052", "\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e8f\u53f7\uff1a" + sheet.get(0));
        }
        if (StringUtils.isEmpty((Object)sheet.get(9)) || "null".equals(sheet.get(9))) {
            throw new FscBusinessException("22052", "\u6536\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e8f\u53f7\uff1a" + sheet.get(0));
        }
    }
}

