/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService;
import com.tydic.fsc.common.ability.api.FscAccountChargeClaimAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeBatchAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUseAccountBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeProBusiService;
import com.tydic.fsc.common.busi.api.FscAccountChargePurBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService"})
public class FscAccountChargeAbilityServiceImpl
implements FscAccountChargeAbilityService {
    @Autowired
    private FscAccountChargePurBusiService fscAccountChargePurBusiService;
    @Autowired
    private FscAccountChargeProBusiService fscAccountChargeProBusiService;
    @Autowired
    private FscAccountChargeClaimAbilityService fscAccountChargeClaimAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealAccountCharge"})
    public FscAccountChargeAbilityRspBO dealAccountCharge(@RequestBody FscAccountChargeAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAttachmentList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9644\u4ef6\u96c6\u5408[attachmentList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountChargeBusiReqBO busiReqBO = new FscAccountChargeBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAccountChargeBusiRspBO busiRspBO = null;
        busiRspBO = reqBO.getWebSource() == null || reqBO.getWebSource() == 2 ? this.fscAccountChargePurBusiService.dealAccountCharge(busiReqBO) : this.fscAccountChargeProBusiService.dealAccountCharge(busiReqBO);
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"dealAccountChargeBatch"})
    public FscAccountChargeAbilityRspBO dealAccountChargeBatch(@RequestBody FscAccountChargeBatchAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAttachmentList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9644\u4ef6\u96c6\u5408[attachmentList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4f7f\u7528\u5355\u4f4d\u96c6\u5408[useAccountBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BigDecimal totalAmount = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!reqBO.getChargeAmount().equals(totalAmount)) {
            throw new FscBusinessException("198888", "\u591a\u4e2a\u5355\u4f4d/\u90e8\u95e8\u8d26\u6237\u5206\u914d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u5145\u503c\u91d1\u989d\uff01");
        }
        FscAccountChargeBatchBusiReqBO busiReqBO = new FscAccountChargeBatchBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAccountChargeBatchBusiRspBO fscAccountChargeBatchBusiRspBO = this.fscAccountChargePurBusiService.dealAccountChargeBatch(busiReqBO);
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)fscAccountChargeBatchBusiRspBO), (Object)rspBO);
        return rspBO;
    }
}

