/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountRegulationListPageQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountRegulationBO;
import com.tydic.fsc.common.ability.bo.FscAccountRegulationListPageQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountRegulationListPageQryAbilityRspBO;
import com.tydic.fsc.common.atom.api.FscGetStateListOfConfTabAtomService;
import com.tydic.fsc.dao.FscAccountRegulationMapper;
import com.tydic.fsc.enums.FscRegulationStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.ConfTabStatePO;
import com.tydic.fsc.po.FscAccountRegulationPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountRegulationListPageQryAbilityService"})
public class FscAccountRegulationListPageQryAbilityServiceImpl
implements FscAccountRegulationListPageQryAbilityService {
    @Autowired
    private FscAccountRegulationMapper fscAccountRegulationMapper;
    @Autowired
    private FscGetStateListOfConfTabAtomService fscGetStateListOfConfTabAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryAccountRegulationListPage"})
    public FscAccountRegulationListPageQryAbilityRspBO qryAccountRegulationListPage(@RequestBody FscAccountRegulationListPageQryAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getPageNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[pageNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPageSize())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTabId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9875\u7b7eid[tabId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9875\u7b7e\u96c6\u5408[tabIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountRegulationPO queryVo = new FscAccountRegulationPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryVo);
        queryVo.setUserName(reqBO.getUserNameWeb());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<String> tabIdList = reqBO.getTabIdList().stream().map(String::valueOf).collect(Collectors.toList());
        Map<String, ConfTabStatePO> stateMap = this.fscGetStateListOfConfTabAtomService.getStateList(tabIdList);
        ConfTabStatePO confTabStatePo = stateMap.get(reqBO.getTabId().toString());
        if (confTabStatePo == null) {
            throw new FscBusinessException("198888", "\u9875\u7b7e\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a\uff01\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\uff01");
        }
        if (confTabStatePo.getStatusCode().contains(",")) {
            queryVo.setStatusList(Arrays.asList(confTabStatePo.getStatusCode().split(",")));
        } else {
            queryVo.setStatus(Integer.valueOf(confTabStatePo.getStatusCode()));
        }
        FscAccountRegulationListPageQryAbilityRspBO rspBO = new FscAccountRegulationListPageQryAbilityRspBO();
        List fscAccountRegulationPoList = this.fscAccountRegulationMapper.selectPageList(queryVo, page);
        Map regulationTypeMap = reqBO.getOperType() == null || reqBO.getOperType() == 1 ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ACCOUNT_REGULATION_TYPE") : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ACCOUNT_REGULATION_METHOD");
        ArrayList<FscAccountRegulationBO> rows = new ArrayList<FscAccountRegulationBO>(fscAccountRegulationPoList.size());
        for (FscAccountRegulationPO fscAccountRegulationPO : fscAccountRegulationPoList) {
            FscAccountRegulationBO regulationBo = new FscAccountRegulationBO();
            BeanUtils.copyProperties((Object)fscAccountRegulationPO, (Object)regulationBo);
            regulationBo.setStatusStr(FscRegulationStatusEnum.getCodeDesc((Integer)regulationBo.getStatus()));
            regulationBo.setRegulationTypeStr((String)regulationTypeMap.get(regulationBo.getRegulationType().toString()));
            rows.add(regulationBo);
        }
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

