/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.esb.FscClaimSendYcCancelService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeClaimBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscAccountChargeClaimBusiServiceImpl
implements FscAccountChargeClaimBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargeClaimBusiServiceImpl.class);
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscClaimSendYcCancelService fscClaimSendYcCancelService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;

    @Override
    @FscDuplicateCommitLimit
    public FscAccountChargeClaimBusiRspBO dealAccountChargeClaim(FscAccountChargeClaimBusiReqBO reqBO) {
        FscAccountChargePO fscAccountChargePo = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (fscAccountChargePo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5145\u503c\u76f8\u5173\u4fe1\u606f!");
        }
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setId(fscAccountChargePo.getAccountId());
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        if (reqBO.getOperationType() == null || reqBO.getOperationType() == 1) {
            if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
                throw new FscBusinessException("190000", "\u5165\u53c2claimNo\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryByClaimNo(reqBO.getClaimNo());
            if (fscRecvClaimPo == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u76f8\u5173\u4fe1\u606f!");
            }
            if (fscRecvClaimPo.getClaimStatus().equals(FscClaimStatusEnum.CLAIM.getCode())) {
                throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886\uff01");
            }
            if (fscAccountChargePo.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) != 0) {
                throw new FscBusinessException("190000", "\u9884\u5b58\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\uff01");
            }
            fscAccountPo.setAdvanceAmount(fscAccountPo.getAdvanceAmount().add(fscAccountChargePo.getChargeAmount()));
            BigDecimal returnedAmount = BigDecimal.ZERO;
            if (fscAccountPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                returnedAmount = fscAccountPo.getOverdraftAmount();
                fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().compareTo(fscAccountChargePo.getChargeAmount()) > 0 ? fscAccountPo.getOverdraftAmount().subtract(fscAccountChargePo.getChargeAmount()) : BigDecimal.ZERO);
                returnedAmount = returnedAmount.subtract(fscAccountPo.getOverdraftAmount());
            }
            fscAccountPo.setReturnedAmount(returnedAmount);
            this.fscAccountMapper.updateAmountByCharge(fscAccountPo);
            FscAccountSerialPO serialPo = new FscAccountSerialPO();
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
            Integer serialNumber = 0;
            if (serialPo != null) {
                serialNumber = serialPo.getSerialNumber();
            }
            ArrayList<FscClaimDetailPO> detailPOList = new ArrayList<FscClaimDetailPO>();
            Object[] objectArray = new Object[1];
            serialNumber = serialNumber + 1;
            objectArray[0] = serialNumber;
            String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
            FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
            fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscClaimDetailPo.setDetailNo(detailNo);
            fscClaimDetailPo.setClaimAmt(fscAccountChargePo.getChargeAmount());
            fscClaimDetailPo.setClaimDate(new Date());
            fscClaimDetailPo.setClaimId(fscRecvClaimPo.getClaimId());
            fscClaimDetailPo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
            fscClaimDetailPo.setCustomerNo(Long.valueOf(fscAccountPo.getOrgCode()));
            fscClaimDetailPo.setCustomerName(fscAccountPo.getOrgName());
            fscClaimDetailPo.setHandleDeptId(reqBO.getYcDeptId());
            fscClaimDetailPo.setHandleDeptName(reqBO.getYcDeptName());
            fscClaimDetailPo.setHandleUserId(reqBO.getYcUserId());
            fscClaimDetailPo.setHandleUserName(reqBO.getYcUserName());
            fscClaimDetailPo.setStatus("1");
            fscClaimDetailPo.setObjectId(fscAccountChargePo.getChargeId());
            fscClaimDetailPo.setObjectNo(fscAccountChargePo.getChargeId().toString());
            detailPOList.add(fscClaimDetailPo);
            int insert = this.fscClaimDetailMapper.insertBatch(detailPOList);
            if (insert < 0) {
                throw new FscBusinessException("190000", "\u9884\u5b58\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            if (serialPo == null) {
                serialPo = new FscAccountSerialPO();
                serialPo.setSerialNumber(serialNumber);
                serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
                serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                this.fscAccountSerialMapper.insert(serialPo);
            } else {
                serialPo.setSerialNumber(serialNumber);
                this.fscAccountSerialMapper.update(serialPo);
            }
            fscRecvClaimPo.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaimPo.setNoClaimAmt(BigDecimal.ZERO);
            this.fscRecvClaimMapper.update(fscRecvClaimPo);
            fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_PASS);
            fscAccountChargePo.setClaimNo(fscRecvClaimPo.getClaimNo());
            fscAccountChargePo.setClaimDetailId(fscClaimDetailPo.getClaimDetailId());
            this.fscAccountChargeMapper.update(fscAccountChargePo);
            this.dealPushYc(fscRecvClaimPo);
        } else {
            fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_REJECT);
            fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.SAVE);
            fscAccountChargePo.setReturnReason(reqBO.getReturnReason());
            this.fscAccountChargeMapper.update(fscAccountChargePo);
        }
        FscAccountChargeClaimBusiRspBO busiRspBO = new FscAccountChargeClaimBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void dealPushYc(FscRecvClaimPO fscRecvClaimPo) {
        FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
        abilityReqBO.setClaimId(fscRecvClaimPo.getClaimId());
        FscPushYcRecvClaimBillAbilityRspBO abilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        FscRecvClaimPO updateVo = new FscRecvClaimPO();
        updateVo.setClaimId(fscRecvClaimPo.getClaimId());
        updateVo.setStatus(Integer.valueOf(1));
        this.fscRecvClaimMapper.update(updateVo);
    }
}

