/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.busi.api.FscOrderInvoiceItemAddBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceItemAddBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceItemAddBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderInvoiceItemAddBusiServiceImpl
implements FscOrderInvoiceItemAddBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;

    @Override
    public FscOrderInvoiceItemAddBusiRspBO addOrderInvoiceItem(FscOrderInvoiceItemAddBusiReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPo = this.fscOrderMapper.getModelBy(orderPO);
        if (fscOrderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList fscOrderItemPOS = new ArrayList();
        BigDecimal totalCharge = BigDecimal.ZERO;
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            totalCharge = splitOrderBO.getAmount().setScale(2, 4);
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderRelationPOS.add(fscOrderRelationPO);
                fscOrderItemPOS.addAll(JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class));
                for (FscOrderItemPO fscOrderItemPO : fscOrderItemPOS) {
                    fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                }
            }
        }
        if (CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        FscOrderPO updateVo = new FscOrderPO();
        updateVo.setFscOrderId(reqBO.getFscOrderId());
        updateVo.setTotalCharge(totalCharge);
        this.fscOrderMapper.updateTotalChargeAdd(updateVo);
        if (!CollectionUtils.isEmpty(reqBO.getFscShouldPayPOS())) {
            this.fscShouldPayMapper.updateStatusByBatch(reqBO.getFscShouldPayPOS());
        }
        this.syncOrderStatus(reqBO.getFscOrderId());
        FscOrderInvoiceItemAddBusiRspBO rspBO = new FscOrderInvoiceItemAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }
}

