/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscMerchantPayeeBO;
import com.tydic.fsc.common.ability.api.FscMerchantPayeeListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantPayeeListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantPayeeListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantPayeeListQueryAbilityService"})
public class FscMerchantPayeeListQueryAbilityServiceImpl
implements FscMerchantPayeeListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantPayeeListQueryAbilityServiceImpl.class);
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;

    @PostMapping(value={"query"})
    public FscMerchantPayeeListQueryAbilityRspBO query(@RequestBody FscMerchantPayeeListQueryAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u6536\u6b3e\u8d26\u6237\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscMerchantPayeeListQueryAbilityRspBO retBo = new FscMerchantPayeeListQueryAbilityRspBO();
        FscMerchantPayeePO fscMerchantPayeePO = (FscMerchantPayeePO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscMerchantPayeePO.class);
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setPageNo(reqBO.getPageNo().intValue());
        List payeePOList = this.fscMerchantPayeeMapper.getPayeeListPage(fscMerchantPayeePO, page);
        ArrayList<FscMerchantPayeeBO> rows = new ArrayList<FscMerchantPayeeBO>();
        if (!CollectionUtils.isEmpty((Collection)payeePOList)) {
            Map<String, String> payTypeMap = this.getDicMap();
            for (FscMerchantPayeePO f : payeePOList) {
                FscMerchantPayeeBO fscMerchantPayeeBO = (FscMerchantPayeeBO)JSON.parseObject((String)JSONObject.toJSONString((Object)f), FscMerchantPayeeBO.class);
                FscMerchantPO merchantPo = new FscMerchantPO();
                merchantPo.setMerchantId(f.getMerchantId());
                merchantPo = this.fscMerchantMapper.getModelBy(merchantPo);
                if (merchantPo != null && merchantPo.getPayType() != null) {
                    fscMerchantPayeeBO.setPayType(merchantPo.getPayType().toString());
                    fscMerchantPayeeBO.setPayTypeStr(payTypeMap.get(fscMerchantPayeeBO.getPayType()));
                }
                rows.add(fscMerchantPayeeBO);
            }
        }
        retBo.setPageNo(Integer.valueOf(page.getPageNo()));
        retBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retBo.setRows(rows);
        retBo.setTotal(Integer.valueOf(page.getTotalPages()));
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u6536\u6b3e\u8d26\u6237\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private Map<String, String> getDicMap() {
        HashMap dicMap = new HashMap(16);
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        queryPo.setPCode("MERCHANT_PAY_TYPE");
        List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
        Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
        return map;
    }
}

