/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.bo.FscSyncYcPayResultSettleLineBO;
import com.tydic.fsc.common.busi.api.FscSyncYcPayResultBusiService;
import com.tydic.fsc.common.busi.bo.FscSyncYcPayResultBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSyncYcPayResultBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayConfirmAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayConfirmAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayConfirmAbilityRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscSyncYcPayResultBusiServiceImpl
implements FscSyncYcPayResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscSyncYcPayResultBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscPayConfirmAbilityService fscPayConfirmAbilityService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;

    @Override
    @FscDuplicateCommitLimit
    public FscSyncYcPayResultBusiRspBO syncYcPayResult(FscSyncYcPayResultBusiReqBO reqBO) {
        FscSyncYcPayResultBusiRspBO rspBO = new FscSyncYcPayResultBusiRspBO();
        log.info("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)reqBO)));
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setObjectId(reqBO.getPAY_ID());
        logAbilityReqBO.setObjectNo(reqBO.getPAY_NO());
        logAbilityReqBO.setType(FscConstants.FscPushType.PAY_RESULT);
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)((Object)reqBO)));
        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
        FscOrderPO queryVo = new FscOrderPO();
        queryVo.setOrderNo(reqBO.getPAY_NO());
        queryVo.setFscOrderId(reqBO.getPAY_ID());
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(queryVo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f!");
        }
        rspBO.setFscOrderId(modelBy.getFscOrderId());
        BigDecimal totalPayAmount = reqBO.getPAY_OFFINE_AMT();
        if (reqBO.getPAY_BANK_AMT() != null) {
            totalPayAmount = reqBO.getPAY_OFFINE_AMT().add(reqBO.getPAY_BANK_AMT());
        }
        if (totalPayAmount.compareTo(modelBy.getToPayAmount()) > 0) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u5355\u672a\u4ed8\u91d1\u989d!");
        }
        LinkedList<FscShouldPayPO> shouldUpdateList = new LinkedList<FscShouldPayPO>();
        if (totalPayAmount.compareTo(modelBy.getToPayAmount()) == 0) {
            FscPayConfirmAbilityReqBO abilityReqBO = new FscPayConfirmAbilityReqBO();
            abilityReqBO.setFscOrderIds(Collections.singletonList(modelBy.getFscOrderId()));
            abilityReqBO.setPayFlag(Boolean.valueOf(true));
            abilityReqBO.setUserName(reqBO.getPERSON_NAME());
            abilityReqBO.setUserId(Long.valueOf(reqBO.getPERSON_ID()));
            abilityReqBO.setYcPayFlag(Boolean.valueOf(true));
            FscPayConfirmAbilityRspBO fscPayConfirmAbilityRspBO = this.fscPayConfirmAbilityService.dealPayConfirm(abilityReqBO);
            if (!fscPayConfirmAbilityRspBO.getRespCode().equals("0000")) {
                log.error("\u8c03\u7528\u6d41\u7a0b\u5931\u8d25\uff01" + fscPayConfirmAbilityRspBO.getRespDesc());
                throw new FscBusinessException(fscPayConfirmAbilityRspBO.getRespCode(), fscPayConfirmAbilityRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty(reqBO.getSettleInfoList())) {
                List shouldPayList = this.fscShouldPayMapper.getByFscOrderId(reqBO.getPAY_ID());
                for (FscShouldPayPO fscShouldPayPo : shouldPayList) {
                    fscShouldPayPo.setToPayAmount(BigDecimal.ZERO);
                    fscShouldPayPo.setPayingAmount(BigDecimal.ZERO);
                    fscShouldPayPo.setPaidAmount(fscShouldPayPo.getPayAmount());
                    shouldUpdateList.add(fscShouldPayPo);
                }
            }
        }
        modelBy.setPaidAmount(modelBy.getPaidAmount().add(totalPayAmount));
        modelBy.setToPayAmount(modelBy.getToPayAmount().subtract(totalPayAmount));
        modelBy.setPayTime(reqBO.getPAY_TIME());
        this.fscOrderMapper.updatePaidAmount(modelBy);
        if (CollectionUtils.isEmpty(reqBO.getSettleInfoList())) {
            HashMap<Long, BigDecimal> payAmountMap = new HashMap<Long, BigDecimal>(reqBO.getSettleInfoList().size());
            for (FscSyncYcPayResultSettleLineBO settleLineBo : reqBO.getSettleInfoList()) {
                payAmountMap.put(settleLineBo.getPC_SETTLE_ID(), settleLineBo.getPAY_AMT());
            }
            List shouldPayList = this.fscShouldPayMapper.getByFscOrderId(reqBO.getPAY_ID());
            if (CollectionUtils.isEmpty((Collection)shouldPayList)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u76f8\u5173\u4fe1\u606f!");
            }
            for (FscShouldPayPO fscShouldPayPo : shouldPayList) {
                if (payAmountMap.get(fscShouldPayPo.getObjectId()) == null) continue;
                BigDecimal payAmt = (BigDecimal)payAmountMap.get(fscShouldPayPo.getObjectId());
                fscShouldPayPo.setPayingAmount(fscShouldPayPo.getPayingAmount().subtract(payAmt));
                fscShouldPayPo.setPaidAmount(fscShouldPayPo.getPayAmount().add(payAmt));
                fscShouldPayPo.setToPayAmount(fscShouldPayPo.getToPayAmount().subtract(payAmt));
                shouldUpdateList.add(fscShouldPayPo);
            }
        }
        if (!CollectionUtils.isEmpty(shouldUpdateList)) {
            this.fscShouldPayMapper.updateAmountBatch(shouldUpdateList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

