/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.bo.FscSyncYcRecvClaimDetailBO;
import com.tydic.fsc.common.busi.api.FscSyncYcRecvClaimDetailBusiService;
import com.tydic.fsc.common.busi.bo.FscSyncYcRecvClaimDetailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSyncYcRecvClaimDetailBusiRspBO;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscSyncYcRecvClaimDetailBusiServiceImpl
implements FscSyncYcRecvClaimDetailBusiService {
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;

    @Override
    public FscSyncYcRecvClaimDetailBusiRspBO dealYcRecvClaimDetail(FscSyncYcRecvClaimDetailBusiReqBO reqBO) {
        this.valid(reqBO);
        FscRecvClaimPO fscRecvClaimPO = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u8ba4\u9886\u4fe1\u606f\uff01");
        }
        ArrayList<FscClaimDetailPO> detailList = new ArrayList<FscClaimDetailPO>();
        ArrayList<Long> claimDetailList = new ArrayList<Long>();
        BigDecimal claimAmt = BigDecimal.ZERO;
        FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
        eternalPo.setPCode("FSC_YC_CLAIM_TYPE");
        Map<String, String> dicMap = this.getDicMap(eternalPo);
        for (FscSyncYcRecvClaimDetailBO ycDetailBO : reqBO.getClaimList()) {
            this.validItem(ycDetailBO);
            claimDetailList.add(ycDetailBO.getClaimDetailId());
            claimAmt = claimAmt.add(ycDetailBO.getClaimAmt());
            FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
            claimDetailPO.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            claimDetailPO.setYcClaimDetailId(ycDetailBO.getClaimDetailId());
            claimDetailPO.setClaimAmt(ycDetailBO.getClaimAmt());
            claimDetailPO.setClaimDate(ycDetailBO.getClaimDate());
            claimDetailPO.setNoClaimAmt(ycDetailBO.getNoClaimAmt());
            claimDetailPO.setCancelClaimDate(ycDetailBO.getCancelClaimDate());
            claimDetailPO.setStatus(ycDetailBO.getStatus().toString());
            claimDetailPO.setObjectId(ycDetailBO.getBillId());
            claimDetailPO.setObjectNo(ycDetailBO.getBillNo());
            claimDetailPO.setSysSource(Integer.valueOf(2));
            claimDetailPO.setHandleUserId(ycDetailBO.getHandlerUserId());
            claimDetailPO.setHandleUserName(ycDetailBO.getHandlerUserName());
            claimDetailPO.setHandleDeptId(Long.valueOf(ycDetailBO.getHandlerDeptId()));
            claimDetailPO.setHandleDeptName(ycDetailBO.getHandlerDeptName());
            claimDetailPO.setClaimType(dicMap.get(ycDetailBO.getClaimType()));
            detailList.add(claimDetailPO);
        }
        FscClaimDetailPO queryVo = new FscClaimDetailPO();
        queryVo.setYcDetailIdList(claimDetailList);
        List list = this.fscClaimDetailMapper.getList(queryVo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("198888", "\u4e1a\u8d22\u660e\u7ec6id\u6613\u8d2d\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        if (fscRecvClaimPO.getNoClaimAmt().compareTo(claimAmt) < 0) {
            throw new FscBusinessException("198888", "\u8ba4\u9886\u5931\u8d25,\u8ba4\u9886\u91d1\u989d[" + claimAmt + "]\u4e0d\u80fd\u5927\u4e8e\u672a\u8ba4\u9886\u91d1\u989d[" + fscRecvClaimPO.getNoClaimAmt() + "]");
        }
        fscRecvClaimPO.setNoClaimAmt(fscRecvClaimPO.getNoClaimAmt().subtract(claimAmt));
        if (fscRecvClaimPO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscRecvClaimPO.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaimPO.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
        }
        if (fscRecvClaimPO.getNoClaimAmt().compareTo(fscRecvClaimPO.getRecvAmt()) != 0) {
            fscRecvClaimPO.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        }
        this.fscClaimDetailMapper.insertBatch(detailList);
        this.fscRecvClaimMapper.update(fscRecvClaimPO);
        FscSyncYcRecvClaimDetailBusiRspBO rspBO = new FscSyncYcRecvClaimDetailBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validItem(FscSyncYcRecvClaimDetailBO detailBO) {
        if (detailBO.getBillId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[billId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getClaimDetailId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimDetailId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getBillNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[billNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getClaimAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getNoClaimAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[noClaimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getStatus())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[status]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getClaimType())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerUserId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerUserName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerDeptId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerDeptName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void valid(FscSyncYcRecvClaimDetailBusiReqBO reqBO) {
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRecvAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[recvAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getNoClaimAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[noClaimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getClaimList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getExernalCode, FscDicDictionaryExernalPO::getCode));
    }
}

