/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscAccountBillListBo;
import com.tydic.fsc.common.ability.api.FscAccountBillListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityRspBO;
import com.tydic.fsc.common.atom.api.FscGetStateListOfConfTabAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.ConfTabStatePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountBillListQueryAbilityService"})
public class FscAccountBillListQueryAbilityServiceImpl
implements FscAccountBillListQueryAbilityService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscGetStateListOfConfTabAtomService fscGetStateListOfConfTabAtomService;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountBillList"})
    public FscAccountBillListQueryAbilityRspBO qryAccountBillList(@RequestBody FscAccountBillListQueryAbilityReqBO reqBO) {
        List fscAccountBillListBoList;
        FscAccountBillListQueryAbilityRspBO rspBO = new FscAccountBillListQueryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setAccountId(reqBO.getAccountId());
        fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
        fscPayLogPO.setUserName(reqBO.getUserNameWeb());
        fscPayLogPO.setIsBack(reqBO.getIsBack());
        fscPayLogPO.setBusiTimeStart(reqBO.getBusiTimeBegin());
        fscPayLogPO.setBusiTimeEnd(reqBO.getBusiTimeEnd());
        fscPayLogPO.setBusiOrderNo(reqBO.getBusiOrderNo());
        fscPayLogPO.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPO.setBusiCategoryList(reqBO.getBusiCategoryList());
        fscPayLogPO.setFscOrderNo(reqBO.getFscOrderNo());
        fscPayLogPO.setAcceptCode(reqBO.getAcceptCode());
        fscPayLogPO.setPayBusiness(reqBO.getPayBusiness());
        fscPayLogPO.setPayeeId(reqBO.getPayeeId());
        fscPayLogPO.setBusiOrderNoList(reqBO.getBusiOrderNoList());
        fscPayLogPO.setIsOverPay(reqBO.getIsOverPay());
        fscPayLogPO.setIsBackList(reqBO.getIsBackList());
        if (!CollectionUtils.isEmpty((Collection)fscPayLogPO.getIsBackList())) {
            for (Integer backItem : fscPayLogPO.getIsBackList()) {
                if (backItem == 0) {
                    fscPayLogPO.setNotBack(Integer.valueOf(1));
                }
                if (backItem == 1) {
                    fscPayLogPO.setPartBack(Integer.valueOf(1));
                }
                if (backItem != 2) continue;
                fscPayLogPO.setBack(Integer.valueOf(1));
            }
        }
        fscPayLogPO.setOrderBy("busi_time asc");
        List<String> tabIdList = reqBO.getTabIdList().stream().map(String::valueOf).collect(Collectors.toList());
        Map<String, ConfTabStatePO> stateMap = this.fscGetStateListOfConfTabAtomService.getStateList(tabIdList);
        ConfTabStatePO confTabStatePo = stateMap.get(reqBO.getTabId().toString());
        if (confTabStatePo == null) {
            throw new FscBusinessException("198888", "\u9875\u7b7e\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a\uff01\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\uff01");
        }
        if ("1".equals(confTabStatePo.getStatusCode())) {
            List fscPayLogPOList = this.fscPayLogMapper.getBillListPage(fscPayLogPO, page);
            if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                return rspBO;
            }
            fscAccountBillListBoList = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscAccountBillListBo.class);
            for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListBoList) {
                String claimNo = "";
                List claimDetailPOList = this.fscClaimDetailMapper.getListByOrderCode(fscAccountBillListBo.getBusiOrderNo());
                if (!CollectionUtils.isEmpty((Collection)claimDetailPOList)) {
                    for (FscClaimDetailPO fscClaimDetailPO : claimDetailPOList) {
                        claimNo = claimNo.replace(fscClaimDetailPO.getClaimNo() + ",", "");
                        claimNo = claimNo + fscClaimDetailPO.getClaimNo() + ",";
                    }
                    if (claimNo.endsWith(",")) {
                        claimNo = claimNo.substring(0, claimNo.length() - 1);
                    }
                }
                fscAccountBillListBo.setClaimNo(claimNo);
                fscPayLogPO = new FscPayLogPO();
                fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
                busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
                fscPayLogPO.setBusiCategoryList(busiCategoryList);
                fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
                fscPayLogPO = this.fscPayLogMapper.getLastLogByOrderNo(fscPayLogPO);
                fscAccountBillListBo.setOverdraftBeforeAmount(fscPayLogPO.getOverdraftBeforeAmount());
                fscAccountBillListBo.setOverdraftAfterAmount(fscPayLogPO.getOverdraftAfterAmount());
                if (fscAccountBillListBo.getNotBackAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    fscAccountBillListBo.setIsBack("\u5df2\u8fd8\u6b3e");
                    continue;
                }
                if (fscAccountBillListBo.getReimbursementAmount().compareTo(BigDecimal.ZERO) == 0) {
                    fscAccountBillListBo.setIsBack("\u672a\u8fd8\u6b3e");
                    continue;
                }
                fscAccountBillListBo.setIsBack("\u90e8\u5206\u8fd8\u6b3e");
            }
        } else if ("2".equals(confTabStatePo.getStatusCode())) {
            List fscPayLogPOList = this.fscPayLogMapper.getBeforeBillListPage(fscPayLogPO, page);
            if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                return rspBO;
            }
            fscAccountBillListBoList = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscAccountBillListBo.class);
            FscAccountPO fscAccountPO = new FscAccountPO();
            fscAccountPO.setOrgId(reqBO.getOrgIdWeb());
            fscAccountPO.setBusiType(FscConstants.FscBusiType.ELECTRONIC.toString());
            fscAccountPO = this.fscAccountMapper.getModelBy(fscAccountPO);
            BigDecimal availableAdvanceAmount = fscAccountPO.getAdvanceAmount().subtract(fscAccountPO.getUseAmount()).subtract(fscAccountPO.getFreezeAmount()).subtract(fscAccountPO.getDistributeAdvanceAmount());
            for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListBoList) {
                fscAccountBillListBo.setAvailableAdvanceAmount(availableAdvanceAmount);
                fscPayLogPO = new FscPayLogPO();
                fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
                busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_REFUND);
                fscPayLogPO.setBusiCategoryList(busiCategoryList);
                fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
                fscPayLogPO = this.fscPayLogMapper.getLastLogByOrderNo(fscPayLogPO);
                fscAccountBillListBo.setOverdraftBeforeAmount(fscPayLogPO.getOverdraftBeforeAmount());
                fscAccountBillListBo.setOverdraftAfterAmount(fscPayLogPO.getOverdraftAfterAmount());
            }
        } else {
            if ("3".equals(confTabStatePo.getStatusCode())) {
                fscPayLogPO.setIsBooked(FscConstants.IsBooked.YES);
            } else {
                fscPayLogPO.setIsBooked(FscConstants.IsBooked.NO);
            }
            List fscPayLogPOList = this.fscPayLogMapper.getCreditListPage(fscPayLogPO, page);
            fscAccountBillListBoList = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscAccountBillListBo.class);
            for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListBoList) {
                String claimNo = "";
                Date claimDate = null;
                List claimDetailPOList = this.fscClaimDetailMapper.getListByOrderCode(fscAccountBillListBo.getBusiOrderNo());
                if (!CollectionUtils.isEmpty((Collection)claimDetailPOList)) {
                    for (FscClaimDetailPO fscClaimDetailPO : claimDetailPOList) {
                        claimNo = claimNo.replace(fscClaimDetailPO.getClaimNo() + ",", "");
                        claimNo = claimNo + fscClaimDetailPO.getClaimNo() + ",";
                    }
                    if (claimNo.endsWith(",")) {
                        claimNo = claimNo.substring(0, claimNo.length() - 1);
                    }
                    claimDate = ((FscClaimDetailPO)claimDetailPOList.get(0)).getClaimDate();
                }
                fscAccountBillListBo.setClaimNo(claimNo);
                fscPayLogPO = new FscPayLogPO();
                fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_PAY);
                busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_REFUND);
                fscPayLogPO.setBusiCategoryList(busiCategoryList);
                fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
                fscPayLogPO = this.fscPayLogMapper.getLastLogByOrderNo(fscPayLogPO);
                fscAccountBillListBo.setBusiBeforeAmount(fscPayLogPO.getBusiBeforeAmount());
                fscAccountBillListBo.setBusiAfterAmount(fscPayLogPO.getBusiAfterAmount());
                if (fscAccountBillListBo.getNotBackAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    fscAccountBillListBo.setIsBack("\u5df2\u8fd8\u6b3e");
                    fscAccountBillListBo.setClaimDate(claimDate);
                    continue;
                }
                if (fscAccountBillListBo.getBusiAmount().compareTo(fscAccountBillListBo.getNotBackAmt()) == 0) {
                    fscAccountBillListBo.setIsBack("\u672a\u8fd8\u6b3e");
                    continue;
                }
                fscAccountBillListBo.setIsBack("\u90e8\u5206\u8fd8\u6b3e");
            }
        }
        rspBO.setRows(fscAccountBillListBoList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    @PostMapping(value={"qryAccountBillListWelfare"})
    public FscAccountBillListQueryAbilityRspBO qryAccountBillListWelfare(@RequestBody FscAccountBillListQueryAbilityReqBO reqBO) {
        List fscAccountBillListBoList;
        FscAccountBillListQueryAbilityRspBO rspBO = new FscAccountBillListQueryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        Page page = new Page();
        Page noPage = new Page();
        noPage.setPageSize(-1);
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setAccountId(reqBO.getAccountId());
        fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
        fscPayLogPO.setUserName(reqBO.getUserNameWeb());
        fscPayLogPO.setIsBack(reqBO.getIsBack());
        fscPayLogPO.setBusiTimeStart(reqBO.getBusiTimeBegin());
        fscPayLogPO.setBusiTimeEnd(reqBO.getBusiTimeEnd());
        fscPayLogPO.setBusiOrderNo(reqBO.getBusiOrderNo());
        fscPayLogPO.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPO.setBusiCategoryList(reqBO.getBusiCategoryList());
        fscPayLogPO.setFscOrderNo(reqBO.getFscOrderNo());
        fscPayLogPO.setAcceptCode(reqBO.getAcceptCode());
        fscPayLogPO.setPayBusiness(reqBO.getPayBusiness());
        fscPayLogPO.setPayeeId(reqBO.getPayeeId());
        fscPayLogPO.setBusiOrderNoList(reqBO.getBusiOrderNoList());
        fscPayLogPO.setIsOverPay(reqBO.getIsOverPay());
        fscPayLogPO.setAccountType(reqBO.getAccountType());
        fscPayLogPO.setWelfareChargeCode(reqBO.getWelfareChargeCode());
        fscPayLogPO.setWelfarePointCode(reqBO.getWelfarePointCode());
        fscPayLogPO.setWelfarePointName(reqBO.getWelfarePointName());
        fscPayLogPO.setOrderBy("busi_time asc");
        fscPayLogPO.setTabId(reqBO.getTabId());
        if ("1".equals(reqBO.getTagInfo())) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(2);
            list.add(3);
            fscPayLogPO.setAdvancePayTypeList(list);
            List fscPayLogPOList = this.fscPayLogMapper.getBillListPageEmployee(fscPayLogPO, page);
            for (Object po : fscPayLogPOList) {
                if (po.getBusiAmount().compareTo(BigDecimal.ZERO) < 0) {
                    po.setBusiAmount(po.getBusiAmount().abs());
                }
                if (po.getNotBackAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                po.setNotBackAmt(po.getNotBackAmt().abs());
            }
            List fscPayLogPOListTotal = this.fscPayLogMapper.getBillListPageEmployee(fscPayLogPO, noPage);
            for (FscPayLogPO po : fscPayLogPOListTotal) {
                if (po.getBusiAmount().compareTo(BigDecimal.ZERO) < 0) {
                    po.setBusiAmount(po.getBusiAmount().abs());
                }
                if (po.getNotBackAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                po.setNotBackAmt(po.getNotBackAmt().abs());
            }
            BigDecimal totalBusiAmount = fscPayLogPOListTotal.stream().map(FscPayLogPO::getBusiAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalNotBackAmount = fscPayLogPOListTotal.stream().map(FscPayLogPO::getNotBackAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            rspBO.setTotalBusiAmount(totalBusiAmount);
            rspBO.setTotalNotBackAmount(totalNotBackAmount);
            if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                return rspBO;
            }
            fscAccountBillListBoList = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscAccountBillListBo.class);
            for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListBoList) {
                String claimNo = "";
                Date claimDate = null;
                List claimDetailPOList = this.fscClaimDetailMapper.getListByOrderCode(fscAccountBillListBo.getBusiOrderNo());
                if (!CollectionUtils.isEmpty((Collection)claimDetailPOList)) {
                    for (FscClaimDetailPO fscClaimDetailPO : claimDetailPOList) {
                        claimNo = claimNo.replace(fscClaimDetailPO.getClaimNo() + ",", "");
                        claimNo = claimNo + fscClaimDetailPO.getClaimNo() + ",";
                    }
                    if (claimNo.endsWith(",")) {
                        claimNo = claimNo.substring(0, claimNo.length() - 1);
                    }
                    claimDate = ((FscClaimDetailPO)claimDetailPOList.get(0)).getClaimDate();
                }
                fscAccountBillListBo.setClaimNo(claimNo);
                fscPayLogPO = new FscPayLogPO();
                fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_WELFARE_PAY);
                busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_WELFARE_REFUND);
                fscPayLogPO.setBusiCategoryList(busiCategoryList);
                fscPayLogPO = this.fscPayLogMapper.getLastLogByOrderNo(fscPayLogPO);
                fscAccountBillListBo.setOverdraftBeforeAmount(fscPayLogPO.getOverdraftBeforeAmount());
                fscAccountBillListBo.setOverdraftAfterAmount(fscPayLogPO.getOverdraftAfterAmount());
                if (fscAccountBillListBo.getNotBackAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    fscAccountBillListBo.setIsBack("\u5df2\u8fd8\u6b3e");
                } else if (fscAccountBillListBo.getReimbursementAmount().compareTo(BigDecimal.ZERO) == 0) {
                    fscAccountBillListBo.setIsBack("\u672a\u8fd8\u6b3e");
                } else {
                    fscAccountBillListBo.setIsBack("\u90e8\u5206\u8fd8\u6b3e");
                }
                fscAccountBillListBo.setBusiOrderNo(null == fscAccountBillListBo.getBusiOrderNo() ? fscAccountBillListBo.getFscOrderNo() : fscAccountBillListBo.getBusiOrderNo());
            }
        } else {
            Object po2;
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(4);
            fscPayLogPO.setAdvancePayTypeList(list);
            List fscPayLogPOList = this.fscPayLogMapper.getCreditListPageEmployee(fscPayLogPO, page);
            for (Object po2 : fscPayLogPOList) {
                if (po2.getBusiAmount().compareTo(BigDecimal.ZERO) < 0) {
                    po2.setBusiAmount(po2.getBusiAmount().abs());
                }
                if (po2.getNotBackAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                po2.setNotBackAmt(po2.getNotBackAmt().abs());
            }
            List fscPayLogPOListTotal = this.fscPayLogMapper.getCreditListPageEmployee(fscPayLogPO, noPage);
            po2 = fscPayLogPOListTotal.iterator();
            while (po2.hasNext()) {
                FscPayLogPO po3 = (FscPayLogPO)po2.next();
                if (po3.getBusiAmount().compareTo(BigDecimal.ZERO) < 0) {
                    po3.setBusiAmount(po3.getBusiAmount().abs());
                }
                if (po3.getNotBackAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                po3.setNotBackAmt(po3.getNotBackAmt().abs());
            }
            BigDecimal totalBusiAmount = fscPayLogPOListTotal.stream().map(FscPayLogPO::getBusiAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalNotBackAmount = fscPayLogPOListTotal.stream().map(FscPayLogPO::getNotBackAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            rspBO.setTotalBusiAmount(totalBusiAmount);
            rspBO.setTotalNotBackAmount(totalNotBackAmount);
            fscAccountBillListBoList = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscAccountBillListBo.class);
            for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListBoList) {
                String claimNo = "";
                Date claimDate = null;
                List claimDetailPOList = this.fscClaimDetailMapper.getListByOrderCode(fscAccountBillListBo.getBusiOrderNo());
                if (!CollectionUtils.isEmpty((Collection)claimDetailPOList)) {
                    for (FscClaimDetailPO fscClaimDetailPO : claimDetailPOList) {
                        claimNo = claimNo.replace(fscClaimDetailPO.getClaimNo() + ",", "");
                        claimNo = claimNo + fscClaimDetailPO.getClaimNo() + ",";
                    }
                    if (claimNo.endsWith(",")) {
                        claimNo = claimNo.substring(0, claimNo.length() - 1);
                    }
                    claimDate = ((FscClaimDetailPO)claimDetailPOList.get(0)).getClaimDate();
                }
                fscAccountBillListBo.setClaimNo(claimNo);
                fscAccountBillListBo.setClaimDate(claimDate);
                fscPayLogPO = new FscPayLogPO();
                fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                ArrayList busiCategoryList = new ArrayList();
                busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_WELFARE_PAY);
                busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_WELFARE_REFUND);
                fscPayLogPO.setBusiCategoryList((List)busiCategoryList);
                fscPayLogPO = this.fscPayLogMapper.getLastLogByOrderNo(fscPayLogPO);
                fscAccountBillListBo.setBusiBeforeAmount(fscPayLogPO.getBusiBeforeAmount());
                fscAccountBillListBo.setBusiAfterAmount(fscPayLogPO.getBusiAfterAmount());
                if (fscAccountBillListBo.getNotBackAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    fscAccountBillListBo.setIsBack("\u5df2\u8fd8\u6b3e");
                } else if (fscAccountBillListBo.getBusiAmount().compareTo(fscAccountBillListBo.getNotBackAmt()) == 0) {
                    fscAccountBillListBo.setIsBack("\u672a\u8fd8\u6b3e");
                } else {
                    fscAccountBillListBo.setIsBack("\u90e8\u5206\u8fd8\u6b3e");
                }
                fscAccountBillListBo.setBusiOrderNo(null == fscAccountBillListBo.getBusiOrderNo() ? fscAccountBillListBo.getFscOrderNo() : fscAccountBillListBo.getBusiOrderNo());
            }
        }
        rspBO.setRows(fscAccountBillListBoList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void val(FscAccountBillListQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
    }
}

