/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.common.ability.api.FscClaimDetailsImportAbilityService;
import com.tydic.fsc.common.ability.bo.FscClaimDetailsImportAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscClaimDetailsImportAbilityRspBO;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.ExcelUtils;
import com.tydic.fsc.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscClaimDetailsImportAbilityService"})
public class FscClaimDetailsImportAbilityServiceImpl
implements FscClaimDetailsImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimDetailsImportAbilityServiceImpl.class);
    private static final String NULL_STR = "null";
    private static final String IMPORT_TYPE_ONE = "1";
    private static final String IMPORT_TYPE_TWO = "2";
    @Value(value="${allowImportRowNum:200}")
    private Integer allowImportRowNum;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"dealCreateImport"})
    public FscClaimDetailsImportAbilityRspBO dealCreateImport(@RequestBody FscClaimDetailsImportAbilityReqBO reqBO) {
        List excelData;
        FscClaimDetailsImportAbilityRspBO rspBO = new FscClaimDetailsImportAbilityRspBO();
        this.verification(reqBO);
        File file = FileUtils.getExcelFileByUrl((String)reqBO.getFileUrl());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile("excel" + file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            excelData = ExcelUtils.getExcelData((MultipartFile)multipartFile, (Integer)1);
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u7684\u8ba4\u9886\u660e\u7ec6excel\u6570\u636e:{}", (Object)JSON.toJSONString((Object)excelData));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8ba4\u9886\u660e\u7ec6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new FscBusinessException("191025", "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)excelData)) {
            throw new FscBusinessException("191025", "\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        int size = excelData.size();
        if (size > this.allowImportRowNum) {
            throw new FscBusinessException("191025", "\u6700\u5927\u5141\u8bb8\u5bfc\u5165" + this.allowImportRowNum + "\u884c");
        }
        log.info("\u5bfc\u5165\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)excelData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        ArrayList<FscClaimDetailBO> fscClaimDetailBOS = new ArrayList<FscClaimDetailBO>();
        ArrayList<String> errorInfo = new ArrayList<String>();
        Date claimDate = new Date();
        if (IMPORT_TYPE_ONE.equals(reqBO.getImportType())) {
            ArrayList objNoList = new ArrayList(size);
            for (int j = 0; j < size; ++j) {
                List excelDatum = (List)excelData.get(j);
                if (!StringUtils.isEmpty(excelDatum.get(7)) && !NULL_STR.equals(excelDatum.get(7))) {
                    objNoList.add(excelDatum.get(7));
                    continue;
                }
                errorInfo.add("\u7b2c" + (j + 1) + "\u884c\uff0c\u7b2c8\u5217\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setAcceptOrderCodeList(objNoList);
            fscOrderItemPO.setClaimId(reqBO.getClaimId());
            List fscOrderItemPOList = this.fscOrderItemMapper.getNotClaimSumAmt(fscOrderItemPO);
            Map orderItemPOMap = fscOrderItemPOList.stream().collect(Collectors.toMap(FscOrderItemPO::getAcceptOrderCode, Function.identity()));
            log.debug("\u6279\u91cf\u67e5\u8be2\u7cfb\u7edf\u8ba4\u9886\u5355map: {}", (Object)JSON.toJSONString(orderItemPOMap));
            for (int i = 0; i < size; ++i) {
                List excelDatum = (List)excelData.get(i);
                if (excelDatum.size() < 14) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u4e0d\u5b8c\u6574");
                    continue;
                }
                FscClaimDetailBO fscClaimDetailBO = new FscClaimDetailBO();
                if (!StringUtils.isEmpty(excelDatum.get(0)) && !NULL_STR.equals(excelDatum.get(0))) {
                    try {
                        fscClaimDetailBO.setClaimDetailId(Long.valueOf((String)excelDatum.get(0)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c1\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setHandleUserName((String)excelDatum.get(1));
                fscClaimDetailBO.setOperatorName((String)excelDatum.get(1));
                if (!StringUtils.isEmpty(excelDatum.get(2)) && !NULL_STR.equals(excelDatum.get(2))) {
                    try {
                        fscClaimDetailBO.setHandleUserId(Long.valueOf((String)excelDatum.get(2)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c3\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setHandleDeptName((String)excelDatum.get(3));
                if (!StringUtils.isEmpty(excelDatum.get(4)) && !NULL_STR.equals(excelDatum.get(4))) {
                    try {
                        fscClaimDetailBO.setHandleDeptId(Long.valueOf((String)excelDatum.get(4)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c5\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setOperationName((String)excelDatum.get(5));
                fscClaimDetailBO.setClaimTypeStr((String)excelDatum.get(6));
                fscClaimDetailBO.setObjectNo((String)excelDatum.get(7));
                fscClaimDetailBO.setFscOrderNo((String)excelDatum.get(8));
                if (!StringUtils.isEmpty(excelDatum.get(9)) && !NULL_STR.equals(excelDatum.get(9))) {
                    try {
                        fscClaimDetailBO.setBillTime(DateUtil.strToDate((String)((String)excelDatum.get(9))));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c10\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                if (!StringUtils.isEmpty(excelDatum.get(10)) && !NULL_STR.equals(excelDatum.get(10))) {
                    try {
                        fscClaimDetailBO.setClaimAmt(new BigDecimal((String)excelDatum.get(10)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c11\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                BigDecimal lastClaimAmt = null;
                if (orderItemPOMap.get(fscClaimDetailBO.getObjectNo()) != null) {
                    if (((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getClaimAmtSelf().compareTo(BigDecimal.ZERO) > 0) {
                        throw new FscBusinessException("191025", "\u7b2c" + (i + 1) + "\u884c,\u6b64\u4e3a\u90e8\u5206\u8ba4\u9886\u5355\uff0c\u4e0d\u53ef\u91cd\u590d\u8ba4\u9886");
                    }
                } else {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c,\u7cfb\u7edf\u65e0\u5339\u914d\u8ba4\u9886\u5355\u4fe1\u606f");
                    continue;
                }
                lastClaimAmt = ((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getAmt().subtract(((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getClaimAmt());
                if (fscClaimDetailBO.getClaimAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u4e3a\u96f6");
                    continue;
                }
                if (lastClaimAmt.compareTo(fscClaimDetailBO.getClaimAmt()) < 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u8d85\u8fc7\u5269\u4f59\u53ef\u8ba4\u9886\u91d1\u989d");
                    continue;
                }
                BigDecimal notClaimAmt = lastClaimAmt.subtract(fscClaimDetailBO.getClaimAmt());
                fscClaimDetailBO.setNoClaimAmt(notClaimAmt);
                if (!StringUtils.isEmpty(excelDatum.get(12)) && !NULL_STR.equals(excelDatum.get(12))) {
                    try {
                        fscClaimDetailBO.setClaimDate(DateUtil.strToDate((String)((String)excelDatum.get(12))));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c13\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setSysSourceStr((String)excelDatum.get(13));
                if (excelDatum.size() > 14 && !StringUtils.isEmpty(excelDatum.get(14)) && !NULL_STR.equals(excelDatum.get(14))) {
                    try {
                        fscClaimDetailBO.setCancelClaimDate(DateUtil.strToDate((String)((String)excelDatum.get(14))));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c15\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setClaimDate(claimDate);
                this.transformSettleClaimType(((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getOrderSource(), ((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getOrderType(), fscClaimDetailBO);
                fscClaimDetailBO.setFscOrderId(((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getFscOrderId());
                fscClaimDetailBO.setObjectId(((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getAcceptOrderId());
                fscClaimDetailBO.setOrderCode(((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getOrderCode());
                fscClaimDetailBO.setOrderId(((FscOrderItemPO)orderItemPOMap.get(fscClaimDetailBO.getObjectNo())).getOrderId());
                fscClaimDetailBO.setSysSource(Integer.valueOf(1));
                fscClaimDetailBOS.add(fscClaimDetailBO);
            }
            rspBO.setRows(fscClaimDetailBOS);
        } else if (IMPORT_TYPE_TWO.equals(reqBO.getImportType())) {
            ArrayList objNoList = new ArrayList(size);
            for (int j = 0; j < size; ++j) {
                List excelDatum = (List)excelData.get(j);
                if (!StringUtils.isEmpty(excelDatum.get(7)) && !NULL_STR.equals(excelDatum.get(7))) {
                    objNoList.add(excelDatum.get(7));
                    continue;
                }
                errorInfo.add("\u7b2c" + (j + 1) + "\u884c\uff0c\u7b2c8\u5217\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayNoList(objNoList);
            fscShouldPayPO.setClaimId(reqBO.getClaimId());
            List fscShouldPayPOList = this.fscShouldPayMapper.getListWithClaim(fscShouldPayPO);
            Map shouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayNo, Function.identity()));
            log.debug("\u6279\u91cf\u67e5\u8be2\u7cfb\u7edf\u9884\u4ed8\u8ba4\u9886\u5355map: {}", (Object)JSON.toJSONString(shouldPayPOMap));
            for (int i = 0; i < size; ++i) {
                List excelDatum = (List)excelData.get(i);
                if (excelDatum.size() < 13) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u4e0d\u5b8c\u6574");
                    continue;
                }
                FscClaimDetailBO fscClaimDetailBO = new FscClaimDetailBO();
                fscClaimDetailBO.setHandleUserName((String)excelDatum.get(0));
                fscClaimDetailBO.setOperatorName((String)excelDatum.get(0));
                if (!StringUtils.isEmpty(excelDatum.get(1)) && !NULL_STR.equals(excelDatum.get(1))) {
                    try {
                        fscClaimDetailBO.setHandleUserId(Long.valueOf((String)excelDatum.get(1)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c2\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setHandleDeptName((String)excelDatum.get(2));
                if (!StringUtils.isEmpty(excelDatum.get(3)) && !NULL_STR.equals(excelDatum.get(3))) {
                    try {
                        fscClaimDetailBO.setHandleDeptId(Long.valueOf((String)excelDatum.get(3)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c4\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setOperationName((String)excelDatum.get(4));
                fscClaimDetailBO.setClaimTypeStr((String)excelDatum.get(5));
                fscClaimDetailBO.setOrderNo((String)excelDatum.get(6));
                fscClaimDetailBO.setObjectNo((String)excelDatum.get(7));
                fscClaimDetailBO.setOrderCode((String)excelDatum.get(8));
                fscClaimDetailBO.setPayerName((String)excelDatum.get(9));
                fscClaimDetailBO.setBuyerName((String)excelDatum.get(9));
                if (!StringUtils.isEmpty(excelDatum.get(11)) && !NULL_STR.equals(excelDatum.get(11))) {
                    try {
                        fscClaimDetailBO.setClaimAmt(new BigDecimal((String)excelDatum.get(11)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c12\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                if (fscClaimDetailBO.getClaimAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u4e3a\u96f6");
                    continue;
                }
                BigDecimal lastClaimAmt = null;
                if (shouldPayPOMap.get(fscClaimDetailBO.getObjectNo()) != null) {
                    if (((FscShouldPayPO)shouldPayPOMap.get(fscClaimDetailBO.getObjectNo())).getClaimAmtSelf().compareTo(BigDecimal.ZERO) > 0) {
                        throw new FscBusinessException("191025", "\u7b2c" + (i + 1) + "\u884c,\u6b64\u4e3a\u90e8\u5206\u8ba4\u9886\u5355\uff0c\u4e0d\u53ef\u91cd\u590d\u8ba4\u9886");
                    }
                } else {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c,\u7cfb\u7edf\u65e0\u5339\u914d\u8ba4\u9886\u5355\u4fe1\u606f");
                    continue;
                }
                lastClaimAmt = ((FscShouldPayPO)shouldPayPOMap.get(fscClaimDetailBO.getObjectNo())).getShouldPayAmount().subtract(((FscShouldPayPO)shouldPayPOMap.get(fscClaimDetailBO.getObjectNo())).getClaimAmt());
                if (lastClaimAmt.compareTo(fscClaimDetailBO.getClaimAmt()) < 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u8d85\u8fc7\u5269\u4f59\u53ef\u8ba4\u9886\u91d1\u989d");
                    continue;
                }
                BigDecimal notClaimAmt = lastClaimAmt.subtract(fscClaimDetailBO.getClaimAmt());
                fscClaimDetailBO.setNoClaimAmt(notClaimAmt);
                fscClaimDetailBO.setPayerName((String)excelDatum.get(12));
                if (excelDatum.size() > 13 && !StringUtils.isEmpty(excelDatum.get(13)) && !NULL_STR.equals(excelDatum.get(13))) {
                    try {
                        fscClaimDetailBO.setClaimDate(DateUtil.strToDate((String)((String)excelDatum.get(13))));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c14\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                if (excelDatum.size() > 14 && !StringUtils.isEmpty(excelDatum.get(14)) && !NULL_STR.equals(excelDatum.get(14))) {
                    try {
                        fscClaimDetailBO.setCancelClaimDate(DateUtil.strToDate((String)((String)excelDatum.get(14))));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u7b2c15\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                fscClaimDetailBO.setClaimDate(claimDate);
                this.transformAdviceClaimType(((FscShouldPayPO)shouldPayPOMap.get(fscClaimDetailBO.getObjectNo())).getOrderType(), fscClaimDetailBO);
                fscClaimDetailBO.setObjectId(((FscShouldPayPO)shouldPayPOMap.get(fscClaimDetailBO.getObjectNo())).getShouldPayId());
                fscClaimDetailBO.setOrderId(((FscShouldPayPO)shouldPayPOMap.get(fscClaimDetailBO.getObjectNo())).getOrderId());
                fscClaimDetailBO.setSysSource(Integer.valueOf(1));
                fscClaimDetailBOS.add(fscClaimDetailBO);
            }
            rspBO.setRows(fscClaimDetailBOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setErrorInfo(errorInfo);
        return rspBO;
    }

    private void verification(FscClaimDetailsImportAbilityReqBO reqBO) {
        if (null == reqBO.getFileUrl() || "".equals(reqBO.getFileUrl())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fileUrl]\u4e3a\u7a7a");
        }
    }

    private void transformSettleClaimType(Integer orderSource, Integer orderType, FscClaimDetailBO fscClaimDetailBo) {
        if (!StringUtils.isEmpty((Object)fscClaimDetailBo.getSysSource()) && fscClaimDetailBo.getSysSource() == 2 && !StringUtils.isEmpty((Object)orderType)) {
            fscClaimDetailBo.setClaimType(orderType.toString());
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)orderType.toString()));
        }
        if (orderType != null && orderType.equals(FscOrderTypeEnum.INDIVIDUALLY.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCode());
        } else if (orderType != null && orderType.equals(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode());
        }
        if (orderSource.equals(FscOrderSourceEnum.ELECTRIC_AREA.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode());
        } else if (orderSource.equals(FscOrderSourceEnum.ELECTRIC_MARKET.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode());
        }
    }

    private void transformAdviceClaimType(Integer orderType, FscClaimDetailBO fscClaimDetailBO) {
        if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getSysSource()) && fscClaimDetailBO.getSysSource() == 2 && !StringUtils.isEmpty((Object)orderType)) {
            fscClaimDetailBO.setClaimType(orderType.toString());
            fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)orderType.toString()));
        }
        if (orderType != null) {
            if (orderType.equals(FscOrderTypeEnum.ELECTRONIC.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.AGREEMENT.getCode()) || orderType.equals(FscOrderTypeEnum.GOODS.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.INDIVIDUALLY.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCodeDesc());
            }
        }
    }
}

