/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscComOrderApprovalAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcPayBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcPayBillAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderApprovalBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderApprovalAbilityService"})
public class FscComOrderApprovalAbilityServiceImpl
implements FscComOrderApprovalAbilityService {
    @Autowired
    private FscComOrderApprovalBusiService fscComOrderApprovalBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscPushYcPayBillAbilityService fscPushYcPayBillAbilityService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderApproval"})
    public FscComOrderApprovalAbilityRspBO dealOrderApproval(@RequestBody FscComOrderApprovalAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.TO_BE_APPROVAL.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191124", "\u5f53\u524d\u4ed8\u6b3e\u5355\u4e0d\u4e3a\u5f85\u5ba1\u6279\u72b6\u6001");
        }
        Integer count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList());
        if (count == 0) {
            this.sendMq(reqBO);
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        FscComOrderApprovalBusiReqBO busiReqBO = new FscComOrderApprovalBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        busiReqBO.setOrderFlow(fscOrder.getOrderFlow());
        busiReqBO.setOrderState(fscOrder.getOrderState());
        busiReqBO.setActualAmount(fscOrder.getActualAmount());
        busiReqBO.setFscOrder(fscOrder);
        busiReqBO.setTotalCharge(fscOrder.getTotalCharge());
        FscComOrderApprovalBusiRspBO busiRspBO = this.fscComOrderApprovalBusiService.dealOrderApproval(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191124", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        if (reqBO.getIsprofess().equals("0") && fscOrder.getOrderFlow() == 1 && reqBO.getAuditResult() == 0 && busiRspBO.getFinish().booleanValue()) {
            FscPushYcPayBillAbilityReqBO pushReqBo = new FscPushYcPayBillAbilityReqBO();
            pushReqBo.setOrderId(reqBO.getOrderId());
            this.fscPushYcPayBillAbilityService.pushYcPayBill(pushReqBo);
        }
        return new FscComOrderApprovalAbilityRspBO();
    }

    private void val(FscComOrderApprovalAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getAuditResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[auditResult]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscComOrderApprovalAbilityReqBO reqBO) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
    }
}

