/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityRspBO;
import com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderSyncAbilityServiceImpl
implements FscComOrderSyncAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Resource(name="fscSyncOrderListMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderListMqServiceProvider;
    @Value(value="${es.FSC_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_SYNC_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public void dealComOrderSyncEs(FscComOrderListSyncAbilityReqBO reqBO) {
        FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
        fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
        ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
        }
    }

    private void writeFailLog(FscComOrderListSyncAbilityReqBO reqBO, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    public void syncAllComOrderList(FscComOrderListSyncAbilityReqBO reqBO) {
        FscOrderPO fscOrderPO = (FscOrderPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderList)) {
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                this.writeFailLog(fscComOrderListSyncAbilityReqBO, JSON.toJSONString((Object)proxySendResult));
            }
        }
    }

    public FscComOrderListSyncAbilityRspBO dealSyncAllOrder(FscComOrderListSyncAbilityReqBO reqBO) {
        if (reqBO.getOrderFlow() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2orderFlow\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO fscOrderPO = (FscOrderPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        fscOrderPO.setOrderBy("CREATE_TIME DESC");
        List fscOrderList = this.fscOrderMapper.getListByCreateTime(fscOrderPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderList)) {
            return new FscComOrderListSyncAbilityRspBO();
        }
        FscComOrderListSyncAbilityRspBO rspBO = new FscComOrderListSyncAbilityRspBO();
        if (reqBO.getIsThread().booleanValue()) {
            ArrayList<FscSyncReqBO> dataList = new ArrayList<FscSyncReqBO>(fscOrderList.size());
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO syncReqBO = new FscSyncReqBO();
                syncReqBO.setFscOrderId(orderPO.getFscOrderId());
                dataList.add(syncReqBO);
            }
            try {
                FscComOrderEsSyncThreadsImpl syncThreads = new FscComOrderEsSyncThreadsImpl();
                if (syncThreads.handleList(dataList, reqBO.getThreadNum(), false).booleanValue()) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                }
            }
            catch (Exception e) {
                rspBO.setRespCode("100001");
                rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
            }
        } else {
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO reqBo = new FscSyncReqBO();
                reqBo.setFscOrderId(orderPO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)reqBo)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
            }
        }
        return null;
    }
}

