/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscDownWriteOffInfoListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscWriteOffInfoListBO;
import com.tydic.fsc.common.ability.bo.FscWriteOffInfoListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscWriteOffInfoListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscDownWriteOffInfoListQueryAbilityService"})
public class FscDownWriteOffInfoListQueryAbilityServiceImpl
implements FscDownWriteOffInfoListQueryAbilityService {
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"downWriteOffInfoListQuery"})
    public FscWriteOffInfoListQueryAbilityRspBO downWriteOffInfoListQuery(@RequestBody FscWriteOffInfoListQueryAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null && CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new BusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355ID\u548c\u8ba2\u5355ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        ArrayList<FscWriteOffInfoListBO> rows = new ArrayList<FscWriteOffInfoListBO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (reqBO.getFscOrderId() != null) {
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            List itemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)itemList)) {
                throw new BusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u660e\u7ec6");
            }
            List orderIds = itemList.stream().map(e -> e.getOrderId()).distinct().collect(Collectors.toList());
            List list = this.fscOrderWriteRelationMapper.getDownWriteOffListByFscOrderId(reqBO.getFscOrderId(), orderIds, page);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (FscOrderPO po : list) {
                    FscWriteOffInfoListBO listBO = new FscWriteOffInfoListBO();
                    listBO.setOrderId(po.getOrderId());
                    listBO.setOrderNo(po.getOrderCodeStr());
                    listBO.setPayOrderId(po.getFscOrderId());
                    listBO.setPayOrderNo(po.getShouldPayNo());
                    listBO.setPayAmt(po.getShouldPayAmount() == null ? BigDecimal.ZERO : po.getShouldPayAmount());
                    listBO.setWriteOffAmt(po.getWriteOffAmount() == null ? BigDecimal.ZERO : po.getWriteOffAmount());
                    listBO.setSelfWriteOffAmt(po.getSelfWriteOffAmount() == null ? BigDecimal.ZERO : po.getSelfWriteOffAmount());
                    listBO.setLeftWriteOffAmt(listBO.getPayAmt().subtract(listBO.getWriteOffAmt()));
                    rows.add(listBO);
                }
            }
        } else {
            List list = this.fscOrderWriteRelationMapper.getDownWriteOffListByFscOrderId(null, reqBO.getOrderIds(), page);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (FscOrderPO po : list) {
                    FscWriteOffInfoListBO listBO = new FscWriteOffInfoListBO();
                    listBO.setOrderId(po.getOrderId());
                    listBO.setOrderNo(po.getOrderCodeStr());
                    listBO.setPayOrderId(po.getFscOrderId());
                    listBO.setPayOrderNo(po.getShouldPayNo());
                    listBO.setPayAmt(po.getShouldPayAmount() == null ? BigDecimal.ZERO : po.getShouldPayAmount());
                    listBO.setWriteOffAmt(po.getWriteOffAmount() == null ? BigDecimal.ZERO : po.getWriteOffAmount());
                    rows.add(listBO);
                }
            }
        }
        FscWriteOffInfoListQueryAbilityRspBO rspBO = new FscWriteOffInfoListQueryAbilityRspBO();
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }
}

