/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscMemInvoiceCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscMemInvoiceCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscMemInvoiceCreateAbilityRspBO;
import com.tydic.fsc.common.ability.api.FscMemFeeAutoBillJobDealAbilityService;
import com.tydic.fsc.common.ability.bo.FscMemFeeAutoBillJobDealReqBO;
import com.tydic.fsc.common.ability.bo.FscMemFeeAutoBillJobDealRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DatesUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMemFeeAutoBillJobDealAbilityService"})
public class FscMemFeeAutoBillJobDealAbilityServiceImpl
implements FscMemFeeAutoBillJobDealAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMemFeeAutoBillJobDealAbilityServiceImpl.class);
    private static final int PAGE_SIZE = 100;
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscMemInvoiceCreateAbilityService fscMemInvoiceCreateAbilityService;

    @PostMapping(value={"dealMemFeeAutoBillJob"})
    public FscMemFeeAutoBillJobDealRspBO dealMemFeeAutoBillJob(@RequestBody FscMemFeeAutoBillJobDealReqBO reqBO) {
        try {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MEMBER_FEE_PAY);
            fscOrderPO.setOrderState(FscConstants.FscServiceOrderState.WAIT_BILL_INVOICE);
            fscOrderPO.setCreateTimeEnd(DatesUtils.getDayEndTime((Date)DatesUtils.dateBefore((Date)new Date(), (int)-91)));
            int count = this.fscOrderMapper.selectCount(fscOrderPO);
            int pageCount = count % 100 == 0 ? count / 100 : count / 100 + 1;
            for (int i = 1; i <= pageCount; ++i) {
                Page page = new Page();
                page.setPageNo(pageCount);
                page.setPageSize(100);
                List fscOrderPOList = this.fscOrderMapper.getListPage(fscOrderPO, page);
                this.dealDate(fscOrderPOList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FscMemFeeAutoBillJobDealRspBO rspBO = new FscMemFeeAutoBillJobDealRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void dealDate(List<FscOrderPO> fscOrderPOList) {
        fscOrderPOList.forEach(e -> {
            FscMemInvoiceCreateAbilityRspBO createAbilityRspBO;
            FscMemInvoiceCreateAbilityReqBO fscMemInvoiceCreateAbilityReqBO = new FscMemInvoiceCreateAbilityReqBO();
            BeanUtils.copyProperties((Object)e, (Object)fscMemInvoiceCreateAbilityReqBO);
            if (Objects.isNull(e.getReceiveType())) {
                fscMemInvoiceCreateAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.SUPPLIER);
            }
            if (Objects.isNull(e.getMakeType())) {
                fscMemInvoiceCreateAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
            }
            fscMemInvoiceCreateAbilityReqBO.setPurchaserId(e.getSupplierId());
            fscMemInvoiceCreateAbilityReqBO.setPurchaserName(e.getSupplierName());
            FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
            fscOrderInvoicePO.setFscOrderId(e.getFscOrderId());
            List invoicePOList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO);
            if (CollectionUtils.isNotEmpty((Collection)invoicePOList)) {
                BeanUtils.copyProperties(invoicePOList.get(0), (Object)fscMemInvoiceCreateAbilityReqBO);
                if (Objects.nonNull(((FscOrderInvoicePO)invoicePOList.get(0)).getInvoiceCategory())) {
                    fscMemInvoiceCreateAbilityReqBO.setInvoiceCategory(((FscOrderInvoicePO)invoicePOList.get(0)).getInvoiceCategory().toString());
                }
            }
            if (!"0000".equals((createAbilityRspBO = this.fscMemInvoiceCreateAbilityService.dealMemInvoiceCreate(fscMemInvoiceCreateAbilityReqBO)).getRespCode())) {
                log.error("\u4f1a\u5458\u8d39\u81ea\u52a8\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\uff1a\u4ed8\u6b3e\u5355\u53f7:" + e.getFscOrderId() + "\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + createAbilityRspBO.getRespDesc());
            }
        });
    }
}

