/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscMerchantPayeeBO;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeDeleteAtomService;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeDeleteAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeDeleteAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeUpdateAtomRspBO;
import com.tydic.fsc.common.ability.api.FscMerchantPayeeUpdateAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantPayeeUpdateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantPayeeUpdateAbilityRspBO;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantPayeeUpdateAbilityService"})
public class FscMerchantPayeeUpdateAbilityServiceImpl
implements FscMerchantPayeeUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantPayeeUpdateAbilityServiceImpl.class);
    @Autowired
    private FscMerchantPayeeCreateAtomService fscMerchantPayeeCreateAtomService;
    @Autowired
    private FscMerchantPayeeUpdateAtomService fscMerchantPayeeUpdateAtomService;
    @Autowired
    private FscMerchantPayeeDeleteAtomService fscMerchantPayeeDeleteAtomService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    private static final String ERROR = "error";
    private static final String CREATE_PAYEE_POS = "createPayeePOS";
    private static final String UPDATE_PAYEE_POS = "updatePayeePOS";
    private static final String DELETE_PAYEE_POS = "deletePayeePOS";

    @PostMapping(value={"updatePayee"})
    public FscMerchantPayeeUpdateAbilityRspBO updatePayee(@RequestBody FscMerchantPayeeUpdateAbilityReqBO reqBO) {
        List deletePayeeBOS;
        List updatePayeeBOS;
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u6536\u6b3e\u8d26\u6237\u7f16\u8f91\u670d\u52a1\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscMerchantPayeeUpdateAbilityRspBO rspBo = new FscMerchantPayeeUpdateAbilityRspBO();
        Map<String, Object> dealMap = this.validateArgs(reqBO);
        if (!StringUtils.isEmpty((Object)dealMap.get(ERROR))) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", dealMap.get(ERROR));
            rspBo.setRespCode("191000");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + dealMap.get(ERROR));
            return rspBo;
        }
        List createPayeeBOS = JSON.parseArray((String)JSONObject.toJSONString((Object)dealMap.get(CREATE_PAYEE_POS)), FscMerchantPayeeBO.class);
        if (!CollectionUtils.isEmpty((Collection)createPayeeBOS)) {
            FscMerchantPayeeCreateAtomReqBO fscMerchantPayeeCreateAtomReqBO = new FscMerchantPayeeCreateAtomReqBO();
            fscMerchantPayeeCreateAtomReqBO.setCreatePayeeBOS(createPayeeBOS);
            FscMerchantPayeeCreateAtomRspBO fscMerchantPayeeCreateAtomRspBO = this.fscMerchantPayeeCreateAtomService.createPayee(fscMerchantPayeeCreateAtomReqBO);
            if (!"0000".equals(fscMerchantPayeeCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u65b0\u589e\u6570\u636e\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(updatePayeeBOS = JSON.parseArray((String)JSONObject.toJSONString((Object)dealMap.get(UPDATE_PAYEE_POS)), FscMerchantPayeeBO.class)))) {
            FscMerchantPayeeUpdateAtomReqBO fscMerchantPayeeUpdateAtomReqBO = new FscMerchantPayeeUpdateAtomReqBO();
            fscMerchantPayeeUpdateAtomReqBO.setUpdatePayeePOS(updatePayeeBOS);
            FscMerchantPayeeUpdateAtomRspBO fscMerchantPayeeUpdateAtomRspBO = this.fscMerchantPayeeUpdateAtomService.updatePayee(fscMerchantPayeeUpdateAtomReqBO);
            if (!"0000".equals(fscMerchantPayeeUpdateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u6570\u636e\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(deletePayeeBOS = JSON.parseArray((String)JSONObject.toJSONString((Object)dealMap.get(DELETE_PAYEE_POS)), FscMerchantPayeeBO.class)))) {
            FscMerchantPayeeDeleteAtomReqBO fscMerchantPayeeDeleteAtomReqBO = new FscMerchantPayeeDeleteAtomReqBO();
            fscMerchantPayeeDeleteAtomReqBO.setDeletePayeePOS(deletePayeeBOS);
            FscMerchantPayeeDeleteAtomRspBO fscMerchantPayeeDeleteAtomRspBO = this.fscMerchantPayeeDeleteAtomService.deletePayee(fscMerchantPayeeDeleteAtomReqBO);
            if (!"0000".equals(fscMerchantPayeeDeleteAtomRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u5220\u9664\u6570\u636e\u5931\u8d25");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u6536\u6b3e\u8d26\u6237\u7f16\u8f91\u670d\u52a1\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)rspBo));
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private Map<String, Object> validateArgs(FscMerchantPayeeUpdateAbilityReqBO reqBo) {
        HashMap<String, Object> dealMap = new HashMap<String, Object>();
        if (reqBo == null) {
            dealMap.put(ERROR, "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return dealMap;
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getPayeeBOList())) {
            dealMap.put(ERROR, "\u6536\u6b3e\u8d26\u6237\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return dealMap;
        }
        ArrayList<FscMerchantPayeeBO> createPayeeBOS = new ArrayList<FscMerchantPayeeBO>();
        ArrayList<FscMerchantPayeeBO> updatePayeeBOS = new ArrayList<FscMerchantPayeeBO>();
        ArrayList<FscMerchantPayeeBO> deletePayeeBOS = new ArrayList<FscMerchantPayeeBO>();
        block5: for (FscMerchantPayeeBO payeeBO : reqBo.getPayeeBOList()) {
            if (StringUtils.isEmpty((Object)payeeBO.getOperType())) {
                dealMap.put(ERROR, "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[operType]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                return dealMap;
            }
            if (StringUtils.isEmpty((Object)payeeBO.getMerchantId())) {
                dealMap.put(ERROR, "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[merchantId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                return dealMap;
            }
            if (StringUtils.isEmpty((Object)payeeBO.getPayeeAccountName())) {
                dealMap.put(ERROR, "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[payeeAccountName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                return dealMap;
            }
            if (StringUtils.isEmpty((Object)payeeBO.getPayeeBankAccount())) {
                dealMap.put(ERROR, "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[payeeBankAccount]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                return dealMap;
            }
            if (StringUtils.isEmpty((Object)payeeBO.getPayeeBankName())) {
                dealMap.put(ERROR, "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[payeeBankName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                return dealMap;
            }
            switch (Integer.parseInt(payeeBO.getOperType())) {
                case 1: {
                    payeeBO = this.getOrgInfo(payeeBO);
                    createPayeeBOS.add(payeeBO);
                    continue block5;
                }
                case 2: {
                    if (payeeBO.getId() == null) {
                        dealMap.put(ERROR, "\u4fee\u6539\u6570\u636e\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[id]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                        return dealMap;
                    }
                    updatePayeeBOS.add(payeeBO);
                    continue block5;
                }
                case 3: {
                    if (payeeBO.getId() == null) {
                        dealMap.put(ERROR, "\u5220\u9664\u6570\u636e\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[id]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                        return dealMap;
                    }
                    deletePayeeBOS.add(payeeBO);
                    continue block5;
                }
            }
            dealMap.put(ERROR, "\u64cd\u4f5c\u7c7b\u578b\u53d6\u503c\u975e\u6cd5\uff0c\u8303\u56f4\uff1a 1:\u65b0\u589e 2:\u4fee\u6539 3:\u5220\u9664 ");
            return dealMap;
        }
        dealMap.put(CREATE_PAYEE_POS, createPayeeBOS);
        dealMap.put(UPDATE_PAYEE_POS, updatePayeeBOS);
        dealMap.put(DELETE_PAYEE_POS, deletePayeeBOS);
        return dealMap;
    }

    public FscMerchantPayeeBO getOrgInfo(FscMerchantPayeeBO payeeBO) {
        FscMerchantPO fscMerchantPO = new FscMerchantPO();
        fscMerchantPO.setMerchantId(payeeBO.getMerchantId());
        fscMerchantPO = this.fscMerchantMapper.getModelBy(fscMerchantPO);
        if (fscMerchantPO != null) {
            UmcEnterpriseOrgQryDetailAbilityReqBO orgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            orgQryDetailAbilityReqBO.setOrgIdWeb(fscMerchantPO.getOrgId());
            UmcEnterpriseOrgQryDetailAbilityRspBO orgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailAbilityReqBO);
            UmcEnterpriseOrgDetailBO orgDetailBO = orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO();
            payeeBO.setSupplierId(orgDetailBO.getOrgId());
            payeeBO.setSupplierCode(orgDetailBO.getOrgCode());
            payeeBO.setSupplierName(orgDetailBO.getOrgName());
        }
        return payeeBO;
    }
}

