/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.api.FscAccountChargeClaimAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeClaimAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscAccountAdvanceChangeBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountAdvanceChangeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountAdvanceChangeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.enums.AdvancePayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAccountAdvanceChangeBusiServiceImpl
implements FscAccountAdvanceChangeBusiService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;
    @Autowired
    private FscAccountChargeClaimAbilityService fscAccountChargeClaimAbilityService;

    @Override
    public FscAccountAdvanceChangeBusiRspBO dealAdvanceChange(FscAccountAdvanceChangeBusiReqBO reqBO) {
        FscPayLogPO payLogPO = new FscPayLogPO();
        payLogPO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_PAY);
        payLogPO.setPayeeId(this.operationOrgId);
        payLogPO.setBusiOrderNo(reqBO.getOrderNo());
        List list = this.fscPayLogMapper.getList(payLogPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u9a8c\u6536\u6263\u6b3e\u4fe1\u606f\uff01");
        }
        if (reqBO.getOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            return new FscAccountAdvanceChangeBusiRspBO();
        }
        payLogPO = (FscPayLogPO)list.get(0);
        payLogPO.setCreateTime(new Date());
        payLogPO.setBusiTime(new Date());
        payLogPO.setObjId(reqBO.getObjId());
        payLogPO.setBusiAmount(reqBO.getOrderAmt());
        payLogPO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
        if (payLogPO.getAccountId() == null) {
            throw new FscBusinessException("198888", "\u4ea4\u6613\u8bb0\u5f55\u672a\u8be2\u5230\u8d26\u6237\u4fe1\u606f\uff01");
        }
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setId(payLogPO.getAccountId());
        fscAccountPO = this.fscAccountMapper.getModelBy(fscAccountPO);
        if (fscAccountPO == null) {
            throw new FscBusinessException("198888", "\u672a\u8be2\u5230\u8d26\u6237\u4fe1\u606f\uff01");
        }
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setEnable(Integer.valueOf(1));
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null == fscMerchantPo) {
            throw new FscBusinessException("194304", "\u67e5\u8be2\u5546\u6237\u4e3a\u7a7a");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setPayBusiSceneRangeLike("1");
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setDelFlag(FscConstants.DicDelFlag.NO);
        merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
        merchant.setPayObjId(fscAccountPO.getOrgId());
        merchant.setEnable(Integer.valueOf(1));
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        BigDecimal overdraft = fscMerchantPo.getOverdraft();
        int count = 0;
        BigDecimal advanceAmount = fscAccountPO.getAdvanceAmount().subtract(fscAccountPO.getFreezeAmount()).subtract(fscAccountPO.getUseAmount()).subtract(fscAccountPO.getDistributeAdvanceAmount());
        overdraft = overdraft.subtract(fscAccountPO.getDistributeOverdraftAmount());
        BigDecimal totalAmt = reqBO.getOrderAmt();
        if (totalAmt.compareTo(BigDecimal.ZERO) > 0) {
            if (advanceAmount.compareTo(totalAmt) >= 0) {
                payLogPO.setAdvanceBeforeAmount(advanceAmount);
                payLogPO.setOverdraftBeforeAmount(overdraft);
                payLogPO.setOverdraftAfterAmount(overdraft);
                payLogPO.setAdvanceAfterAmount(advanceAmount.subtract(totalAmt));
            } else {
                if (advanceAmount.add(overdraft).compareTo(totalAmt) < 0) {
                    throw new FscBusinessException("194304", "\u9884\u5b58\u6b3e\u989d\u5ea6\u4e0d\u8db3\uff0c\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u5904\u7406\uff01");
                }
                if (advanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                    payLogPO.setAdvanceBeforeAmount(advanceAmount);
                    payLogPO.setOverdraftBeforeAmount(overdraft);
                    payLogPO.setOverdraftAfterAmount(overdraft.subtract(totalAmt.subtract(advanceAmount)));
                } else {
                    payLogPO.setAdvanceBeforeAmount(BigDecimal.ZERO);
                    payLogPO.setOverdraftBeforeAmount(overdraft.add(advanceAmount));
                    payLogPO.setOverdraftAfterAmount(payLogPO.getOverdraftBeforeAmount().subtract(totalAmt));
                }
                payLogPO.setAdvanceAfterAmount(BigDecimal.ZERO);
            }
        } else {
            if (advanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                payLogPO.setAdvanceBeforeAmount(advanceAmount);
            } else {
                payLogPO.setAdvanceBeforeAmount(BigDecimal.ZERO);
                overdraft = overdraft.add(advanceAmount);
            }
            payLogPO.setOverdraftBeforeAmount(overdraft);
            if (advanceAmount.compareTo(totalAmt) <= 0) {
                payLogPO.setAdvanceAfterAmount(payLogPO.getAdvanceBeforeAmount());
                payLogPO.setOverdraftAfterAmount(overdraft.subtract(totalAmt));
            } else if (advanceAmount.compareTo(BigDecimal.ZERO) < 0 && advanceAmount.compareTo(totalAmt) > 0) {
                payLogPO.setOverdraftAfterAmount(overdraft.subtract(advanceAmount));
                payLogPO.setAdvanceAfterAmount(advanceAmount.subtract(totalAmt));
            } else {
                payLogPO.setAdvanceAfterAmount(advanceAmount.subtract(totalAmt));
                payLogPO.setOverdraftAfterAmount(overdraft);
            }
        }
        fscAccountPO.setUseAmount(fscAccountPO.getUseAmount().add(totalAmt));
        fscAccountPO.setOverdraftAmount(fscAccountPO.getOverdraftAmount().add(payLogPO.getOverdraftBeforeAmount().subtract(payLogPO.getOverdraftAfterAmount())));
        count = this.fscAccountMapper.updateUseAmt(fscAccountPO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.writeLog(payLogPO);
        return new FscAccountAdvanceChangeBusiRspBO();
    }

    private void writeLog(FscPayLogPO fscPayLogPo) {
        fscPayLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayLogPo.setAdvanceAmt(fscPayLogPo.getAdvanceBeforeAmount().subtract(fscPayLogPo.getAdvanceAfterAmount()));
        fscPayLogPo.setOverdraftAmt(fscPayLogPo.getOverdraftBeforeAmount().subtract(fscPayLogPo.getOverdraftAfterAmount()));
        fscPayLogPo.setReimbursementAmount(BigDecimal.ZERO);
        if (fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT.getCode());
        } else if (fscPayLogPo.getAdvanceAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.OVERDRAFT.getCode());
        } else {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
        }
        if (fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) > 0) {
            fscPayLogPo.setIsCredit(FscConstants.IsCredit.YES);
        } else {
            fscPayLogPo.setIsCredit(FscConstants.IsCredit.NO);
        }
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setTabId(this.TAB_ID);
        uocInspectionDetailsListPageQueryReqBO.setSaleVoucherNo(fscPayLogPo.getBusiOrderNo());
        uocInspectionDetailsListPageQueryReqBO.setPageSize(1);
        uocInspectionDetailsListPageQueryReqBO.setPageNo(1);
        UocInspectionDetailsListPageQueryRspBO uocInspectionDetailsListPageQueryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        if ("0000".equals(uocInspectionDetailsListPageQueryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
            UocInspectionDetailsListBO uocInspectionDetailsListBO = (UocInspectionDetailsListBO)uocInspectionDetailsListPageQueryRspBO.getRows().get(0);
            fscPayLogPo.setBusiOrderId(Long.valueOf(Long.parseLong(uocInspectionDetailsListBO.getOrderId())));
            fscPayLogPo.setAcceptId(uocInspectionDetailsListBO.getInspectionVoucherId());
            fscPayLogPo.setAcceptCode(uocInspectionDetailsListBO.getInspectionVoucherCode());
            fscPayLogPo.setErpAcceptCode(uocInspectionDetailsListBO.getErpInspectionVoucherCode());
        }
        if (fscPayLogPo.getAdvanceAmt().compareTo(BigDecimal.ZERO) < 0) {
            FscAccountChargeClaimAbilityReqBO fscAccountChargeClaimAbilityReqBO = new FscAccountChargeClaimAbilityReqBO();
            fscAccountChargeClaimAbilityReqBO.setOrgIdWeb(fscPayLogPo.getOrgId());
            fscAccountChargeClaimAbilityReqBO.setChargeAmount(fscPayLogPo.getAdvanceAmt().multiply(new BigDecimal(-1)));
            this.fscAccountChargeClaimAbilityService.dealAccountChargeClaimed(fscAccountChargeClaimAbilityReqBO);
        }
        this.fscPayLogMapper.insert(fscPayLogPo);
    }
}

