/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillService;
import com.tydic.fsc.common.ability.api.FscAccountBillListQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscEncodedSerialGetPublicAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscUseAccountBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeProWelfareBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountAmountBo;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.common.enums.DeleteYnEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMainMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscWelfareChargeConsumerMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountMainPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscWelfareChargeConsumerPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.umc.general.ability.api.UmcBuyerCustomerQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountChargeProBusiWelfareServiceImpl
implements FscAccountChargeProWelfareBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargeProBusiWelfareServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountMainMapper fscAccountMainMapper;
    @Autowired
    private FscPushYcRecvClaimBillService fscPushYcRecvClaimBillService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private UmcBuyerCustomerQueryAbilityService umcBuyerCustomerQueryAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscEncodedSerialGetPublicAbilityService fscEncodedSerialGetPublicAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountBillListQueryAbilityService fscAccountBillListQueryAbilityService;
    private static final Integer TAB_ID = 60001;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscWelfareChargeConsumerMapper fscWelfareChargeConsumerMapper;

    @Override
    public FscAccountChargeBusiRspBO dealAccountCharge(FscAccountChargeBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getAccountId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8d26\u6237id[accountId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
            throw new FscBusinessException("190000", "\u5165\u53c2claimNo\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryByClaimNo(reqBO.getClaimNo());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u76f8\u5173\u4fe1\u606f!");
        }
        if (fscRecvClaimPo.getClaimStatus().equals(FscClaimStatusEnum.CLAIM.getCode())) {
            throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886!");
        }
        if (reqBO.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) > 0) {
            throw new FscBusinessException("190000", "\u9884\u5b58\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\uff01");
        }
        BigDecimal totalAmountCompany = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getCompanyChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmountUnion = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getUnionChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = totalAmountCompany.add(totalAmountUnion);
        if (!reqBO.getChargeAmount().equals(totalAmount)) {
            throw new FscBusinessException("198888", "\u591a\u4e2a\u5355\u4f4d/\u90e8\u95e8\u8d26\u6237\u5206\u914d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u5145\u503c\u91d1\u989d\uff01");
        }
        List uniqueAccountList = reqBO.getUseAccountBOList().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FscUseAccountBO>(Comparator.comparing(FscUseAccountBO::getUseDeptId))), ArrayList::new));
        if (uniqueAccountList.size() != reqBO.getUseAccountBOList().size()) {
            throw new FscBusinessException("198888", "\u5206\u914d\u8d26\u6237\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        FscAccountMainPO mainQueryVo = new FscAccountMainPO();
        mainQueryVo.setOrgCode(this.operationOrgCode);
        FscAccountMainPO fscAccountMainPo = this.fscAccountMainMapper.getModelBy(mainQueryVo);
        if (fscAccountMainPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5f00\u53d1\u516c\u53f8\u4e3b\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscAccountChargeBusiRspBO rspBO = new FscAccountChargeBusiRspBO();
        rspBO.setClaimId(fscRecvClaimPo.getClaimId());
        FscAccountChargePO fscAccountChargePo = new FscAccountChargePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountChargePo);
        FscEncodedSerialGetPublicAbilityReqBO fscEncodedSerialGetPublicAbilityReqBO = new FscEncodedSerialGetPublicAbilityReqBO();
        fscEncodedSerialGetPublicAbilityReqBO.setCenter("FSC");
        fscEncodedSerialGetPublicAbilityReqBO.setEncodedRuleCode("ADVANCE_DEPOSIT_NO");
        fscEncodedSerialGetPublicAbilityReqBO.setNum(Integer.valueOf(1));
        fscEncodedSerialGetPublicAbilityReqBO.setOrgType("-1");
        FscEncodedSerialGetPublicAbilityRspBO fscEncodedSerialGetPublicAbilityRspBO = this.fscEncodedSerialGetPublicAbilityService.getEncodedSerialPublic(fscEncodedSerialGetPublicAbilityReqBO);
        if ("0000".equals(fscEncodedSerialGetPublicAbilityRspBO.getRespCode())) {
            fscAccountChargePo.setAdvanceDepositNo(fscEncodedSerialGetPublicAbilityRspBO.getSerialNo());
        }
        fscAccountChargePo.setBusiType(Integer.valueOf("4"));
        fscAccountChargePo.setChargeDeptCode(fscAccountMainPo.getOrgCode());
        fscAccountChargePo.setChargeDeptId(Long.valueOf(fscAccountMainPo.getOrgId()));
        fscAccountChargePo.setChargeDeptName(fscAccountMainPo.getOrgName());
        fscAccountChargePo.setRecvBankAccount(fscAccountMainPo.getBankAccount());
        fscAccountChargePo.setRecvDeptName(fscAccountMainPo.getOrgName());
        fscAccountChargePo.setRecvDeptCode(fscAccountMainPo.getOrgCode());
        fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_PASS);
        fscAccountChargePo.setPayTime(new Date());
        fscAccountChargePo.setUserId(reqBO.getUserId());
        fscAccountChargePo.setUserName(reqBO.getName());
        fscAccountChargePo.setCreateTime(new Date());
        fscAccountChargePo.setClaimNo(reqBO.getClaimNo());
        fscAccountChargePo.setChargeId(Long.valueOf(Sequence.getInstance().nextId()));
        fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
        fscAccountChargePo.setAuditTime(new Date());
        ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>(reqBO.getAttachmentList().size());
        for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setObjId(fscAccountChargePo.getChargeId());
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAY_EVIDENCE);
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentObjType.PAY_EVIDENCE);
            attachmentList.add(fscAttachmentPo);
        }
        if (!CollectionUtils.isEmpty(attachmentList)) {
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        ArrayList detailPOList = new ArrayList();
        ArrayList<FscClaimDetailBO> pushDetailList = new ArrayList<FscClaimDetailBO>();
        List<FscUseAccountBO> useAccountBOList = reqBO.getUseAccountBOList();
        useAccountBOList.forEach(e -> {
            int insertPayLog;
            if ((FscConstants.ChargeAccount.COMPANY.equals(e.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(e.getChargeAccount())) && e.getCompanyChargeAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new FscBusinessException("190000", "\u516c\u53f8\u5145\u503c\u65f6\uff0c\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if ((FscConstants.ChargeAccount.UNION.equals(e.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(e.getChargeAccount())) && e.getUnionChargeAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new FscBusinessException("190000", "\u5de5\u4f1a\u5145\u503c\u65f6\uff0c\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BigDecimal chargeAmountCompany = e.getCompanyChargeAmount() == null ? BigDecimal.ZERO : e.getCompanyChargeAmount();
            BigDecimal chargeAmountUnion = e.getUnionChargeAmount() == null ? BigDecimal.ZERO : e.getUnionChargeAmount();
            BigDecimal chargeAmount = chargeAmountUnion.add(chargeAmountCompany);
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setOrgId(e.getUseDeptId());
            FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
            if (fscAccountPo == null) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
            }
            FscAccountAmountBo befoer = this.getAmount(fscAccountPo);
            FscAccountSerialPO serialPo = new FscAccountSerialPO();
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
            Integer serialNumber = 0;
            if (serialPo != null) {
                serialNumber = serialPo.getSerialNumber();
            }
            Object[] objectArray = new Object[1];
            serialNumber = serialNumber + 1;
            objectArray[0] = serialNumber;
            String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
            FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
            fscClaimDetailPo.setDetailNo(detailNo);
            fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscClaimDetailPo.setClaimAmt(chargeAmount);
            fscClaimDetailPo.setClaimDate(new Date());
            fscClaimDetailPo.setClaimId(fscRecvClaimPo.getClaimId());
            fscClaimDetailPo.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode());
            fscClaimDetailPo.setCustomerNo(Long.valueOf(fscAccountPo.getOrgCode()));
            fscClaimDetailPo.setCustomerName(fscAccountPo.getOrgName());
            fscClaimDetailPo.setHandleDeptId(reqBO.getDeptId());
            fscClaimDetailPo.setHandleDeptName(reqBO.getDeptName());
            fscClaimDetailPo.setHandleUserId(reqBO.getUserId());
            fscClaimDetailPo.setHandleUserName(reqBO.getName());
            fscClaimDetailPo.setStatus("1");
            fscClaimDetailPo.setObjectId(fscAccountChargePo.getChargeId());
            fscClaimDetailPo.setObjectNo(fscAccountChargePo.getAdvanceDepositNo());
            fscClaimDetailPo.setSysSource(Integer.valueOf(1));
            fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
            detailPOList.add(fscClaimDetailPo);
            FscClaimDetailBO detailBO = new FscClaimDetailBO();
            BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)detailBO);
            pushDetailList.add(detailBO);
            if (serialPo == null) {
                serialPo = new FscAccountSerialPO();
                serialPo.setSerialNumber(serialNumber);
                serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
                serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                this.fscAccountSerialMapper.insert(serialPo);
            } else {
                serialPo.setSerialNumber(serialNumber);
                this.fscAccountSerialMapper.update(serialPo);
            }
            BigDecimal returnedAmount = BigDecimal.ZERO;
            returnedAmount = BigDecimal.ZERO;
            if (FscConstants.ChargeAccount.COMPANY.equals(e.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(e.getChargeAccount())) {
                this.payBill(reqBO, fscAccountPo, e.getCompanyChargeAmount(), 1);
                fscAccountPo.setCompanyAdvanceAmount(fscAccountPo.getCompanyAdvanceAmount().add(e.getCompanyChargeAmount()));
                if (fscAccountPo.getCompanyOverdraft().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal CompanyReturnedAmount = fscAccountPo.getCompanyOverdraftAmount().compareTo(e.getCompanyChargeAmount()) > 0 ? e.getCompanyChargeAmount() : fscAccountPo.getCompanyOverdraftAmount();
                    fscAccountPo.setCompanyOverdraftAmount(fscAccountPo.getCompanyOverdraftAmount().compareTo(e.getCompanyChargeAmount()) > 0 ? fscAccountPo.getCompanyOverdraftAmount().subtract(e.getCompanyChargeAmount()) : BigDecimal.ZERO);
                    returnedAmount = returnedAmount.add(CompanyReturnedAmount);
                }
            }
            if (FscConstants.ChargeAccount.UNION.equals(e.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(e.getChargeAccount())) {
                this.payBill(reqBO, fscAccountPo, e.getUnionChargeAmount(), 2);
                fscAccountPo.setUnionAdvanceAmount(fscAccountPo.getUnionAdvanceAmount().add(e.getUnionChargeAmount()));
                if (fscAccountPo.getUnionOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal UnionReturnedAmount = fscAccountPo.getUnionOverdraftAmount().compareTo(e.getUnionChargeAmount()) > 0 ? e.getUnionChargeAmount() : fscAccountPo.getUnionOverdraftAmount();
                    fscAccountPo.setUnionOverdraftAmount(fscAccountPo.getUnionOverdraftAmount().compareTo(e.getUnionChargeAmount()) > 0 ? fscAccountPo.getUnionOverdraftAmount().subtract(e.getUnionChargeAmount()) : BigDecimal.ZERO);
                    returnedAmount = returnedAmount.add(UnionReturnedAmount);
                }
            }
            this.createChargeDetail(reqBO, fscAccountPo, fscAccountChargePo, (FscUseAccountBO)e);
            fscAccountPo.setEmployeeReturnAmount(returnedAmount);
            this.fscAccountMapper.updateAmountByCharge(fscAccountPo);
            FscAccountAmountBo after = this.getAmount(fscAccountPo);
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            fscPayLogPO.setAccountId(fscAccountPo.getId());
            fscPayLogPO.setOrgId(fscAccountPo.getOrgId());
            fscPayLogPO.setPayeeId(this.operationOrgId);
            fscPayLogPO.setUserName(fscAccountChargePo.getUserName());
            fscPayLogPO.setBusiTime(new Date());
            fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.WELFARE_ACCOUNT_CHARGE);
            fscPayLogPO.setBusiOrderType(Integer.valueOf(3));
            fscPayLogPO.setCreateTime(new Date());
            fscPayLogPO.setCreateOperId(reqBO.getUserId().toString());
            fscPayLogPO.setBusiOrderId(fscAccountChargePo.getChargeId());
            fscPayLogPO.setPayBusiness("4");
            fscPayLogPO.setIsCredit(Integer.valueOf(0));
            fscPayLogPO.setDealType(Integer.valueOf(4));
            if (chargeAmountCompany.compareTo(BigDecimal.ZERO) > 0) {
                fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayLogPO.setBusiAmount(chargeAmountCompany);
                fscPayLogPO.setAccountType(Integer.valueOf(1));
                fscPayLogPO.setOverdraftBeforeAmount(befoer.getCompanyBeforeOverDraft());
                fscPayLogPO.setOverdraftAfterAmount(after.getCompanyBeforeOverDraft());
                fscPayLogPO.setAdvanceBeforeAmount(befoer.getCompanyBeforeAmount());
                fscPayLogPO.setAdvanceAfterAmount(after.getCompanyBeforeAmount());
                insertPayLog = this.fscPayLogMapper.insert(fscPayLogPO);
                if (insertPayLog < 1) {
                    throw new FscBusinessException("190000", "\u65b0\u589e\u516c\u53f8\u652f\u4ed8\u8bb0\u5f55\u64cd\u4f5c\u5931\u8d25\uff01");
                }
            }
            if (chargeAmountUnion.compareTo(BigDecimal.ZERO) > 0) {
                fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayLogPO.setAccountType(Integer.valueOf(2));
                fscPayLogPO.setBusiAmount(chargeAmountUnion);
                fscPayLogPO.setOverdraftBeforeAmount(befoer.getUnionBeforeOverDraft());
                fscPayLogPO.setOverdraftAfterAmount(after.getUnionBeforeOverDraft());
                fscPayLogPO.setAdvanceBeforeAmount(befoer.getUnionBeforeAmount());
                fscPayLogPO.setAdvanceAfterAmount(after.getUnionBeforeAmount());
                insertPayLog = this.fscPayLogMapper.insert(fscPayLogPO);
                if (insertPayLog < 1) {
                    throw new FscBusinessException("190000", "\u65b0\u589e\u5de5\u4f1a\u652f\u4ed8\u8bb0\u5f55\u64cd\u4f5c\u5931\u8d25\uff01");
                }
            }
        });
        rspBO.setPushDetailBOList(pushDetailList);
        int count = this.fscClaimDetailMapper.insertBatch(detailPOList);
        if (count < 0) {
            throw new FscBusinessException("190000", "\u9884\u5b58\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        int insert = this.fscAccountChargeMapper.insert(fscAccountChargePo);
        if (insert < 0) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u8d26\u6237\u5145\u503c\u5931\u8d25\uff01");
        }
        if (reqBO.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) < 0) {
            fscRecvClaimPo.setNoClaimAmt(fscRecvClaimPo.getNoClaimAmt().subtract(reqBO.getChargeAmount()));
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        } else {
            fscRecvClaimPo.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
            fscRecvClaimPo.setNoClaimAmt(BigDecimal.ZERO);
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
        }
        this.fscRecvClaimMapper.update(fscRecvClaimPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void payBill(FscAccountChargeBusiReqBO reqBO, FscAccountPO fscAccountPo, BigDecimal chargeAmount, Integer accountType) {
        Date reimbursementDate = new Date();
        ArrayList<FscWelfareChargeConsumerPO> updateChargeConsumer = new ArrayList<FscWelfareChargeConsumerPO>();
        ArrayList updateChargeConsumerAfter = new ArrayList();
        FscWelfareChargeConsumerPO fscWelfareChargeConsumerPO = new FscWelfareChargeConsumerPO();
        fscWelfareChargeConsumerPO.setOrgId(fscAccountPo.getOrgId());
        fscWelfareChargeConsumerPO.setWelfareType(accountType);
        Page page = new Page();
        page.setPageSize(-1);
        List fscWelfareChargeConsumerPOS = this.fscWelfareChargeConsumerMapper.queryAllByLimitPage(fscWelfareChargeConsumerPO, page);
        Map fscWelfareChargeConsumerPOSMap = fscWelfareChargeConsumerPOS.stream().collect(Collectors.toMap(FscWelfareChargeConsumerPO::getWelfareChargeCode, Function.identity(), (e1, e2) -> e2));
        ArrayList<FscPayLogPO> backList = new ArrayList<FscPayLogPO>();
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setAccountId(fscAccountPo.getId());
        ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
        busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_WELFARE_PAY);
        fscPayLogPO.setBusiCategoryList(busiCategoryList);
        fscPayLogPO.setIsOverPay(Integer.valueOf(0));
        fscPayLogPO.setAccountType(accountType);
        fscPayLogPO.setIsBack(Integer.valueOf(0));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        list.add(3);
        fscPayLogPO.setAdvancePayTypeList(list);
        List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
        if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
            Map<String, List<FscPayLogPO>> fscPayLogPOListGroup = fscPayLogPOList.stream().collect(Collectors.groupingBy(FscPayLogPO::getWelfareChargeCode));
            ArrayList<String> fscPayLogPOListGroupList = new ArrayList<String>(fscPayLogPOListGroup.keySet());
            if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                for (String welfareChargeCode : fscPayLogPOListGroupList) {
                    BigDecimal returnAmt = BigDecimal.ZERO;
                    List<FscPayLogPO> fscPayLogPOS = fscPayLogPOListGroup.get(welfareChargeCode);
                    for (FscPayLogPO po : fscPayLogPOS) {
                        if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                        FscPayLogPO backPayLog = new FscPayLogPO();
                        backPayLog.setId(po.getId());
                        backPayLog.setBusiOrderId(po.getBusiOrderId());
                        backPayLog.setBusiOrderNo(po.getBusiOrderNo());
                        BigDecimal notBackAmt = po.getOverdraftAmt().subtract(po.getReimbursementAmount());
                        if (chargeAmount.compareTo(notBackAmt) >= 0) {
                            backPayLog.setReimbursementAmount(notBackAmt);
                            chargeAmount = chargeAmount.subtract(notBackAmt);
                            backPayLog.setReimbursementDate(reimbursementDate);
                        } else {
                            backPayLog.setReimbursementAmount(chargeAmount);
                            chargeAmount = BigDecimal.ZERO;
                        }
                        returnAmt = returnAmt.add(backPayLog.getReimbursementAmount());
                        backList.add(backPayLog);
                    }
                    if (null == fscWelfareChargeConsumerPOSMap.get(welfareChargeCode)) continue;
                    FscWelfareChargeConsumerPO welfareChargeConsumerPO = (FscWelfareChargeConsumerPO)fscWelfareChargeConsumerPOSMap.get(welfareChargeCode);
                    if (welfareChargeConsumerPO.getOverdraftUseAmount().compareTo(returnAmt) > 0) {
                        welfareChargeConsumerPO.setOverdraftAmount(welfareChargeConsumerPO.getOverdraftAmount().subtract(returnAmt));
                        welfareChargeConsumerPO.setAdvanceAmount(welfareChargeConsumerPO.getAdvanceAmount().add(returnAmt));
                        welfareChargeConsumerPO.setOverdraftUseAmount(welfareChargeConsumerPO.getOverdraftUseAmount().subtract(returnAmt));
                        welfareChargeConsumerPO.setAdvanceUseAmount(welfareChargeConsumerPO.getAdvanceUseAmount().add(returnAmt));
                    } else {
                        welfareChargeConsumerPO.setAdvanceAmount(welfareChargeConsumerPO.getAdvanceAmount().add(welfareChargeConsumerPO.getOverdraftUseAmount()));
                        welfareChargeConsumerPO.setOverdraftAmount(welfareChargeConsumerPO.getOverdraftAmount().subtract(welfareChargeConsumerPO.getOverdraftUseAmount()));
                        welfareChargeConsumerPO.setAdvanceUseAmount(welfareChargeConsumerPO.getAdvanceUseAmount().add(welfareChargeConsumerPO.getOverdraftUseAmount()));
                        welfareChargeConsumerPO.setOverdraftUseAmount(BigDecimal.ZERO);
                    }
                    updateChargeConsumer.add(welfareChargeConsumerPO);
                }
                if (!CollectionUtils.isEmpty(backList)) {
                    this.fscPayLogMapper.updateBack(backList);
                }
            }
        }
        Collection New = null;
        if (!CollectionUtils.isEmpty(updateChargeConsumer)) {
            Map collect = updateChargeConsumer.stream().collect(Collectors.toMap(FscWelfareChargeConsumerPO::getId, Function.identity(), (e1, e2) -> e2));
            Map collect1 = fscWelfareChargeConsumerPOS.stream().collect(Collectors.toMap(FscWelfareChargeConsumerPO::getId, Function.identity(), (e1, e2) -> e2));
            collect.forEach(collect1::put);
            New = collect1.values();
            fscWelfareChargeConsumerPOS = JSON.parseArray((String)JSON.toJSONString(New), FscWelfareChargeConsumerPO.class);
        }
        if (chargeAmount.compareTo(BigDecimal.ZERO) > 0 && !CollectionUtils.isEmpty((Collection)fscWelfareChargeConsumerPOS)) {
            for (FscWelfareChargeConsumerPO po : fscWelfareChargeConsumerPOS) {
                if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                if (null == po.getOverdraftAmount() || po.getOverdraftAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (po.getOverdraftAmount().compareTo(chargeAmount) > 0) {
                    po.setOverdraftAmount(po.getOverdraftAmount().subtract(chargeAmount));
                    po.setAdvanceAmount(chargeAmount.add(po.getAdvanceAmount()));
                    chargeAmount = BigDecimal.ZERO;
                    continue;
                }
                chargeAmount = chargeAmount.subtract(po.getOverdraftAmount());
                po.setAdvanceAmount(po.getAdvanceAmount().add(po.getOverdraftAmount()));
                po.setOverdraftAmount(BigDecimal.ZERO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)fscWelfareChargeConsumerPOS)) {
            this.fscWelfareChargeConsumerMapper.updateBack(fscWelfareChargeConsumerPOS);
        }
    }

    private void createChargeDetail(FscAccountChargeBusiReqBO reqBO, FscAccountPO fscAccountPo, FscAccountChargePO fscAccountChargePo, FscUseAccountBO fscUseAccountBO) {
        FscAccountChargeDetailPO fscAccountChargeDetailPO = new FscAccountChargeDetailPO();
        fscAccountChargeDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscAccountChargeDetailPO.setChargeId(fscAccountChargePo.getChargeId());
        fscAccountChargeDetailPO.setAdvanceDepositNo(fscAccountChargePo.getAdvanceDepositNo());
        fscAccountChargeDetailPO.setAccountId(fscAccountPo.getId());
        fscAccountChargeDetailPO.setUseDeptId(fscAccountPo.getOrgId());
        fscAccountChargeDetailPO.setUseDeptCode(fscAccountPo.getOrgCode());
        fscAccountChargeDetailPO.setUseDeptName(fscAccountPo.getOrgName());
        fscAccountChargeDetailPO.setCreateId(reqBO.getUserId());
        fscAccountChargeDetailPO.setCreateTime(new Date());
        fscAccountChargeDetailPO.setUpdateId(reqBO.getUserId());
        fscAccountChargeDetailPO.setUpdateTime(new Date());
        fscAccountChargeDetailPO.setDeleteYn(DeleteYnEnum.NORMAL.getCode());
        fscAccountChargeDetailPO.setChargeAccount(fscUseAccountBO.getChargeAccount());
        fscAccountChargeDetailPO.setCompanyAmount(fscUseAccountBO.getCompanyChargeAmount());
        fscAccountChargeDetailPO.setUnionAmount(fscUseAccountBO.getUnionChargeAmount());
        this.fscAccountChargeDetailMapper.insert(fscAccountChargeDetailPO);
    }

    private FscAccountAmountBo getAmount(FscAccountPO fscAccountPo) {
        if (null == fscAccountPo.getCompanyOverdraft()) {
            fscAccountPo.setCompanyOverdraft(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyOverdraftAmount()) {
            fscAccountPo.setCompanyOverdraftAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionOverdraft()) {
            fscAccountPo.setUnionOverdraft(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionOverdraftAmount()) {
            fscAccountPo.setUnionOverdraftAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyAdvanceAmount()) {
            fscAccountPo.setCompanyAdvanceAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyFreezeAmount()) {
            fscAccountPo.setCompanyFreezeAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyUseAmount()) {
            fscAccountPo.setCompanyUseAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionAdvanceAmount()) {
            fscAccountPo.setUnionAdvanceAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionFreezeAmount()) {
            fscAccountPo.setUnionFreezeAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionUseAmount()) {
            fscAccountPo.setUnionUseAmount(BigDecimal.ZERO);
        }
        FscAccountAmountBo fscAccountAmountBo = new FscAccountAmountBo();
        fscAccountAmountBo.setCompanyBeforeOverDraft(fscAccountPo.getCompanyOverdraft().subtract(fscAccountPo.getCompanyOverdraftAmount()));
        fscAccountAmountBo.setUnionBeforeOverDraft(fscAccountPo.getUnionOverdraft().subtract(fscAccountPo.getUnionOverdraftAmount()));
        fscAccountAmountBo.setCompanyBeforeAmount(fscAccountPo.getCompanyAdvanceAmount().subtract(fscAccountPo.getCompanyFreezeAmount()).subtract(fscAccountPo.getCompanyUseAmount()));
        fscAccountAmountBo.setUnionBeforeAmount(fscAccountPo.getUnionAdvanceAmount().subtract(fscAccountPo.getUnionFreezeAmount()).subtract(fscAccountPo.getUnionUseAmount()));
        return fscAccountAmountBo;
    }
}

