/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscAccountDistributionCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountDistributionCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountDistributionCreateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountDistributionMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountDistributionPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscMerchantPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAccountDistributionCreateBusiServiceImpl
implements FscAccountDistributionCreateBusiService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountDistributionMapper fscAccountDistributionMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    public FscAccountDistributionCreateBusiRspBO dealDistributionCreate(FscAccountDistributionCreateBusiReqBO reqBO) {
        FscAccountPO userAccountQuery;
        FscAccountPO parentQueryVo = new FscAccountPO();
        parentQueryVo.setId(reqBO.getParentAccountId());
        FscAccountPO parentAccountPo = this.fscAccountMapper.getModelBy(parentQueryVo);
        if (parentAccountPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4e0a\u7ea7\u5355\u4f4d\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        BigDecimal overdraftAmount = BigDecimal.ZERO;
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        Boolean flag = false;
        if (null != fscMerchantPo) {
            FscMerchantPO merchant = new FscMerchantPO();
            merchant.setPayBusiSceneRangeLike("1");
            merchant.setParentId(fscMerchantPo.getMerchantId());
            merchant.setDelFlag(FscConstants.DicDelFlag.NO);
            merchant.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE);
            merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            merchant.setPayObjId(parentAccountPo.getOrgId());
            merchant = this.fscMerchantMapper.getModelBy(merchant);
            if (null != merchant) {
                BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
            }
            overdraftAmount = fscMerchantPo.getOverdraft();
            parentAccountPo.setOverdraft(overdraftAmount);
        }
        parentAccountPo.setOverdraft(overdraftAmount);
        FscAccountPO useAccountPo = null;
        if (reqBO.getUseAccountId() != null) {
            userAccountQuery = new FscAccountPO();
            userAccountQuery.setId(reqBO.getUseAccountId());
            useAccountPo = this.fscAccountMapper.getModelBy(userAccountQuery);
        } else {
            userAccountQuery = new FscAccountPO();
            userAccountQuery.setOrgId(reqBO.getUseDeptId());
            userAccountQuery.setBusiType("1");
            userAccountQuery.setStatus(Integer.valueOf(1));
            List accountPOList = this.fscAccountMapper.getList(userAccountQuery);
            if (!CollectionUtils.isEmpty((Collection)accountPOList)) {
                useAccountPo = (FscAccountPO)accountPOList.get(0);
            }
        }
        if (useAccountPo == null) {
            useAccountPo = new FscAccountPO();
            BeanUtils.copyProperties((Object)parentAccountPo, (Object)useAccountPo);
            useAccountPo.setOverdraftAmount(BigDecimal.ZERO);
            useAccountPo.setReturnedAmount(BigDecimal.ZERO);
            useAccountPo.setAdvanceAmount(BigDecimal.ZERO);
            useAccountPo.setAccountCategory(Integer.valueOf(3));
            useAccountPo.setUseAmount(BigDecimal.ZERO);
            useAccountPo.setFreezeAmount(BigDecimal.ZERO);
            useAccountPo.setOrgId(reqBO.getUseDeptId());
            useAccountPo.setOrgName(reqBO.getUseDeptName());
            useAccountPo.setOrgCode(reqBO.getUseDeptCode());
            useAccountPo.setOverdraft(BigDecimal.ZERO);
            useAccountPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            useAccountPo.setAccountName(reqBO.getUseDeptName());
            useAccountPo.setOrgTreePath(reqBO.getOrgTreePath());
            String accountNo = this.getAccountNo(parentAccountPo);
            useAccountPo.setAccountNo(accountNo);
            flag = true;
        }
        if (reqBO.getAdvanceType().equals(FscConstants.FscCalculationType.ADD)) {
            if (parentAccountPo.getAdvanceAmount().subtract(parentAccountPo.getFreezeAmount()).subtract(parentAccountPo.getUseAmount()).compareTo(BigDecimal.ZERO) < 0) {
                throw new FscBusinessException("190000", "\u4e0a\u7ea7\u5355\u4f4d\u53ef\u7528\u9884\u5b58\u91d1\u989d\u4e0d\u8db3,\u5206\u914d\u5931\u8d25\uff01");
            }
            parentAccountPo.setAdvanceAmount(parentAccountPo.getAdvanceAmount().subtract(reqBO.getAdvanceAmount()));
            parentAccountPo.setDistributeAdvanceAmount(parentAccountPo.getDistributeOverdraftAmount().add(reqBO.getAdvanceAmount()));
            useAccountPo.setAdvanceAmount(useAccountPo.getAdvanceAmount().add(reqBO.getAdvanceAmount()));
        } else {
            if (useAccountPo.getAdvanceAmount().subtract(useAccountPo.getFreezeAmount()).subtract(useAccountPo.getUseAmount()).compareTo(BigDecimal.ZERO) < 0) {
                throw new FscBusinessException("190000", "\u4f7f\u7528\u5355\u4f4d\u53ef\u7528\u9884\u5b58\u91d1\u989d\u4e0d\u8db3,\u5206\u914d\u5931\u8d25\uff01");
            }
            parentAccountPo.setAdvanceAmount(parentAccountPo.getAdvanceAmount().add(reqBO.getAdvanceAmount()));
            parentAccountPo.setDistributeAdvanceAmount(parentAccountPo.getDistributeOverdraftAmount().subtract(reqBO.getAdvanceAmount()));
            useAccountPo.setAdvanceAmount(useAccountPo.getAdvanceAmount().subtract(reqBO.getAdvanceAmount()));
        }
        if (parentAccountPo.getAdvanceAmount().compareTo(BigDecimal.ZERO) < 0 || useAccountPo.getAdvanceAmount().compareTo(BigDecimal.ZERO) < 0) {
            throw new FscBusinessException("190000", "\u9884\u5b58\u6b3e\u91d1\u989d\u4e0d\u8db3,\u5206\u914d\u5931\u8d25\uff01");
        }
        if (reqBO.getOverdraftType().equals(FscConstants.FscCalculationType.ADD)) {
            if (parentAccountPo.getOverdraft().subtract(parentAccountPo.getOverdraftAmount()).compareTo(BigDecimal.ZERO) < 0) {
                throw new FscBusinessException("190000", "\u4e0a\u7ea7\u5355\u4f4d\u53ef\u7528\u9884\u5b58\u91d1\u989d\u4e0d\u8db3,\u5206\u914d\u5931\u8d25\uff01");
            }
            parentAccountPo.setDistributeOverdraftAmount(parentAccountPo.getOverdraftAmount().add(reqBO.getOverdraftAmount()));
            parentAccountPo.setOverdraft(parentAccountPo.getOverdraft().subtract(reqBO.getOverdraftAmount()));
            useAccountPo.setOverdraft(useAccountPo.getOverdraft().add(reqBO.getOverdraftAmount()));
        } else {
            if (useAccountPo.getOverdraft().subtract(useAccountPo.getOverdraftAmount()).compareTo(BigDecimal.ZERO) < 0) {
                throw new FscBusinessException("190000", "\u4f7f\u7528\u5355\u4f4d\u53ef\u7528\u9884\u5b58\u91d1\u989d\u4e0d\u8db3,\u5206\u914d\u5931\u8d25\uff01");
            }
            parentAccountPo.setDistributeOverdraftAmount(parentAccountPo.getOverdraftAmount().subtract(reqBO.getOverdraftAmount()));
            parentAccountPo.setOverdraft(parentAccountPo.getOverdraft().add(reqBO.getOverdraftAmount()));
            useAccountPo.setOverdraft(useAccountPo.getOverdraft().subtract(reqBO.getOverdraftAmount()));
        }
        if (parentAccountPo.getOverdraft().compareTo(BigDecimal.ZERO) < 0 || useAccountPo.getOverdraft().compareTo(BigDecimal.ZERO) < 0) {
            throw new FscBusinessException("190000", "\u900f\u652f\u91d1\u989d\u4e0d\u8db3,\u5206\u914d\u5931\u8d25\uff01");
        }
        parentAccountPo.setOverdraft(overdraftAmount);
        this.updateAccount(parentAccountPo);
        if (flag.booleanValue()) {
            this.fscAccountMapper.insert(useAccountPo);
        } else {
            this.updateAccount(useAccountPo);
        }
        FscAccountDistributionPO fscAccountDistributionPo = new FscAccountDistributionPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountDistributionPo);
        fscAccountDistributionPo.setCreateDeptId(reqBO.getOrgId());
        fscAccountDistributionPo.setCreateDeptName(reqBO.getOrgName());
        fscAccountDistributionPo.setCreateTime(new Date());
        fscAccountDistributionPo.setCreateUser(reqBO.getName());
        fscAccountDistributionPo.setCreateUserId(reqBO.getUserId());
        fscAccountDistributionPo.setUseAccountId(useAccountPo.getId());
        FscAccountDistributionCreateBusiRspBO rspBO = new FscAccountDistributionCreateBusiRspBO();
        fscAccountDistributionPo.setDistributionId(Long.valueOf(Sequence.getInstance().nextId()));
        if (reqBO.getAdvanceType().equals(FscConstants.FscCalculationType.SUB)) {
            fscAccountDistributionPo.setAdvanceAmount(reqBO.getAdvanceAmount().negate());
        }
        if (reqBO.getAdvanceType().equals(FscConstants.FscCalculationType.SUB)) {
            fscAccountDistributionPo.setOverdraftAmount(reqBO.getOverdraftAmount().negate());
        }
        this.fscAccountDistributionMapper.insert(fscAccountDistributionPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getAccountNo(FscAccountPO parentAccountPo) {
        FscAccountSerialPO queryVo = new FscAccountSerialPO();
        queryVo.setOrgId(parentAccountPo.getOrgId());
        FscAccountSerialPO fscAccountSerialPO = this.fscAccountSerialMapper.getModelBy(queryVo);
        if (fscAccountSerialPO != null) {
            this.fscAccountSerialMapper.updateSerialNumber(fscAccountSerialPO);
            return parentAccountPo.getAccountNo() + "-" + fscAccountSerialPO.getSerialNumber();
        }
        fscAccountSerialPO = new FscAccountSerialPO();
        fscAccountSerialPO.setSerialNumber(Integer.valueOf(2));
        fscAccountSerialPO.setOrgId(parentAccountPo.getOrgId());
        this.fscAccountSerialMapper.insert(fscAccountSerialPO);
        return parentAccountPo.getAccountNo() + "-" + 1;
    }

    public void updateAccount(FscAccountPO fscAccountPo) {
        int count = this.fscAccountMapper.updateDistributeByIdAndVersionId(fscAccountPo);
        if (count <= 0) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5931\u8d25,\u8bf7\u91cd\u65b0\u5c1d\u8bd5\uff01");
        }
    }
}

