/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscAccountPayLogRefreshBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountPayLogRefreshBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountPayLogRefreshBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.enums.AdvancePayTypeEnum;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAccountPayLogRefreshBusiServiceImpl
implements FscAccountPayLogRefreshBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountPayLogRefreshBusiServiceImpl.class);
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;

    @Override
    public FscAccountPayLogRefreshBusiRspBO dealAdvanceRefresh(FscAccountPayLogRefreshBusiReqBO reqBO) {
        FscAccountPayLogRefreshBusiRspBO rspBO = new FscAccountPayLogRefreshBusiRspBO();
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgId(reqBO.getOrgIdWeb());
        fscAccountPO = this.fscAccountMapper.getModelBy(fscAccountPO);
        BigDecimal overdraft = fscAccountPO.getOverdraft();
        BigDecimal availableOverdraft = fscAccountPO.getOverdraft();
        List chargePOList = this.fscAccountChargeMapper.qryChargeAmountByDate(reqBO.getOrgIdWeb());
        int maxIndex = chargePOList.size();
        int index = 0;
        BigDecimal chargeAmount = BigDecimal.ZERO;
        FscAccountChargePO fscAccountChargePO = (FscAccountChargePO)chargePOList.get(index);
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_REFUND);
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
        fscPayLogPO.setBusiCategoryList(busiCategoryList);
        fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
        List list = this.fscPayLogMapper.getList(fscPayLogPO);
        HashMap<String, FscPayLogPO> freezeMap = new HashMap<String, FscPayLogPO>();
        for (FscPayLogPO po : list) {
            FscPayLogPO freeze;
            BigDecimal overdraftAmount;
            while (fscAccountChargePO.getClaimDate().compareTo(po.getBusiTime()) < 0 && index < maxIndex) {
                overdraftAmount = overdraft.subtract(availableOverdraft);
                if (fscAccountChargePO.getChargeAmount().compareTo(overdraftAmount) < 0) {
                    availableOverdraft = availableOverdraft.add(fscAccountChargePO.getChargeAmount());
                } else if (overdraftAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    availableOverdraft = overdraft;
                    chargeAmount = chargeAmount.add(fscAccountChargePO.getChargeAmount().subtract(overdraftAmount));
                } else {
                    chargeAmount = chargeAmount.add(fscAccountChargePO.getChargeAmount());
                }
                if (++index >= maxIndex) continue;
                fscAccountChargePO = (FscAccountChargePO)chargePOList.get(index);
            }
            if (FscConstants.FscBusiCategory.ADVANCE_FREEZE.equals(po.getBusiCategory())) {
                BigDecimal busiAmount = po.getBusiAmount();
                if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    po.setOverdraftBeforeAmount(availableOverdraft);
                    availableOverdraft = availableOverdraft.subtract(busiAmount);
                    po.setOverdraftAfterAmount(availableOverdraft);
                    po.setAdvanceBeforeAmount(chargeAmount);
                    po.setAdvanceAfterAmount(chargeAmount);
                    po.setAdvancePayType(AdvancePayTypeEnum.OVERDRAFT.getCode());
                    po.setAdvanceAmt(BigDecimal.ZERO);
                    po.setOverdraftAmt(busiAmount);
                } else if (chargeAmount.compareTo(busiAmount) >= 0) {
                    po.setAdvanceBeforeAmount(chargeAmount);
                    chargeAmount = chargeAmount.subtract(busiAmount);
                    po.setAdvanceAfterAmount(chargeAmount);
                    po.setOverdraftBeforeAmount(availableOverdraft);
                    po.setOverdraftAfterAmount(availableOverdraft);
                    po.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT.getCode());
                    po.setAdvanceAmt(busiAmount);
                    po.setOverdraftAmt(BigDecimal.ZERO);
                } else {
                    po.setAdvanceBeforeAmount(chargeAmount);
                    po.setAdvanceAmt(chargeAmount);
                    po.setOverdraftAmt(busiAmount.subtract(chargeAmount));
                    po.setOverdraftBeforeAmount(availableOverdraft);
                    availableOverdraft = availableOverdraft.add(chargeAmount).subtract(busiAmount);
                    chargeAmount = BigDecimal.ZERO;
                    po.setAdvanceAfterAmount(chargeAmount);
                    po.setOverdraftAfterAmount(availableOverdraft);
                    po.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
                }
                FscPayLogPO poMap = new FscPayLogPO();
                poMap.setBusiOrderNo(po.getBusiOrderNo());
                poMap.setAdvanceAmt(po.getAdvanceAmt());
                poMap.setOverdraftAmt(po.getOverdraftAmt());
                poMap.setAdvancePayType(po.getAdvancePayType());
                freezeMap.put(poMap.getBusiOrderNo(), poMap);
                continue;
            }
            if (FscConstants.FscBusiCategory.ADVANCE_PAY.equals(po.getBusiCategory())) {
                FscPayLogPO freeze2;
                String busiOrderNo = po.getBusiOrderNo();
                if (busiOrderNo.contains("-")) {
                    busiOrderNo = po.getBusiOrderNo().substring(0, po.getBusiOrderNo().lastIndexOf("-"));
                }
                if ((freeze2 = (FscPayLogPO)freezeMap.get(busiOrderNo)) == null) {
                    rspBO.setRespCode("190000");
                    rspBO.setRespCode(busiOrderNo + "\u4e0d\u5b58\u5728\u51bb\u7ed3\u6570\u636e");
                    return rspBO;
                }
                po.setAdvanceBeforeAmount(chargeAmount);
                po.setAdvanceAfterAmount(chargeAmount);
                po.setOverdraftBeforeAmount(availableOverdraft);
                po.setOverdraftAfterAmount(availableOverdraft);
                if (po.getBusiOrderNo().contains("-")) {
                    if (freeze2.getAdvanceAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (freeze2.getAdvanceAmt().compareTo(po.getBusiAmount()) >= 0) {
                            po.setAdvanceAmt(po.getBusiAmount());
                            po.setOverdraftAmt(BigDecimal.ZERO);
                            po.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT.getCode());
                        } else {
                            po.setAdvanceAmt(freeze2.getAdvanceAmt());
                            po.setOverdraftAmt(po.getBusiAmount().subtract(freeze2.getAdvanceAmt()));
                            po.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
                        }
                    } else {
                        po.setAdvanceAmt(BigDecimal.ZERO);
                        po.setOverdraftAmt(po.getBusiAmount());
                        po.setAdvancePayType(AdvancePayTypeEnum.OVERDRAFT.getCode());
                    }
                    freeze2.setAdvanceAmt(freeze2.getAdvanceAmt().subtract(po.getBusiAmount()));
                    freezeMap.put(busiOrderNo, freeze2);
                    continue;
                }
                po.setAdvanceAmt(freeze2.getAdvanceAmt());
                po.setOverdraftAmt(freeze2.getOverdraftAmt());
                po.setAdvancePayType(freeze2.getAdvancePayType());
                continue;
            }
            overdraftAmount = overdraft.subtract(availableOverdraft);
            BigDecimal busiAmount = po.getBusiAmount();
            if (busiAmount.compareTo(BigDecimal.ZERO) < 0) {
                busiAmount = busiAmount.multiply(new BigDecimal(-1));
            }
            if (overdraftAmount.compareTo(BigDecimal.ZERO) <= 0) {
                po.setAdvanceBeforeAmount(chargeAmount);
                chargeAmount = chargeAmount.add(busiAmount);
                po.setAdvanceAfterAmount(chargeAmount);
                po.setOverdraftBeforeAmount(availableOverdraft);
                po.setOverdraftAfterAmount(availableOverdraft);
                po.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT.getCode());
                po.setAdvanceAmt(busiAmount.multiply(new BigDecimal(-1)));
                po.setOverdraftAmt(BigDecimal.ZERO);
            } else if (busiAmount.compareTo(overdraftAmount) < 0) {
                po.setOverdraftBeforeAmount(availableOverdraft);
                availableOverdraft = availableOverdraft.add(busiAmount);
                po.setOverdraftAfterAmount(availableOverdraft);
                po.setAdvanceBeforeAmount(chargeAmount);
                po.setAdvanceAfterAmount(chargeAmount);
                po.setAdvancePayType(AdvancePayTypeEnum.OVERDRAFT.getCode());
                po.setOverdraftAmt(busiAmount.multiply(new BigDecimal(-1)));
                po.setAdvanceAmt(BigDecimal.ZERO);
            } else {
                po.setOverdraftBeforeAmount(availableOverdraft);
                availableOverdraft = overdraft;
                po.setOverdraftAfterAmount(availableOverdraft);
                po.setAdvanceBeforeAmount(chargeAmount);
                chargeAmount = chargeAmount.add(busiAmount.subtract(overdraftAmount));
                po.setAdvanceAfterAmount(chargeAmount);
                po.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
                po.setOverdraftAmt(overdraftAmount.multiply(new BigDecimal(-1)));
                po.setAdvanceAmt(busiAmount.subtract(overdraftAmount).multiply(new BigDecimal(-1)));
            }
            String busiOrderNo = po.getBusiOrderNo();
            if (busiOrderNo.contains("-")) {
                busiOrderNo = po.getBusiOrderNo().substring(0, po.getBusiOrderNo().lastIndexOf("-"));
            }
            if ((freeze = (FscPayLogPO)freezeMap.get(busiOrderNo)) == null) {
                rspBO.setRespCode("190000");
                rspBO.setRespCode(busiOrderNo + "\u4e0d\u5b58\u5728\u51bb\u7ed3\u6570\u636e");
                return rspBO;
            }
            freeze.setAdvanceAmt(freeze.getAdvanceAmt().add(po.getAdvanceAmt()));
            freeze.setOverdraftAmt(freeze.getOverdraftAmt().add(po.getOverdraftAmt()));
            freezeMap.put(po.getBusiOrderNo(), freeze);
        }
        this.fscPayLogMapper.updateAdvanceBatch(list);
        return rspBO;
    }

    @Override
    public FscAccountPayLogRefreshBusiRspBO dealAdvancePayRefresh(FscAccountPayLogRefreshBusiReqBO reqBO) {
        FscAccountPayLogRefreshBusiRspBO busiRspBO = new FscAccountPayLogRefreshBusiRspBO();
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
        fscPayLogPO.setBusiCategoryList(busiCategoryList);
        fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
        fscPayLogPO.setOrderBy("busi_time asc");
        List list = this.fscPayLogMapper.getList(fscPayLogPO);
        for (FscPayLogPO po2 : list) {
            if (po2.getBusiOrderNo().contains("-")) {
                po2.setBusiParentOrderNo(po2.getBusiOrderNo().substring(0, po2.getBusiOrderNo().lastIndexOf("-")));
                continue;
            }
            po2.setBusiParentOrderNo(po2.getBusiOrderNo());
        }
        List orderCodeList = list.stream().map(FscPayLogPO::getBusiParentOrderNo).collect(Collectors.toList());
        Map<String, List<FscPayLogPO>> listMap = list.stream().collect(Collectors.groupingBy(FscPayLogPO::getBusiParentOrderNo));
        busiCategoryList = new ArrayList();
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_REFUND);
        fscPayLogPO.setBusiCategoryList(busiCategoryList);
        fscPayLogPO.setBusiOrderNoList(orderCodeList);
        List freezeList = this.fscPayLogMapper.getList(fscPayLogPO);
        HashMap<String, FscPayLogPO> freezeMap = new HashMap<String, FscPayLogPO>();
        for (String orderCode : orderCodeList) {
            List orderFreezeList = freezeList.stream().filter(po -> orderCode.equals(po.getBusiOrderNo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orderFreezeList)) continue;
            FscPayLogPO fscPayLogPo = new FscPayLogPO();
            BigDecimal busiAmount = BigDecimal.ZERO;
            BigDecimal advanceAmount = BigDecimal.ZERO;
            BigDecimal overdraftAmount = BigDecimal.ZERO;
            for (FscPayLogPO po3 : orderFreezeList) {
                busiAmount = busiAmount.add(po3.getBusiAmount());
                advanceAmount = advanceAmount.add(po3.getAdvanceAmt());
                overdraftAmount = overdraftAmount.add(po3.getOverdraftAmt());
                if (!FscConstants.FscBusiCategory.ADVANCE_FREEZE.equals(po3.getBusiCategory())) continue;
                fscPayLogPo = po3;
            }
            fscPayLogPo.setBusiAmount(busiAmount);
            fscPayLogPo.setAdvanceAmt(advanceAmount);
            fscPayLogPo.setOverdraftAmt(overdraftAmount);
            fscPayLogPo.setAdvanceAfterAmount(fscPayLogPo.getAdvanceBeforeAmount().subtract(advanceAmount));
            fscPayLogPo.setOverdraftAmt(fscPayLogPo.getOverdraftAfterAmount().subtract(overdraftAmount));
            freezeMap.put(orderCode, fscPayLogPo);
        }
        StringBuilder desc = new StringBuilder();
        ArrayList<FscPayLogPO> updateList = new ArrayList<FscPayLogPO>();
        for (String orderCode : orderCodeList) {
            FscPayLogPO freezePo = (FscPayLogPO)freezeMap.get(orderCode);
            if (freezePo == null) {
                desc.append(orderCode).append(",");
                continue;
            }
            BigDecimal advanceBeforeAmount = freezePo.getAdvanceBeforeAmount();
            BigDecimal overdraftBeforeAmount = freezePo.getOverdraftBeforeAmount();
            List<FscPayLogPO> payList = listMap.get(orderCode);
            for (FscPayLogPO po4 : payList) {
                BigDecimal busiAmount = po4.getBusiAmount();
                if (advanceBeforeAmount.compareTo(busiAmount) > 0) {
                    po4.setAdvanceBeforeAmount(advanceBeforeAmount);
                    advanceBeforeAmount = advanceBeforeAmount.subtract(busiAmount);
                    po4.setAdvanceAfterAmount(advanceBeforeAmount);
                    po4.setOverdraftBeforeAmount(overdraftBeforeAmount);
                    po4.setOverdraftBeforeAmount(overdraftBeforeAmount);
                    po4.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT.getCode());
                    po4.setOverdraftAmt(busiAmount);
                    po4.setAdvanceAmt(BigDecimal.ZERO);
                    continue;
                }
                if (advanceBeforeAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    po4.setOverdraftBeforeAmount(overdraftBeforeAmount);
                    overdraftBeforeAmount = overdraftBeforeAmount.subtract(busiAmount);
                    po4.setOverdraftAfterAmount(overdraftBeforeAmount);
                    po4.setAdvanceBeforeAmount(advanceBeforeAmount);
                    po4.setAdvanceAfterAmount(advanceBeforeAmount);
                    po4.setAdvancePayType(AdvancePayTypeEnum.OVERDRAFT.getCode());
                    po4.setAdvanceAmt(BigDecimal.ZERO);
                    po4.setOverdraftAmt(busiAmount);
                    continue;
                }
                po4.setAdvanceBeforeAmount(advanceBeforeAmount);
                po4.setOverdraftBeforeAmount(overdraftBeforeAmount);
                po4.setAdvanceAmt(advanceBeforeAmount);
                po4.setOverdraftAmt(busiAmount.subtract(advanceBeforeAmount));
                advanceBeforeAmount = BigDecimal.ZERO;
                overdraftBeforeAmount = overdraftBeforeAmount.subtract(busiAmount.subtract(advanceBeforeAmount));
                po4.setAdvanceAfterAmount(advanceBeforeAmount);
                po4.setOverdraftAfterAmount(overdraftBeforeAmount);
                po4.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
            }
            updateList.addAll(payList);
        }
        this.fscPayLogMapper.updateAdvanceBatch(updateList);
        busiRspBO.setRespDesc(desc.toString());
        return busiRspBO;
    }
}

