/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscMemFeeAutoCheckJobDealBusiService;
import com.tydic.fsc.common.busi.bo.FscMemFeeAutoCheckJobDealBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMemFeeAutoCheckJobDealBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountReconciliationDetailMapper;
import com.tydic.fsc.dao.FscAccountReconciliationMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountReconciliationDetailPO;
import com.tydic.fsc.po.FscAccountReconciliationPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.payment.pay.ability.ChinaPayBillUploadAbilityService;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscMemFeeAutoCheckJobDealBusiServiceImpl
implements FscMemFeeAutoCheckJobDealBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMemFeeAutoCheckJobDealBusiServiceImpl.class);
    @Autowired
    private ChinaPayBillUploadAbilityService chinaPayBillUploadAbilityService;
    @Autowired
    private FscAccountReconciliationMapper fscAccountReconciliationMapper;
    @Autowired
    private FscAccountReconciliationDetailMapper fscAccountReconciliationDetailMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${FSC_PAY_CHECK_MERCHANT:000092212213950,000092212213951}")
    private String checkMerchants;

    @Override
    public FscMemFeeAutoCheckJobDealBusiRspBO dealMemFeeAutoCheckJob(FscMemFeeAutoCheckJobDealBusiReqBO reqBO) {
        String[] merchants;
        Date date = reqBO.getBillDate();
        if (reqBO.getBillDate() == null) {
            date = new Date();
        }
        Date preDate = new Date(date.getTime() - 86400000L);
        String dateStr = DateUtil.dateToStrYYYYMMdd((Date)preDate);
        Long billDate = Long.valueOf(dateStr);
        ArrayList<PayBillAbleDownloadRspDataBo> rspDataBos = new ArrayList<PayBillAbleDownloadRspDataBo>();
        for (String merchant : merchants = this.splitMerchants(this.checkMerchants)) {
            PayBillAbleDownloadReqBo downloadReqBo = new PayBillAbleDownloadReqBo();
            downloadReqBo.setBillDate(billDate);
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("MerId", merchant);
            downloadReqBo.setParaMap(paraMap);
            log.debug("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u5bf9\u8d26\u5bf9\u8d26\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)downloadReqBo));
            PayBillAbleDownloadRspBo payRspBo = this.chinaPayBillUploadAbilityService.downLoadBillFile(downloadReqBo);
            log.debug("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u5bf9\u8d26\u5bf9\u8d26\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)payRspBo));
            if (!payRspBo.getRespCode().equals("0000")) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u94f6\u8054\u5bf9\u8d26\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)payRspBo.getRspDataBos())) continue;
            rspDataBos.addAll(payRspBo.getRspDataBos());
        }
        this.dealPayCheck(rspDataBos, date);
        FscMemFeeAutoCheckJobDealBusiRspBO rspBO = new FscMemFeeAutoCheckJobDealBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealPayCheck(List<PayBillAbleDownloadRspDataBo> rspDataBos, Date date) {
        FscAccountReconciliationPO reconciliationPO = new FscAccountReconciliationPO();
        String dateStr = DateUtil.dateToStr((Date)date);
        reconciliationPO.setReconciliationDateStr(dateStr);
        reconciliationPO = this.fscAccountReconciliationMapper.getModelBy(reconciliationPO);
        boolean newCheck = false;
        if (reconciliationPO == null) {
            newCheck = true;
            reconciliationPO = new FscAccountReconciliationPO();
            reconciliationPO.setReconciliationId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        log.debug("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u5bf9\u8d26\u6570\u91cf\uff1a" + rspDataBos.size());
        reconciliationPO.setReconciliationDate(date);
        reconciliationPO.setUpdateTime(new Date());
        reconciliationPO.setFailCount(Long.valueOf(0L));
        reconciliationPO.setReconciliationResult(FscConstants.RECONCILIATION_RESULT.YES);
        ArrayList<FscAccountReconciliationDetailPO> detailList = new ArrayList<FscAccountReconciliationDetailPO>();
        ArrayList<String> payOrderIds = new ArrayList<String>(rspDataBos.size());
        HashMap<String, PayBillAbleDownloadRspDataBo> payMap = new HashMap<String, PayBillAbleDownloadRspDataBo>(detailList.size());
        for (PayBillAbleDownloadRspDataBo rspDataBo : rspDataBos) {
            payOrderIds.add(rspDataBo.getTypeOrderId());
            payMap.put(rspDataBo.getTypeOrderId(), rspDataBo);
        }
        if (!CollectionUtils.isEmpty(payOrderIds)) {
            FscOrderPO orderPo = new FscOrderPO();
            orderPo.setPayOrderIds(payOrderIds);
            orderPo.setOrderFlow(FscConstants.OrderFlow.MEMBER_FEE_PAY);
            List list = this.fscOrderMapper.getPayCheckList(orderPo);
            log.debug("\u67e5\u8be2\u7ed3\u7b97\u4e2d\u5fc3\u5bf9\u8d26\u4ed8\u6b3e\u5355\u6570\u91cf\uff1a" + list.size());
            long failCount = 0L;
            for (FscOrderPO orderPO : list) {
                PayBillAbleDownloadRspDataBo rspDataBo = (PayBillAbleDownloadRspDataBo)payMap.get(orderPO.getPayOrderId());
                FscAccountReconciliationDetailPO detailPO = this.dealCheckResult(rspDataBo, orderPO);
                detailPO.setReconciliationId(reconciliationPO.getReconciliationId());
                detailPO.setReconciliationDate(date);
                detailList.add(detailPO);
                if (!detailPO.getReconciliationResult().equals(FscConstants.RECONCILIATION_RESULT.NO)) continue;
                ++failCount;
            }
            reconciliationPO.setFailCount(Long.valueOf(failCount));
            reconciliationPO.setReconciliationResult(failCount > 0L ? FscConstants.RECONCILIATION_RESULT.NO : FscConstants.RECONCILIATION_RESULT.YES);
        }
        if (newCheck) {
            this.fscAccountReconciliationMapper.insert(reconciliationPO);
        } else {
            this.fscAccountReconciliationMapper.update(reconciliationPO);
            this.fscAccountReconciliationDetailMapper.deleteByReconciliationId(reconciliationPO.getReconciliationId());
        }
        if (!CollectionUtils.isEmpty(detailList)) {
            this.fscAccountReconciliationDetailMapper.insertBatch(detailList);
        }
    }

    private FscAccountReconciliationDetailPO dealCheckResult(PayBillAbleDownloadRspDataBo rspDataBo, FscOrderPO orderPO) {
        FscAccountReconciliationDetailPO detailPO = new FscAccountReconciliationDetailPO();
        orderPO.setTotalCharge(orderPO.getTotalCharge().setScale(2, 4));
        detailPO.setReconciliationDetailId(Long.valueOf(Sequence.getInstance().nextId()));
        detailPO.setBusiType(FscConstants.RECONCILIATION_BUSI_TYPE.MEMBER_FEE);
        detailPO.setFscOrderId(orderPO.getFscOrderId());
        detailPO.setPayAmount(orderPO.getTotalCharge());
        detailPO.setFscOrderNo(orderPO.getOrderNo());
        detailPO.setOutOrderId(rspDataBo.getTypeOrderId());
        detailPO.setPayId(orderPO.getOrderId());
        detailPO.setSerialNumber(rspDataBo.getTypeTransId());
        Long realFee = rspDataBo.getRealFee();
        detailPO.setReconciliationResult(FscConstants.RECONCILIATION_RESULT.NO);
        if (realFee == null || realFee == 0L) {
            detailPO.setOtherAmt(BigDecimal.ZERO);
        } else {
            BigDecimal otherAmt = new BigDecimal(realFee).divide(new BigDecimal(100), 2, 4);
            detailPO.setOtherAmt(otherAmt);
            if (orderPO.getTotalCharge().compareTo(otherAmt) == 0) {
                detailPO.setReconciliationResult(FscConstants.RECONCILIATION_RESULT.YES);
            } else {
                detailPO.setDesc("\u5bf9\u8d26\u4e0d\u4e00\u81f4\u3002\u6613\u8d2d\u4ed8\u6b3e\u91d1\u989d:" + orderPO.getTotalCharge().setScale(2, 4) + "\u94f6\u8054\u4ed8\u6b3e\u91d1\u989d:" + otherAmt);
            }
        }
        return detailPO;
    }

    private String[] splitMerchants(String checkMerchants) {
        String[] split = this.checkMerchants.contains(",") ? this.checkMerchants.split(",") : new String[]{this.checkMerchants};
        return split;
    }
}

