/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.busi.api.FscPushMemPayFeeBusiService;
import com.tydic.fsc.common.busi.bo.FscPushMemPayFeeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushMemPayFeeBusiRspBO;
import com.tydic.fsc.dao.FscMemPayInfoMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMemPayInfoPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.umc.general.ability.api.UmcMemberFeePushAbilityService;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPushMemPayFeeBusiServiceImpl
implements FscPushMemPayFeeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushMemPayFeeBusiServiceImpl.class);
    @Autowired
    private FscMemPayInfoMapper fscMemPayInfoMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UmcMemberFeePushAbilityService umcMemberFeePushAbilityService;

    @Override
    public FscPushMemPayFeeBusiRspBO dealFscPushMemFee(FscPushMemPayFeeBusiReqBO reqBO) {
        UmcMemberFeePushAbilityRspBO abilityRspBO;
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscMemPayInfoPO payInfoPo = new FscMemPayInfoPO();
        payInfoPo.setFscOrderId(reqBO.getFscOrderId());
        payInfoPo = this.fscMemPayInfoMapper.getModelBy(payInfoPo);
        if (payInfoPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u8d39\u76f8\u5173\u4fe1\u606f\uff01" + reqBO.getFscOrderId());
        }
        if (payInfoPo.getIsPushFz() != 2 && payInfoPo.getIsPushZb() != 2) {
            throw new FscBusinessException("198888", "\u8be5\u4f1a\u5458\u8d39\u4e0d\u6ee1\u8db3\u91cd\u65b0\u63a8\u9001\u72b6\u6001\uff01" + reqBO.getFscOrderId());
        }
        UmcMemberFeePushAbilityReqBO pushReqBo = this.buildPushReqBo(payInfoPo);
        FscMemPayInfoPO payInfo = new FscMemPayInfoPO();
        payInfo.setFscOrderId(payInfoPo.getFscOrderId());
        payInfo.setMemId(payInfoPo.getMemId());
        StringBuilder sb = new StringBuilder();
        if (payInfoPo.getIsPushZb() == 2) {
            log.debug("\u63a8\u9001\u62db\u6807\u4f1a\u5458\u8d39\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)pushReqBo));
            abilityRspBO = this.umcMemberFeePushAbilityService.dealPushZbMemFee(pushReqBo);
            log.debug("\u63a8\u9001\u62db\u6807\u4f1a\u5458\u8d39\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
            payInfo.setIsPushZb(Integer.valueOf(1));
            if (!abilityRspBO.getRespCode().equals("0000")) {
                payInfo.setIsPushZb(Integer.valueOf(2));
                payInfo.setPushZbFailedReason(abilityRspBO.getRespDesc());
                sb.append(abilityRspBO.getRespDesc());
            }
        }
        if (payInfoPo.getIsPushFz() == 2) {
            log.debug("\u63a8\u9001\u975e\u62db\u4f1a\u5458\u8d39\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)pushReqBo));
            abilityRspBO = this.umcMemberFeePushAbilityService.dealPushFzMemFee(pushReqBo);
            log.debug("\u63a8\u9001\u975e\u62db\u4f1a\u5458\u8d39\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
            payInfo.setIsPushFz(Integer.valueOf(1));
            if (!abilityRspBO.getRespCode().equals("0000")) {
                payInfo.setIsPushFz(Integer.valueOf(2));
                payInfo.setPushFzFailedReason(abilityRspBO.getRespDesc());
                sb.append(abilityRspBO.getRespDesc());
            }
        }
        this.fscMemPayInfoMapper.update(payInfo);
        FscPushMemPayFeeBusiRspBO rspBO = new FscPushMemPayFeeBusiRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private UmcMemberFeePushAbilityReqBO buildPushReqBo(FscMemPayInfoPO payInfoPo) {
        UmcMemberFeePushAbilityReqBO reqBO = new UmcMemberFeePushAbilityReqBO();
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(payInfoPo.getFscOrderId());
        orderPo = this.fscOrderMapper.getModelBy(orderPo);
        if (orderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u8d39\u76f8\u5173\u4fe1\u606f\uff01" + payInfoPo.getFscOrderId());
        }
        reqBO.setMemberLevelCode(payInfoPo.getMemLevelCode());
        reqBO.setMemberLevelName(payInfoPo.getMemLevelName());
        reqBO.setSupplierId(orderPo.getSupplierId());
        reqBO.setMemLevelId(payInfoPo.getMemLevelId());
        reqBO.setSupplierNo(payInfoPo.getSupplierNo());
        reqBO.setTransactionId(payInfoPo.getMemId());
        reqBO.setType("1");
        reqBO.setStartTime(payInfoPo.getEffDate());
        reqBO.setEndTime(payInfoPo.getExpDate());
        return reqBO;
    }
}

