/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscBillGetYcPersonInfoBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillGetYcPersonInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillGetYcPersonInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillDeleteReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillDeleteRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillGetYcPersonInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillDeleteService;
import com.tydic.fsc.common.busi.api.FscRecvClaimDeleteBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimDeleteBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimDeleteBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRecvClaimDeleteBusiServiceImpl
implements FscRecvClaimDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimDeleteBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscPushYcRecvClaimBillDeleteService fscPushYcRecvClaimBillDeleteService;
    @Autowired
    private FscBillGetYcPersonInfoService fscBillGetYcPersonInfoService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;

    @Override
    public FscRecvClaimDeleteBusiRspBO recvClaimDelete(FscRecvClaimDeleteBusiReqBO reqBO) {
        ArrayList<FscRecvClaimPO> fscRecvClaimPos = new ArrayList();
        fscRecvClaimPos = this.fscRecvClaimMapper.queryByIds(reqBO.getClaimIds());
        this.val(fscRecvClaimPos, reqBO);
        FscBillGetYcPersonInfoReqBO fscBillGetYcPersonInfoReqBO = new FscBillGetYcPersonInfoReqBO();
        fscBillGetYcPersonInfoReqBO.setPERSON_NUM(Long.valueOf(Long.parseLong(reqBO.getUserName())));
        fscBillGetYcPersonInfoReqBO.setORG_ID(Long.valueOf(this.operationOrgId));
        FscBillGetYcPersonInfoRspBO fscBillGetYcPersonInfoRspBO = this.fscBillGetYcPersonInfoService.getPersonInfo(fscBillGetYcPersonInfoReqBO);
        if (!"0000".equals(fscBillGetYcPersonInfoRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscBillGetYcPersonInfoRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)fscBillGetYcPersonInfoRspBO.getRows())) {
            throw new FscBusinessException("194317", "\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        Long userId = ((FscBillGetYcPersonInfoBO)fscBillGetYcPersonInfoRspBO.getRows().get(0)).getUSER_ID();
        for (FscRecvClaimPO po : fscRecvClaimPos) {
            FscRecvClaimPO updateVo = new FscRecvClaimPO();
            updateVo.setClaimId(po.getClaimId());
            updateVo.setRecvStatus(FscClaimRecvStatusEnum.DELETE.getCode());
            this.fscRecvClaimMapper.update(updateVo);
            if (po.getStatus() == null || po.getStatus() != 1) continue;
            FscPushYcRecvClaimBillDeleteReqBO deleteReqBO = new FscPushYcRecvClaimBillDeleteReqBO();
            try {
                deleteReqBO.setTESCO_ID(po.getClaimId());
                deleteReqBO.setCHARGEMAN_ID(String.valueOf(userId));
                FscPushYcRecvClaimBillDeleteRspBO fscPushYcRecvClaimBillDeleteRspBO = this.fscPushYcRecvClaimBillDeleteService.pushYcRecvClaimBillDelete(deleteReqBO);
                if (!fscPushYcRecvClaimBillDeleteRspBO.getRespCode().equals("0000")) {
                    this.saveLog(po, FscConstants.FscPushStatus.FAIL, JSONObject.toJSONString((Object)deleteReqBO));
                    this.savePushStatus(po, 0);
                } else {
                    this.savePushStatus(po, 1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.saveLog(po, FscConstants.FscPushStatus.FAIL, e.getMessage());
                this.savePushStatus(po, 0);
            }
            this.saveLog(po, FscConstants.FscPushStatus.SUCCESS, JSONObject.toJSONString((Object)deleteReqBO));
        }
        FscRecvClaimDeleteBusiRspBO rspBO = new FscRecvClaimDeleteBusiRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void savePushStatus(FscRecvClaimPO po, int i) {
        FscRecvClaimPO updateVo = new FscRecvClaimPO();
        updateVo.setClaimId(po.getClaimId());
        updateVo.setStatus(Integer.valueOf(i));
        this.fscRecvClaimMapper.update(updateVo);
    }

    private void val(List<FscRecvClaimPO> fscRecvClaimPos, FscRecvClaimDeleteBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(fscRecvClaimPos) || reqBO.getClaimIds().size() != fscRecvClaimPos.size()) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u5355\u76f8\u5173\u4fe1\u606f");
        }
        for (FscRecvClaimPO po : fscRecvClaimPos) {
            if (StringUtils.isEmpty((Object)po.getRecvStatus()) || FscClaimRecvStatusEnum.DELETE.getCode().equals(po.getRecvStatus())) {
                throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u6536\u6b3e\u72b6\u6001\u5f02\u5e38");
            }
            if (!StringUtils.isEmpty((Object)po.getClaimStatus()) && FscClaimStatusEnum.NOT_CLAIM.getCode().equals(po.getClaimStatus())) continue;
            throw new FscBusinessException("190000", "\u53ea\u80fd\u5220\u9664\u672a\u8ba4\u9886\u7684\u8ba4\u9886\u5355");
        }
    }

    private void saveLog(FscRecvClaimPO fscRecvClaimPo, Integer status, String jsonStr) {
        try {
            FscPushLogPO fscPushLogPo = new FscPushLogPO();
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(fscRecvClaimPo.getClaimId());
            fscPushLogPo.setObjectNo(fscRecvClaimPo.getClaimNo());
            fscPushLogPo.setType(FscConstants.FscPushType.CLAIM);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            fscPushLogPo.setObjData(jsonStr);
            this.fscPushLogMapper.insert(fscPushLogPo);
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }
}

