/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountCreditInfoListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.MerchantPayRule;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountCreditPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountCreditInfoListQueryAbilityService"})
public class FscAccountCreditInfoListQueryAbilityServiceImpl
implements FscAccountCreditInfoListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountCreditInfoListQueryAbilityServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountCreditInfoList"})
    public FscAccountCreditInfoListQueryAbilityRspBO qryAccountCreditInfoList(@RequestBody FscAccountCreditInfoListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List payObjIds = this.fscMerchantMapper.selectByPayObjId(reqBO.getPayObjId());
        FscAccountCreditPO fscAccountCredit = new FscAccountCreditPO();
        UmcEnterpriseOrgQryDetailAbilityReqBO enterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        enterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(reqBO.getPayObjId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(enterpriseOrgQryDetailAbilityReqBO);
        if (umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") && umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() != null) {
            if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsProfessionalOrg().equals("1")) {
                fscAccountCredit.setMerchantCategory(Integer.valueOf(0));
            } else if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsProfessionalOrg().equals("0")) {
                fscAccountCredit.setMerchantCategory(Integer.valueOf(2));
            }
        }
        fscAccountCredit.setPayObjId(reqBO.getPayObjId());
        fscAccountCredit.setOrgId(reqBO.getCreditOrgId());
        fscAccountCredit.setCreateTimeStart(reqBO.getBeginTime());
        fscAccountCredit.setCreateTimeEnd(reqBO.getEndTime());
        fscAccountCredit.setOrgName(reqBO.getSupplierName());
        fscAccountCredit.setMerchantCategory(reqBO.getMerchantCategory());
        fscAccountCredit.setExceptionFlag(reqBO.getExceptionFlag());
        fscAccountCredit.setBusiType(reqBO.getBusiType());
        List fscAccountCreditPos = this.fscMerchantMapper.selectCreditInfoPage(fscAccountCredit, page);
        String jsonString = JSON.toJSONString((Object)fscAccountCreditPos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List rows = JSON.parseArray((String)jsonString, FscAccountCreditInfoListRspBO.class);
        Map payNodeRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_NODE_RULE");
        Map payBusiSceneMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_BUSI_SCENE");
        for (FscAccountCreditInfoListRspBO row : rows) {
            if (row.getExceptionFlag().equals(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION) || !StringUtils.isEmpty((Object)row.getPayBusiness())) {
                row.setPayBusiSceneRange(row.getPayBusiness());
            }
            if (row.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE)) {
                row.setPayCreditAmount(row.getOverdraft());
                row.setPayBusiSceneRange("1");
            }
            if (null != row.getPayRule()) {
                row.setPayRuleStr(MerchantPayRule.getInstance((Integer)row.getPayRule()).getDescr());
                if (null != row.getPayNodeRule()) {
                    row.setPayNodeRuleStr((String)payNodeRuleMap.get(row.getPayNodeRule().toString()));
                }
            }
            row.setPayBusiSceneRangeStr((String)payBusiSceneMap.get(row.getPayBusiSceneRange()));
            BigDecimal payBreakScale = row.getPayBreakScale();
            if (null != payBreakScale) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u9a8c\u6536\u5355\u91d1\u989d * ").append(payBreakScale.setScale(2, 4).toString()).append("% * \u903e\u671f\u5929\u6570");
                row.setCalculationFormula(sb.toString());
            }
            row.setCreditDate(row.getCreateTime());
        }
        FscAccountCreditInfoListQueryAbilityRspBO rspBO = new FscAccountCreditInfoListQueryAbilityRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    @PostMapping(value={"qryAccountCreditInfoListWelfare"})
    public FscAccountCreditInfoListQueryAbilityRspBO qryAccountCreditInfoListWelfare(@RequestBody FscAccountCreditInfoListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List payObjIds = this.fscMerchantMapper.selectByPayObjId(reqBO.getPayObjId());
        FscAccountPO qryBo = new FscAccountPO();
        qryBo.setOrgId(reqBO.getPayObjId());
        qryBo.setId(reqBO.getAccountId());
        FscAccountPO accountPO = this.fscAccountMapper.getModelBy(qryBo);
        accountPO.setCompanyCreditAvailableAmount(accountPO.getCompanyCreditAvailableAmount().compareTo(BigDecimal.ZERO) > 0 ? accountPO.getCompanyCreditAvailableAmount() : BigDecimal.ZERO);
        accountPO.setUnionCreditAvailableAmount(accountPO.getUnionCreditAvailableAmount().compareTo(BigDecimal.ZERO) > 0 ? accountPO.getUnionCreditAvailableAmount() : BigDecimal.ZERO);
        FscAccountCreditPO fscAccountCredit = new FscAccountCreditPO();
        fscAccountCredit.setMerchantCategory(Integer.valueOf(0));
        fscAccountCredit.setOrgId(this.operationOrgId);
        fscAccountCredit.setUpdateTimeStart(reqBO.getBeginTime());
        fscAccountCredit.setUpdateTimeEnd(reqBO.getEndTime());
        fscAccountCredit.setOrgName(reqBO.getSupplierName());
        fscAccountCredit.setMerchantCategory(reqBO.getMerchantCategory());
        fscAccountCredit.setExceptionFlag(reqBO.getExceptionFlag());
        fscAccountCredit.setBusiType(reqBO.getBusiType());
        fscAccountCredit.setPayObjId(reqBO.getPayObjId());
        List fscAccountCreditPos = this.fscMerchantMapper.selectCreditInfoPageWelfare(fscAccountCredit, page);
        String jsonString = JSON.toJSONString((Object)fscAccountCreditPos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List rows = JSON.parseArray((String)jsonString, FscAccountCreditInfoListRspBO.class);
        if (rows.size() > 1) {
            rows = rows.stream().filter(e -> e.getExceptionFlag().equals(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION)).collect(Collectors.toList());
        }
        Map payNodeRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_NODE_RULE");
        Map payBusiSceneMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_BUSI_SCENE");
        for (FscAccountCreditInfoListRspBO row : rows) {
            if (!FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(row.getPayType())) {
                return new FscAccountCreditInfoListQueryAbilityRspBO();
            }
            row.setCompanyCreditAmount(accountPO.getCompanyCreditAmount());
            row.setCompanyCreditAvailableAmount(accountPO.getCompanyCreditAvailableAmount());
            row.setCompanyCreditUseAmount(accountPO.getCompanyCreditUseAmount());
            accountPO.setCompanyCreditReturnAmount(accountPO.getCompanyCreditReturnAmount() == null ? BigDecimal.ZERO : accountPO.getCompanyCreditReturnAmount());
            accountPO.setUnionCreditReturnAmount(accountPO.getUnionCreditReturnAmount() == null ? BigDecimal.ZERO : accountPO.getUnionCreditReturnAmount());
            row.setCreditReturnAmount(accountPO.getCompanyCreditReturnAmount().add(accountPO.getUnionCreditReturnAmount()));
            row.setCompanyTotalCostAmount(accountPO.getCompanyTotalCostAmount());
            row.setUnionTotalCostAmount(accountPO.getUnionTotalCostAmount());
            row.setUnionCreditAmount(accountPO.getUnionCreditAmount());
            row.setUnionCreditAvailableAmount(accountPO.getUnionCreditAvailableAmount());
            row.setUnionCreditUseAmount(accountPO.getUnionCreditUseAmount());
            row.setUnionTotalCostOverdraftAmount(accountPO.getUnionTotalCostOverdraftAmount());
            row.setCompanyTotalCostOverdraftAmount(accountPO.getCompanyTotalCostOverdraftAmount());
            if (null != row.getPayRule()) {
                row.setPayRuleStr(MerchantPayRule.getInstance((Integer)row.getPayRule()).getDescr());
                if (null != row.getPayNodeRule()) {
                    row.setPayNodeRuleStr((String)payNodeRuleMap.get(row.getPayNodeRule().toString()));
                }
            }
            row.setPayBusiSceneRangeStr((String)payBusiSceneMap.get(row.getPayBusiSceneRange()));
            BigDecimal payBreakScale = row.getPayBreakScale();
            if (null != payBreakScale) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u9a8c\u6536\u5355\u91d1\u989d * ").append(payBreakScale.setScale(2, 4).toString()).append("% * \u903e\u671f\u5929\u6570");
                row.setCalculationFormula(sb.toString());
            }
            row.setCreditDate(row.getUpdateTime());
        }
        FscAccountCreditInfoListQueryAbilityRspBO rspBO = new FscAccountCreditInfoListQueryAbilityRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void val(FscAccountCreditInfoListQueryAbilityReqBO reqBO) {
        if (null == reqBO.getPayObjId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[payObjId]\u4e3a\u7a7a");
        }
    }
}

