/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.busibase.atom.api.FscSupMerchantQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSupMerchantQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSupMerchantQryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscAccountWelfareInfoQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountWelfareInfoQryReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountWelfareInfoQryRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import java.math.BigDecimal;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountWelfareInfoQryAbilityService"})
public class FscAccountWelfareInfoQryAbilityServiceImpl
implements FscAccountWelfareInfoQryAbilityService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscSupMerchantQryAtomService fscSupMerchantQryAtomService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @PostMapping(value={"qryAccountWelfareInfo"})
    public FscAccountWelfareInfoQryRspBO qryAccountWelfareInfo(@RequestBody FscAccountWelfareInfoQryReqBO reqBO) {
        this.valid(reqBO);
        FscAccountPO accountPo = new FscAccountPO();
        accountPo.setOrgId(reqBO.getPurId());
        accountPo = this.fscAccountMapper.getModelBy(accountPo);
        if (accountPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u4fe1\u606f\uff01\u8bf7\u5148\u7ef4\u62a4\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u3002");
        }
        FscSupMerchantQryAtomReqBO atomReqBO = new FscSupMerchantQryAtomReqBO();
        atomReqBO.setPurId(reqBO.getPurId());
        atomReqBO.setSupId(this.operationOrgId);
        atomReqBO.setPayType(reqBO.getPayType());
        atomReqBO.setPayBusiness("4");
        FscSupMerchantQryAtomRspBO atomRspBO = this.fscSupMerchantQryAtomService.qrySupMerchant(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        FscAccountWelfareInfoQryRspBO rspBO = reqBO.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD) ? this.qryWelfareCreditInfo(atomRspBO, reqBO, accountPo) : this.qryWelfareAdvanceInfo(atomRspBO, reqBO, accountPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscAccountWelfareInfoQryRspBO qryWelfareCreditInfo(FscSupMerchantQryAtomRspBO atomRspBO, FscAccountWelfareInfoQryReqBO reqBO, FscAccountPO accountPo) {
        FscAccountWelfareInfoQryRspBO rspBO = new FscAccountWelfareInfoQryRspBO();
        accountPo.setCompanyCreditAmount(atomRspBO.getCompanyCreditAmount());
        accountPo.setUnionCreditAmount(atomRspBO.getUnionCreditAmount());
        if (reqBO.getWelfareType().equals(FscConstants.WelfareType.COMPANY)) {
            rspBO.setCreditAmt(atomRspBO.getCompanyCreditAmount() == null ? BigDecimal.ZERO : atomRspBO.getCompanyCreditAmount());
            rspBO.setAvailableCreditAmt(rspBO.getCreditAmt().subtract(Objects.nonNull(accountPo.getCompanyCreditUseAmount()) ? accountPo.getCompanyCreditUseAmount() : BigDecimal.ZERO));
        } else {
            rspBO.setCreditAmt(atomRspBO.getUnionCreditAmount() == null ? BigDecimal.ZERO : atomRspBO.getUnionCreditAmount());
            rspBO.setAvailableCreditAmt(rspBO.getCreditAmt().subtract(Objects.nonNull(accountPo.getUnionCreditUseAmount()) ? accountPo.getUnionCreditUseAmount() : BigDecimal.ZERO));
        }
        if (rspBO.getAvailableCreditAmt().compareTo(BigDecimal.ZERO) < 0) {
            rspBO.setAvailableCreditAmt(BigDecimal.ZERO);
        }
        return rspBO;
    }

    private FscAccountWelfareInfoQryRspBO qryWelfareAdvanceInfo(FscSupMerchantQryAtomRspBO atomRspBO, FscAccountWelfareInfoQryReqBO reqBO, FscAccountPO accountPo) {
        FscAccountWelfareInfoQryRspBO rspBO = new FscAccountWelfareInfoQryRspBO();
        rspBO.setAccountId(accountPo.getId());
        accountPo.setCompanyOverdraft(atomRspBO.getCompanyOverdraft());
        accountPo.setUnionOverdraft(atomRspBO.getUnionOverdraft());
        if (reqBO.getWelfareType().equals(FscConstants.WelfareType.COMPANY)) {
            rspBO.setAdvanceAmt(accountPo.getCompanyAdvanceAmount());
            rspBO.setOverdraftAmt(accountPo.getCompanyOverdraft());
            BigDecimal availableAmt = accountPo.getCompanyAdvanceAmount().subtract(accountPo.getCompanyFreezeAmount()).subtract(accountPo.getCompanyUseAmount());
            if (availableAmt.compareTo(BigDecimal.ZERO) > 0) {
                rspBO.setAvailableAdvanceAmt(availableAmt);
                rspBO.setAvailableOverdraftAmt(accountPo.getCompanyOverdraft());
            } else {
                rspBO.setAvailableAdvanceAmt(BigDecimal.ZERO);
                rspBO.setAvailableOverdraftAmt(rspBO.getOverdraftAmt().add(availableAmt));
            }
        } else {
            rspBO.setAdvanceAmt(accountPo.getUnionAdvanceAmount());
            rspBO.setOverdraftAmt(accountPo.getUnionOverdraft());
            BigDecimal availableAmt = accountPo.getUnionAdvanceAmount().subtract(accountPo.getUnionFreezeAmount()).subtract(accountPo.getUnionUseAmount());
            if (availableAmt.compareTo(BigDecimal.ZERO) > 0) {
                rspBO.setAvailableAdvanceAmt(availableAmt);
                rspBO.setAvailableOverdraftAmt(accountPo.getUnionOverdraft());
            } else {
                rspBO.setAvailableAdvanceAmt(BigDecimal.ZERO);
                rspBO.setAvailableOverdraftAmt(rspBO.getOverdraftAmt().add(availableAmt));
            }
        }
        if (rspBO.getAvailableOverdraftAmt().compareTo(BigDecimal.ZERO) < 0) {
            rspBO.setAvailableOverdraftAmt(BigDecimal.ZERO);
        }
        return rspBO;
    }

    private void valid(FscAccountWelfareInfoQryReqBO reqBO) {
        if (reqBO.getWelfareType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u798f\u5229\u7c7b\u578b[welfareType]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getPayType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f[payType]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getPurId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u91c7\u8d2d\u5355\u4f4d[purId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

