/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscSyncPushYcPurSettleChargeAbilityService;
import com.tydic.fsc.bill.ability.api.FscSyncPushYcSpecialRefundAbilityService;
import com.tydic.fsc.bill.ability.bo.FscSyncPushYcPurSettleChargeAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscSyncPushYcSpecialRefundAbilityReqBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceRefundBatchApprovalAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceRefundBatchApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceRefundBatchApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcSaleSettleChargeAgainstAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComInvoiceRefundBatchApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscComInvoiceRefundBatchApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceRefundBatchApprovalBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComInvoiceRefundBatchApprovalAbilityService"})
public class FscComInvoiceRefundBatchApprovalAbilityServiceImpl
implements FscComInvoiceRefundBatchApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComInvoiceRefundBatchApprovalAbilityServiceImpl.class);
    @Autowired
    private FscComInvoiceRefundBatchApprovalBusiService fscComInvoiceRefundBatchApprovalBusiService;
    @Autowired
    private FscSyncPushYcSpecialRefundAbilityService fscSyncPushYcSpecialRefundAbilityService;
    @Autowired
    private FscSyncPushYcPurSettleChargeAbilityService fscSyncPushYcPurSettleChargeAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Resource(name="fscPushNewYcSaleSettleChargeAgainstMqServiceProvider")
    private ProxyMessageProducer fscPushNewYcSaleSettleChargeAgainstMqServiceProvider;
    @Value(value="${FSC_PUSH_NEW_YC_SALE_SETTLE_CHARGE_AGAINST_TOPIC:FSC_PUSH_NEW_YC_SALE_SETTLE_CHARGE_AGAINST_TOPIC}")
    private String fscPushNewYcSaleSettleChargeAgainstTopic;
    @Value(value="${FSC_PUSH_NEW_YC_SALE_SETTLE_CHARGE_AGAINST_TAG:FSC_PUSH_NEW_YC_SALE_SETTLE_CHARGE_AGAINST_TAG}")
    private String fscPushNewYcSaleSettleChargeAgainstTag;

    @PostMapping(value={"dealInvoiceRefundBatchApproval"})
    public FscComInvoiceRefundBatchApprovalAbilityRspBO dealInvoiceRefundBatchApproval(@RequestBody FscComInvoiceRefundBatchApprovalAbilityReqBO reqBO) {
        this.valid(reqBO);
        String errorInfo = "";
        ArrayList<Long> pushRefundIds = new ArrayList<Long>();
        for (Long refundId : reqBO.getRefundIds()) {
            FscComInvoiceRefundBatchApprovalBusiReqBO busiReqBO = (FscComInvoiceRefundBatchApprovalBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscComInvoiceRefundBatchApprovalBusiReqBO.class));
            busiReqBO.setRefundId(refundId);
            FscComInvoiceRefundBatchApprovalBusiRspBO busiRspBO = this.fscComInvoiceRefundBatchApprovalBusiService.dealInvoiceRefundBatchApproval(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                errorInfo = errorInfo + "\u9000\u7968\u5355" + refundId + "\u5ba1\u6279\u5931\u8d25\uff0c" + busiRspBO.getRespDesc() + ";";
            }
            this.sendMq(refundId);
            if (busiRspBO.getSaleRefundId() != null) {
                pushRefundIds.add(busiRspBO.getSaleRefundId());
            }
            if (busiRspBO.getSpecialRefundId() != null) {
                FscSyncPushYcSpecialRefundAbilityReqBO specialRefundAbilityReqBO = new FscSyncPushYcSpecialRefundAbilityReqBO();
                specialRefundAbilityReqBO.setRefundId(busiRspBO.getSpecialRefundId());
                this.fscSyncPushYcSpecialRefundAbilityService.PushYcSpecialRefund(specialRefundAbilityReqBO);
            }
            if (busiRspBO.getPurRefundId() == null) continue;
            FscSyncPushYcPurSettleChargeAbilityReqBO chargeAbilityReqBO = new FscSyncPushYcPurSettleChargeAbilityReqBO();
            chargeAbilityReqBO.setRefundId(busiRspBO.getPurRefundId());
            this.fscSyncPushYcPurSettleChargeAbilityService.syncPushPurSettleCharge(chargeAbilityReqBO);
        }
        if (!CollectionUtils.isEmpty(pushRefundIds)) {
            this.sendPushMq(pushRefundIds);
        }
        FscComInvoiceRefundBatchApprovalAbilityRspBO rspBO = new FscComInvoiceRefundBatchApprovalAbilityRspBO();
        if (StringUtils.isEmpty((Object)errorInfo)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(errorInfo);
        }
        return rspBO;
    }

    private void valid(FscComInvoiceRefundBatchApprovalAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9000\u7968\u5355Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAuditResult() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncReqBO = new FscComRefundSyncAbilityReqBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        refundIds.add(refundId);
        syncReqBO.setRefundIds(refundIds);
        this.fscComRefundSyncAbilityService.syncRefund(syncReqBO);
    }

    private void sendPushMq(List<Long> pushRefundIds) {
        FscPushNewYcSaleSettleChargeAgainstAbilityReqBO reqBO = new FscPushNewYcSaleSettleChargeAgainstAbilityReqBO();
        reqBO.setRefundIds(pushRefundIds);
        log.info("\u4e0b\u6e38\u9000\u7968\u5355\u5ba1\u6279\u901a\u8fc7\u53d1\u9001\u63a8\u9001\u4e1a\u8d22mq\u6d88\u606f" + JSONObject.toJSONString((Object)reqBO));
        ProxySendResult proxySendResult = this.fscPushNewYcSaleSettleChargeAgainstMqServiceProvider.send(new ProxyMessage(this.fscPushNewYcSaleSettleChargeAgainstTopic, this.fscPushNewYcSaleSettleChargeAgainstTag, JSONObject.toJSONString((Object)reqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            log.error("\u53d1\u9001mq\u6d88\u606f\u5931\u8d25" + pushRefundIds);
        }
    }
}

