/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderApprovalAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyPayBillAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcPayBillAbilityService;
import com.tydic.fsc.common.ability.api.FscReleaseFundPlanAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushNewYcPayBillAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComOrderApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyPayBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscReleaseFundPlanAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderApprovalBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderApprovalAbilityService"})
public class FscComOrderApprovalAbilityServiceImpl
implements FscComOrderApprovalAbilityService {
    @Autowired
    private FscComOrderApprovalBusiService fscComOrderApprovalBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscPushYcPayBillAbilityService fscPushYcPayBillAbilityService;
    @Autowired
    private FscSyncPushNewYcPayBillAbilityService fscSyncPushNewYcPayBillAbilityService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Resource(name="fscSyncPushUnifyPayMqServiceProvider")
    private ProxyMessageProducer fscSyncPushUnifyPayMqServiceProvider;
    @Value(value="${es.FSC_PUSH_UNIFY_PAY_TOPIC:FSC_PUSH_UNIFY_PAY_TOPIC}")
    private String fscPushUnifyPayTopic;
    @Value(value="${es.FSC_PUSH_UNIFY_PAY_TAG:FSC_PUSH_UNIFY_PAY_TAG}")
    private String fscPushUnifyPayTag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscPushUnifyPayBillAbilityService fscPushUnifyPayBillAbilityService;
    @Autowired
    private FscReleaseFundPlanAbilityService fscReleaseFundPlanAbilityService;
    public static final String PASS = "0";
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderApproval"})
    public FscComOrderApprovalAbilityRspBO dealOrderApproval(@RequestBody FscComOrderApprovalAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.TO_BE_APPROVAL.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191124", "\u5f53\u524d\u4ed8\u6b3e\u5355\u4e0d\u4e3a\u5f85\u5ba1\u6279\u72b6\u6001");
        }
        Integer count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList());
        if (count == 0) {
            this.sendMq(reqBO);
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        FscComOrderApprovalBusiReqBO busiReqBO = new FscComOrderApprovalBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        busiReqBO.setOrderFlow(fscOrder.getOrderFlow());
        busiReqBO.setOrderState(fscOrder.getOrderState());
        busiReqBO.setActualAmount(fscOrder.getActualAmount());
        busiReqBO.setFscOrder(fscOrder);
        busiReqBO.setTotalCharge(fscOrder.getTotalCharge());
        FscComOrderApprovalBusiRspBO busiRspBO = this.fscComOrderApprovalBusiService.dealOrderApproval(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191124", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        if (!busiRspBO.getFinish().booleanValue()) {
            FscSyncSendNotificationReqBO sendNotificationReqBO = new FscSyncSendNotificationReqBO();
            sendNotificationReqBO.setObjId(reqBO.getOrderId());
            sendNotificationReqBO.setUserId(reqBO.getUserId());
            sendNotificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.PAY_WAIT_AUDIT);
            this.fscSyncSendNotificationService.syncSendNotification(sendNotificationReqBO);
        }
        boolean ycflag = true;
        if ("1".equals(reqBO.getIsprofess()) && fscOrder.getSettlePlatform() != null && fscOrder.getSettlePlatform() == 2 && fscOrder.getTradeMode() != null && fscOrder.getTradeMode() == 2 && busiRspBO.getFinish().booleanValue()) {
            if (reqBO.getAuditResult() == 0) {
                ycflag = false;
                FscPushUnifyPayBillAbilityReqBO reqBO2 = new FscPushUnifyPayBillAbilityReqBO();
                reqBO2.setFscOrderId(reqBO.getOrderId());
                try {
                    this.fscPushUnifyPayBillAbilityService.dealPushUnifyPayBill(reqBO2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (reqBO.getAuditResult() == 1) {
                this.releasePlan(fscOrder);
            }
        }
        if (PASS.equals(reqBO.getIsprofess()) && fscOrder.getOrderFlow() == 1 && reqBO.getAuditResult() == 0 && busiRspBO.getFinish().booleanValue() && fscOrder.getTradeMode() != null && (fscOrder.getTradeMode() == 1 || fscOrder.getTradeMode() == 2 && Integer.valueOf("3").equals(fscOrder.getOrderSource()))) {
            FscPushNewYcPayBillAbilityReqBO pushReqBo = new FscPushNewYcPayBillAbilityReqBO();
            pushReqBo.setFscOrderId(reqBO.getOrderId());
            this.fscSyncPushNewYcPayBillAbilityService.syncPushNewYcPayBill(pushReqBo);
        }
        return new FscComOrderApprovalAbilityRspBO();
    }

    private void writeFailLog(Long data) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(String.valueOf(data));
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_PAY_BILL_CREATE_PUSH_SETTLE_PLAT_FORM_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void val(FscComOrderApprovalAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getAuditResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[auditResult]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscComOrderApprovalAbilityReqBO reqBO) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
    }

    private void releasePlan(FscOrderPO fscOrderPO) {
        FscReleaseFundPlanAbilityReqBO fundPlanAbilityReqBO = new FscReleaseFundPlanAbilityReqBO();
        fundPlanAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
        fundPlanAbilityReqBO.setType(Integer.valueOf(1));
        this.fscReleaseFundPlanAbilityService.releasePlan(fundPlanAbilityReqBO);
    }
}

