/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.busi.api.FscComOrderSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComOrderListBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderListEsSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderSyncRspBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.utils.ApplicationContextProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FscComOrderEsSyncThreadsImpl {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderEsSyncThreadsImpl.class);
    private static List<FscSyncReqBO> failureCombReqBO = new ArrayList<FscSyncReqBO>();
    private static Boolean isSyncStatistics;
    private static Map<Long, FscSyncReqBO> statisticsMap;
    private static List<FscSyncReqBO> failureStatisticsReqBO;

    public synchronized Boolean handleList(List<FscSyncReqBO> data, int threadNum, Boolean isSyncStatistics) throws InterruptedException {
        FscComOrderEsSyncThreadsImpl.isSyncStatistics = isSyncStatistics;
        boolean isFailure = false;
        int length = data.size();
        int maxThreadNum = Runtime.getRuntime().availableProcessors();
        if (threadNum <= 0) {
            threadNum = maxThreadNum;
        } else if (threadNum > maxThreadNum) {
            threadNum = maxThreadNum;
        }
        if (length < threadNum) {
            threadNum = length;
        }
        log.info("-------\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u5f00\u59cb\uff0c\u542f\u52a8\u7ebf\u7a0b\u6570{}--------------", (Object)threadNum);
        failureCombReqBO = new ArrayList<FscSyncReqBO>();
        CountDownLatch countDownLatch = new CountDownLatch(threadNum);
        int baseNum = length / threadNum;
        int remainderNum = length % threadNum;
        int end = 0;
        for (int i = 0; i < threadNum; ++i) {
            int start = end;
            end = start + baseNum;
            if (i == threadNum - 1) {
                end = length;
            } else if (i < remainderNum) {
                ++end;
            }
            List<FscSyncReqBO> threadData = data.subList(start, end);
            HandleThread thread = new HandleThread(threadData, countDownLatch);
            thread.start();
        }
        countDownLatch.await();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(failureCombReqBO)) {
            log.info("---ES\u6279\u91cf\u591a\u7ebf\u7a0b\u540c\u6b65\u5931\u8d25\u6761\u6570\uff1a{}\uff0c\u5931\u8d25\u6570\u636e\uff1a{}", (Object)failureCombReqBO.size(), (Object)JSON.toJSONString(failureCombReqBO));
            isFailure = true;
        }
        failureCombReqBO = null;
        log.info("-------\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u7ed3\u675f--------------");
        return isFailure;
    }

    static {
        statisticsMap = new ConcurrentHashMap<Long, FscSyncReqBO>();
        failureStatisticsReqBO = new ArrayList<FscSyncReqBO>();
    }

    static class HandleThread
    extends Thread {
        private final List<FscSyncReqBO> data;
        private final CountDownLatch countDownLatch;
        private final FscComOrderSyncEsBusiService fscComOrderSyncEsBusiService;
        private final FscEsSyncComOrderListBusiService fscEsSyncComOrderListBusiService;

        public HandleThread(List<FscSyncReqBO> data, CountDownLatch countDownLatch) {
            this.data = data;
            this.countDownLatch = countDownLatch;
            this.fscComOrderSyncEsBusiService = (FscComOrderSyncEsBusiService)ApplicationContextProvider.getBean(FscComOrderSyncEsBusiService.class);
            this.fscEsSyncComOrderListBusiService = (FscEsSyncComOrderListBusiService)ApplicationContextProvider.getBean(FscEsSyncComOrderListBusiService.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (CollectionUtils.isEmpty(this.data)) return;
            Iterator<FscSyncReqBO> iterator = this.data.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.countDownLatch.countDown();
                    return;
                }
                FscSyncReqBO syncReqBO = iterator.next();
                try {
                    syncReqBO.setIsStatistics(true);
                    FscComOrderListQueryBusiReqBO fscComOrderListQueryBusiReqBO = (FscComOrderListQueryBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)syncReqBO), FscComOrderListQueryBusiReqBO.class);
                    FscComOrderSyncRspBO fscComOrderSyncRspBO = this.fscComOrderSyncEsBusiService.dealComOrderSyncEs(fscComOrderListQueryBusiReqBO);
                    if (fscComOrderSyncRspBO.getRespCode().equals("0000")) {
                        FscComOrderListEsSyncRspBO fscComOrderListEsSyncRspBO = this.fscEsSyncComOrderListBusiService.esSyncComOrderList(fscComOrderSyncRspBO.getFscComOrderListEsSyncReqBO());
                        if (fscComOrderListEsSyncRspBO.getRespCode().equals("0000")) continue;
                        log.error("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u653e\u5165ES\u5931\u8d25\uff01" + fscComOrderSyncRspBO.getRespDesc());
                        Class<FscComOrderEsSyncThreadsImpl> clazz = FscComOrderEsSyncThreadsImpl.class;
                        // MONITORENTER : com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl.class
                        failureCombReqBO.add(syncReqBO);
                        // MONITOREXIT : clazz
                        continue;
                    }
                    log.error("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff01" + fscComOrderSyncRspBO.getRespDesc());
                    Class<FscComOrderEsSyncThreadsImpl> clazz = FscComOrderEsSyncThreadsImpl.class;
                    // MONITORENTER : com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl.class
                    failureCombReqBO.add(syncReqBO);
                    // MONITOREXIT : clazz
                }
                catch (Exception e) {
                    log.error("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u5904\u7406\u5f02\u5e38\uff01" + e);
                    Class<FscComOrderEsSyncThreadsImpl> clazz = FscComOrderEsSyncThreadsImpl.class;
                    // MONITORENTER : com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl.class
                    failureCombReqBO.add(syncReqBO);
                    // MONITOREXIT : clazz
                    continue;
                }
                break;
            }
        }
    }
}

