/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCInitAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderToYCAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignToYCBusiService;
import com.tydic.fsc.bill.busi.api.FscPushYcMemInvoiceBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignToYCBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPushYcMemInvoiceBusiReqBO;
import com.tydic.fsc.bo.FscComOrderPushBO;
import com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl;
import com.tydic.fsc.common.busi.api.FscPushYcPayBillBusiService;
import com.tydic.fsc.common.busi.api.FscPushYcRecvClaimBillBusiService;
import com.tydic.fsc.common.busi.api.FscPushYcRecvClaimChangeNewBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcPayBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimChangeBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.utils.ApplicationContextProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FscComOrderInitPushNewYcThreadsImpl {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderInitPushNewYcThreadsImpl.class);
    private static List<FscComOrderPushBO> failureReqBO = new ArrayList<FscComOrderPushBO>();

    public synchronized Boolean handleList(List<FscComOrderPushBO> data, int threadNum) throws InterruptedException {
        boolean isFailure = false;
        int length = data.size();
        int maxThreadNum = Runtime.getRuntime().availableProcessors();
        log.debug("-------\u591a\u7ebf\u7a0b\u63a8\u9001\u65b0\u4e1a\u8d22\u6570\u636e\u5f00\u59cb\uff0c\u6700\u591a\u542f\u52a8\u7ebf\u7a0b\u6570---------" + maxThreadNum);
        if (threadNum <= 0) {
            threadNum = maxThreadNum;
        } else if (threadNum > maxThreadNum) {
            threadNum = maxThreadNum;
        }
        if (length < threadNum) {
            threadNum = length;
        }
        log.debug("-------\u591a\u7ebf\u7a0b\u63a8\u9001\u65b0\u4e1a\u8d22\u6570\u636e\u5f00\u59cb\uff0c\u542f\u52a8\u7ebf\u7a0b\u6570{}--------------", (Object)threadNum);
        failureReqBO = new ArrayList<FscComOrderPushBO>();
        CountDownLatch countDownLatch = new CountDownLatch(threadNum);
        int baseNum = length / threadNum;
        int remainderNum = length % threadNum;
        int end = 0;
        for (int i = 0; i < threadNum; ++i) {
            int start = end;
            end = start + baseNum;
            if (i == threadNum - 1) {
                end = length;
            } else if (i < remainderNum) {
                ++end;
            }
            List<FscComOrderPushBO> threadData = data.subList(start, end);
            HandleThread thread = new HandleThread(threadData, countDownLatch);
            thread.start();
        }
        countDownLatch.await();
        if (!CollectionUtils.isEmpty(failureReqBO)) {
            log.info("---ES\u6279\u91cf\u591a\u7ebf\u7a0b\u540c\u6b65\u5931\u8d25\u6761\u6570\uff1a{}\uff0c\u5931\u8d25\u6570\u636e\uff1a{}", (Object)failureReqBO.size(), (Object)JSON.toJSONString(failureReqBO));
            isFailure = true;
        }
        failureReqBO = null;
        log.info("-------\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u7ed3\u675f--------------");
        return isFailure;
    }

    static class HandleThread
    extends Thread {
        private final List<FscComOrderPushBO> pushData;
        private final CountDownLatch countDownLatch;
        private final FscBillOrderInvoiceSignToYCBusiService fscBillOrderInvoiceSignToYCBusiService;
        private final FscBillSendSaleFscOrderToYCInitAbilityService fscBillSendSaleFscOrderToYCInitAbilityService;
        private final FscPushYcPayBillBusiService fscPushYcPayBillBusiService;
        private final FscPushYcRecvClaimBillBusiService fscPushYcRecvClaimBillBusiService;
        private final FscPushYcRecvClaimChangeNewBusiService fscPushYcRecvClaimChangeNewBusiService;
        private final FscPushYcMemInvoiceBusiService fscPushYcMemInvoiceBusiService;
        private final FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
        private final FscPushLogMapper fscPushLogMapper;

        public HandleThread(List<FscComOrderPushBO> pushData, CountDownLatch countDownLatch) {
            this.pushData = pushData;
            this.countDownLatch = countDownLatch;
            this.fscBillOrderInvoiceSignToYCBusiService = (FscBillOrderInvoiceSignToYCBusiService)ApplicationContextProvider.getBean(FscBillOrderInvoiceSignToYCBusiService.class);
            this.fscBillSendSaleFscOrderToYCInitAbilityService = (FscBillSendSaleFscOrderToYCInitAbilityService)ApplicationContextProvider.getBean(FscBillSendSaleFscOrderToYCInitAbilityService.class);
            this.fscPushYcPayBillBusiService = (FscPushYcPayBillBusiService)ApplicationContextProvider.getBean(FscPushYcPayBillBusiService.class);
            this.fscPushYcRecvClaimBillBusiService = (FscPushYcRecvClaimBillBusiService)ApplicationContextProvider.getBean(FscPushYcRecvClaimBillBusiService.class);
            this.fscPushYcRecvClaimChangeNewBusiService = (FscPushYcRecvClaimChangeNewBusiService)ApplicationContextProvider.getBean(FscPushYcRecvClaimChangeNewBusiService.class);
            this.fscBillAddPushLogAbilityService = (FscBillAddPushLogAbilityService)ApplicationContextProvider.getBean(FscBillAddPushLogAbilityService.class);
            this.fscPushYcMemInvoiceBusiService = (FscPushYcMemInvoiceBusiService)ApplicationContextProvider.getBean(FscPushYcMemInvoiceBusiService.class);
            this.fscPushLogMapper = (FscPushLogMapper)ApplicationContextProvider.getBean(FscPushLogMapper.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (CollectionUtils.isEmpty(this.pushData)) {
                log.error("\u6279\u91cf\u63a8\u9001\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            String initFlag = "Y";
            try {
                Iterator<FscComOrderPushBO> iterator = this.pushData.iterator();
                while (iterator.hasNext()) {
                    Object reqBO;
                    FscComOrderPushBO pushBO = iterator.next();
                    FscRspBaseBO rspBO = new FscRspBaseBO();
                    FscPushLogPO pushLogPO = new FscPushLogPO();
                    pushLogPO.setObjectId(pushBO.getObjId());
                    pushLogPO.setType(pushBO.getPushType());
                    pushLogPO.setStatus(FscConstants.FscPushStatus.SUCCESS);
                    pushLogPO = this.fscPushLogMapper.getInitLastPushLog(pushLogPO);
                    if (pushLogPO != null) {
                        Class<FscComOrderEsSyncThreadsImpl> clazz = FscComOrderEsSyncThreadsImpl.class;
                        // MONITORENTER : com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl.class
                        pushBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
                        failureReqBO.add(pushBO);
                        // MONITOREXIT : clazz
                        continue;
                    }
                    if (pushBO.getPushType().equals(FscConstants.FscPushType.SETTLE)) {
                        reqBO = new FscBillOrderInvoiceSignToYCBusiReqBO();
                        reqBO.setOrderId(pushBO.getObjId());
                        reqBO.setAgentAccount(pushBO.getAgentAccount());
                        reqBO.setInitFlag("Y");
                        rspBO = this.fscBillOrderInvoiceSignToYCBusiService.dealOrderInvoiceSignToYC((FscBillOrderInvoiceSignToYCBusiReqBO)reqBO);
                    } else if (pushBO.getPushType().equals(FscConstants.FscPushType.SALE_SETTLE)) {
                        reqBO = new FscBillSendSaleFscOrderToYCAbilityReqBO();
                        reqBO.setFscOrderIds(Collections.singletonList(pushBO.getObjId()));
                        reqBO.setAgentAccount(pushBO.getAgentAccount());
                        reqBO.setInitFlag("Y");
                        reqBO.setPushFlag("Y");
                        rspBO = this.fscBillSendSaleFscOrderToYCInitAbilityService.initSendSaleFscOrder((FscBillSendSaleFscOrderToYCAbilityReqBO)reqBO);
                    } else if (pushBO.getPushType().equals(FscConstants.FscPushType.CLAIM)) {
                        reqBO = new FscPushYcRecvClaimBillBusiReqBO();
                        ((FscPushYcRecvClaimBillBusiReqBO)((Object)reqBO)).setClaimId(pushBO.getObjId());
                        reqBO.setAgentAccount(pushBO.getAgentAccount());
                        ((FscPushYcRecvClaimBillBusiReqBO)((Object)reqBO)).setInitFlag("Y");
                        rspBO = this.fscPushYcRecvClaimBillBusiService.pushYcRecvClaim((FscPushYcRecvClaimBillBusiReqBO)((Object)reqBO));
                    } else if (pushBO.getPushType().equals(FscConstants.FscPushType.PAY)) {
                        reqBO = new FscPushYcPayBillBusiReqBO();
                        ((FscPushYcPayBillBusiReqBO)((Object)reqBO)).setOrderId(pushBO.getObjId());
                        reqBO.setAgentAccount(pushBO.getAgentAccount());
                        ((FscPushYcPayBillBusiReqBO)((Object)reqBO)).setInitFlag("Y");
                        rspBO = this.fscPushYcPayBillBusiService.pushYcPayBill((FscPushYcPayBillBusiReqBO)((Object)reqBO));
                    } else if (pushBO.getPushType().equals(FscConstants.FscPushType.CLAIM_CHANGE)) {
                        reqBO = new FscPushYcRecvClaimChangeBusiReqBO();
                        ((FscPushYcRecvClaimChangeBusiReqBO)((Object)reqBO)).setChangeId(pushBO.getObjId());
                        reqBO.setAgentAccount(pushBO.getAgentAccount());
                        ((FscPushYcRecvClaimChangeBusiReqBO)((Object)reqBO)).setInitFlag("Y");
                        rspBO = this.fscPushYcRecvClaimChangeNewBusiService.pushYcRecvClaimNew((FscPushYcRecvClaimChangeBusiReqBO)((Object)reqBO));
                    } else if (pushBO.getPushType().equals(FscConstants.FscPushType.MEM_FEE_INVOICE)) {
                        reqBO = new FscPushYcMemInvoiceBusiReqBO();
                        reqBO.setOrderId(pushBO.getObjId());
                        reqBO.setAgentAccount(pushBO.getAgentAccount());
                        rspBO = this.fscPushYcMemInvoiceBusiService.dealPushMemInvoice((FscPushYcMemInvoiceBusiReqBO)reqBO);
                    }
                    FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
                    logAbilityReqBO.setObjData(rspBO.getRespDesc());
                    logAbilityReqBO.setObjectId(pushBO.getObjId());
                    logAbilityReqBO.setType(pushBO.getPushType());
                    logAbilityReqBO.setStatus("0000".equals(rspBO.getRespCode()) ? FscConstants.FscPushStatus.SUCCESS : FscConstants.FscPushStatus.FAIL);
                    logAbilityReqBO.setCreateTime(new Date());
                    this.fscBillAddPushLogAbilityService.saveInitPushLog(logAbilityReqBO);
                    if ("0000".equals(rspBO.getRespCode())) continue;
                    pushBO.setRespCode(rspBO.getRespCode());
                    pushBO.setRespDesc(rspBO.getRespDesc());
                    log.error(pushBO.getObjId() + "\u521d\u59cb\u5316\u63a8\u9001\u65b0\u4e1a\u8d22\u5931\u8d25\uff1a" + rspBO.getRespDesc());
                    Class<FscComOrderEsSyncThreadsImpl> clazz = FscComOrderEsSyncThreadsImpl.class;
                    // MONITORENTER : com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl.class
                    failureReqBO.add(pushBO);
                    // MONITOREXIT : clazz
                }
                return;
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u63a8\u9001\u65b0\u4e1a\u8d22\u5355\u636e\u5931\u8d25\uff1a" + e.getMessage());
                e.printStackTrace();
                return;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

