/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderRefundCancelAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderRefundCancelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderRefundCancelAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderRefundCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderRefundCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderRefundCancelBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscIdempotentCommitLimit;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderRefundCancelAbilityService"})
public class FscComOrderRefundCancelAbilityServiceImpl
implements FscComOrderRefundCancelAbilityService {
    @Autowired
    private FscComOrderRefundCancelBusiService fscComOrderRefundCancelBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;

    @FscIdempotentCommitLimit(lockKey="refundIds")
    @PostMapping(value={"dealOrderRefundCancel"})
    public FscComOrderRefundCancelAbilityRspBO dealOrderRefundCancel(@RequestBody FscComOrderRefundCancelAbilityReqBO reqBO) {
        this.valid(reqBO);
        for (Long refundId : reqBO.getRefundIds()) {
            FscComOrderRefundCancelBusiReqBO busiReqBO = (FscComOrderRefundCancelBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscComOrderRefundCancelBusiReqBO.class));
            busiReqBO.setRefundId(refundId);
            FscComOrderRefundCancelBusiRspBO busiRspBO = this.fscComOrderRefundCancelBusiService.dealRefactorOrderRefundCancel(busiReqBO);
            if ("0000".equals(busiRspBO.getRespCode())) {
                FscComOrderRefundCancelAbilityReqBO syncReqBO = new FscComOrderRefundCancelAbilityReqBO();
                ArrayList<Long> refundIds = new ArrayList<Long>();
                refundIds.add(refundId);
                syncReqBO.setRefundIds(refundIds);
                this.sendMq(syncReqBO);
                this.sendSyncFscOrderMq(busiRspBO);
                continue;
            }
            throw new FscBusinessException("198888", "\u9000\u7968Id" + refundId + "\u53d6\u6d88\u5931\u8d25\uff1a" + busiRspBO.getRespDesc());
        }
        FscComOrderRefundCancelAbilityRspBO rspBO = new FscComOrderRefundCancelAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendMq(FscComOrderRefundCancelAbilityReqBO reqBO) {
        FscComRefundSyncAbilityReqBO syncReqBO = new FscComRefundSyncAbilityReqBO();
        syncReqBO.setRefundIds(reqBO.getRefundIds());
        this.fscComRefundSyncAbilityService.syncRefund(syncReqBO);
    }

    private void sendSyncFscOrderMq(FscComOrderRefundCancelBusiRspBO busiRspBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        for (Long fscOrderId : busiRspBO.getFscOrderIds()) {
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        for (Long fscOrderId : busiRspBO.getFscOrderIds()) {
            fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        }
    }

    private void valid(FscComOrderRefundCancelAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636eID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

