/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscEsQryComRefundListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscEsQryComRefundListBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscEsQryComRefundListBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundInvoiceApprovalListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundInvoiceApprovalListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundInvoiceApprovalListQryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComRefundInvoiceApprovalListQryAbilityService"})
public class FscComRefundInvoiceApprovalListQryListQryAbilityServiceImpl
implements FscComRefundInvoiceApprovalListQryAbilityService {
    @Autowired
    private FscEsQryComRefundListBusiService fscEsQryComRefundListBusiService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    private static final String SUM_FIELD = "refundAmount";

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryRefundInvoiceApprovalList"})
    public FscComRefundInvoiceApprovalListQryAbilityRspBO qryRefundInvoiceApprovalList(@RequestBody FscComRefundInvoiceApprovalListQryAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscEsQryComRefundListBusiReqBO busiReqBO = (FscEsQryComRefundListBusiReqBO)JSONObject.parseObject((String)reqString, FscEsQryComRefundListBusiReqBO.class);
        ArrayList<Integer> auditStatus = new ArrayList<Integer>();
        if (reqBO.getTabId().equals(FscConstants.RefundApprovalTabId.PENDING)) {
            auditStatus.add(FscConstants.AuditStatus.AUDITING);
            busiReqBO.setRefundStatus(FscConstants.RefundInvoiceStatus.AUDITING);
            busiReqBO.setTaskOperIdList(reqBO.getStationsList());
            busiReqBO.setOrderByDesc("arrivalTime");
        } else if (reqBO.getTabId().equals(FscConstants.RefundApprovalTabId.REJECT)) {
            auditStatus.add(FscConstants.AuditStatus.AUDIT_REJECT);
            busiReqBO.setRefundStatus(FscConstants.RefundInvoiceStatus.APPROVAL_REJECT);
            busiReqBO.setAuditedTaskOperIdList(Collections.singletonList(reqBO.getUserId()));
            busiReqBO.setOrderByDesc("auditTime");
        } else if (reqBO.getTabId().equals(FscConstants.RefundApprovalTabId.APPROVED)) {
            auditStatus.add(FscConstants.AuditStatus.AUDIT_PASS);
            busiReqBO.setAuditedTaskOperIdList(Collections.singletonList(reqBO.getUserId()));
            busiReqBO.setOrderByDesc("auditTime");
        } else {
            auditStatus.add(FscConstants.AuditStatus.AUDITING);
            auditStatus.add(FscConstants.AuditStatus.AUDIT_PASS);
            auditStatus.add(FscConstants.AuditStatus.AUDIT_REJECT);
            busiReqBO.setAuditIdList(reqBO.getStationsList());
        }
        if (FscConstants.OrderFlow.REFUND_PAY.equals(reqBO.getOrderFLow())) {
            busiReqBO.setRefundStatus(null);
        }
        if ("2".equals(reqBO.getIsprofess())) {
            busiReqBO.setPayeeIds(Collections.singletonList(reqBO.getSupId()));
        }
        if (reqBO.getMakeType() != null && reqBO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION)) {
            busiReqBO.setQrySaleFlag(FscConstants.YES);
            FscDicDictionaryBO dictionaryBO = new FscDicDictionaryBO();
            dictionaryBO.setPCode("FSC_OPERATION_SUP_ID");
            dictionaryBO = this.fscDictionaryBusiService.getDictionaryByBO(dictionaryBO);
            if (dictionaryBO == null) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u5b57\u5178[FSC_OPERATION_SUP_ID]\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\u3002");
            }
            busiReqBO.setSupplierId(Long.valueOf(dictionaryBO.getCode()));
            ArrayList<Integer> orderFlows = new ArrayList<Integer>();
            orderFlows.add(FscConstants.OrderFlow.REFUND_INVOICE);
            orderFlows.add(FscConstants.OrderFlow.TRAFFIC_REFUND_INVOICE);
            busiReqBO.setOrderFlows(orderFlows);
        }
        busiReqBO.setAuditStatus(auditStatus);
        FscEsQryComRefundListBusiRspBO busiRspBO = this.fscEsQryComRefundListBusiService.esQryComRefundList(busiReqBO);
        FscComRefundInvoiceApprovalListQryAbilityRspBO rspBO = new FscComRefundInvoiceApprovalListQryAbilityRspBO();
        busiReqBO.setSumField(Collections.singletonList(SUM_FIELD));
        FscEsQryComRefundListBusiRspBO sumRspBO = this.fscEsQryComRefundListBusiService.esQryComRefundList(busiReqBO);
        if (!CollectionUtils.isEmpty((Map)sumRspBO.getSumFieldInfo())) {
            rspBO.setSumRefundAmt((BigDecimal)sumRspBO.getSumFieldInfo().get(SUM_FIELD));
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(busiRspBO.getTotal());
        rspBO.setRecordsTotal(busiRspBO.getRecordsTotal());
        rspBO.setRows(busiRspBO.getRows());
        return rspBO;
    }

    private void valid(FscComRefundInvoiceApprovalListQryAbilityReqBO reqBO) {
        if (reqBO.getTabId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[tabId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[stationsList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

