/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscOrderWriteDetailBO;
import com.tydic.fsc.common.ability.api.FscOrderListToAutoWriteAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderListToAutoWriteAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderListToAutoWriteAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderWriteBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderToWritePO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderListToAutoWriteAbilityService"})
public class FscOrderListToAutoWriteAbilityServiceImpl
implements FscOrderListToAutoWriteAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"getFscOrderListToAutoWrite"})
    public FscOrderListToAutoWriteAbilityRspBO getFscOrderListToAutoWrite(@RequestBody FscOrderListToAutoWriteAbilityReqBO reqBO) {
        List chooseWriteList;
        FscOrderListToAutoWriteAbilityRspBO rspBO = new FscOrderListToAutoWriteAbilityRspBO();
        if (reqBO == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[claimId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> writeList = reqBO.getWriteList();
        if (CollectionUtils.isEmpty((Collection)writeList)) {
            FscOrderToWritePO fscOrderWritePO = (FscOrderToWritePO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderToWritePO.class);
            Page page = new Page(-1, -1);
            List list = this.fscOrderMapper.getFscOrderListToAdvanceWrite(fscOrderWritePO, page);
            writeList = JSON.parseArray((String)JSONObject.toJSONString((Object)list), FscOrderWriteBO.class);
        }
        if (CollectionUtils.isEmpty((Collection)(chooseWriteList = reqBO.getChooseWriteList()))) {
            chooseWriteList = writeList;
        }
        if (CollectionUtils.isEmpty((Collection)chooseWriteList)) {
            throw new FscBusinessException("190000", "\u53ef\u6838\u9500\u5355\u636e\u4e3a\u7a7a");
        }
        List claimDetailList = reqBO.getClaimWriteList();
        if (CollectionUtils.isEmpty((Collection)claimDetailList)) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8ba4\u9886\u5355\u53ef\u6838\u9500\u660e\u7ec6[claimWriteList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, List<FscClaimDetailBO>> buynerMap = claimDetailList.stream().collect(Collectors.groupingBy(FscClaimDetailBO::getBuynerNo));
        ArrayList<FscClaimDetailBO> claimWriteList = new ArrayList<FscClaimDetailBO>();
        HashMap<String, FscOrderWriteBO> writeBOMap = new HashMap<String, FscOrderWriteBO>();
        for (FscOrderWriteBO fscOrderWriteBO : writeList) {
            writeBOMap.put(fscOrderWriteBO.getFscOrderId().toString() + fscOrderWriteBO.getOrderId(), fscOrderWriteBO);
        }
        for (String key : buynerMap.keySet()) {
            List<FscClaimDetailBO> fscClaimDetailPOList = buynerMap.get(key);
            if (!CollectionUtils.isEmpty(fscClaimDetailPOList)) {
                Date writeOffDate = new Date();
                for (FscOrderWriteBO fscOrderWriteBO : chooseWriteList) {
                    BigDecimal noWriteOffAmount = fscOrderWriteBO.getOrderAmount().subtract(fscOrderWriteBO.getWritedOffAmount());
                    ArrayList<FscOrderWriteDetailBO> writeDetailList = new ArrayList<FscOrderWriteDetailBO>();
                    for (FscClaimDetailBO fscClaimDetailBO : fscClaimDetailPOList) {
                        if (noWriteOffAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                        BigDecimal remainingWriteAmt = fscClaimDetailBO.getRemainingWriteAmt();
                        if (remainingWriteAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                        BigDecimal thisAmount = noWriteOffAmount.compareTo(remainingWriteAmt) > 0 ? remainingWriteAmt : noWriteOffAmount;
                        noWriteOffAmount = noWriteOffAmount.subtract(thisAmount);
                        remainingWriteAmt = remainingWriteAmt.subtract(thisAmount);
                        fscClaimDetailBO.setRemainingWriteAmt(remainingWriteAmt);
                        if (fscOrderWriteBO.getThisAmount() == null) {
                            fscOrderWriteBO.setThisAmount(thisAmount);
                        } else {
                            fscOrderWriteBO.setThisAmount(fscOrderWriteBO.getThisAmount().add(thisAmount));
                        }
                        FscOrderWriteDetailBO fscOrderWriteDetailBO = new FscOrderWriteDetailBO();
                        fscOrderWriteDetailBO.setClaimDetailId(fscClaimDetailBO.getClaimDetailId());
                        fscOrderWriteDetailBO.setThisAmount(thisAmount);
                        fscOrderWriteDetailBO.setRemainingWriteAmt(remainingWriteAmt);
                        fscClaimDetailBO.setThisAmount(fscClaimDetailBO.getThisAmount().add(thisAmount));
                        writeDetailList.add(fscOrderWriteDetailBO);
                    }
                    fscOrderWriteBO.setWriteDetailList(writeDetailList);
                    if (CollectionUtils.isEmpty(writeDetailList)) continue;
                    fscOrderWriteBO.setWritedOffAmount(fscOrderWriteBO.getWritedOffAmount().add(fscOrderWriteBO.getThisAmount()));
                    fscOrderWriteBO.setWriteOffAmount(noWriteOffAmount);
                    fscOrderWriteBO.setRemainingAmount(noWriteOffAmount);
                    fscOrderWriteBO.setFscWriteOffAmount(fscOrderWriteBO.getFscWriteOffAmount().add(fscOrderWriteBO.getThisAmount()));
                    fscOrderWriteBO.setWriteOffDate(writeOffDate);
                    writeBOMap.put(fscOrderWriteBO.getFscOrderId().toString() + fscOrderWriteBO.getOrderId(), fscOrderWriteBO);
                }
                claimWriteList.addAll(fscClaimDetailPOList);
                continue;
            }
            throw new FscBusinessException("190000", "\u67e5\u8be2\u53ef\u6838\u9500\u8ba4\u9886\u660e\u7ec6\u4e3a\u7a7a");
        }
        rspBO.setClaimWriteList(claimWriteList);
        writeList = new ArrayList(writeBOMap.values());
        writeList = writeList.stream().sorted(Comparator.comparing(FscOrderWriteBO::getOrderTime)).collect(Collectors.toList());
        rspBO.setWriteList(writeList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

