/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.common.ability.api.FscPayClaimDetailsImportAbilityService;
import com.tydic.fsc.common.ability.api.FscRefundClaimListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscRefundPayClaimListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayClaimDetailsImportAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayClaimDetailsImportAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRefundClaimListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRefundClaimListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRefundPayClaimListQryAbilityReqBO;
import com.tydic.fsc.dao.FscPayClaimMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPayClaimPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.ExcelUtils;
import com.tydic.fsc.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayClaimDetailsImportAbilityService"})
public class FscPayClaimDetailsImportAbilityServiceImpl
implements FscPayClaimDetailsImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayClaimDetailsImportAbilityServiceImpl.class);
    private static final String NULL_STR = "null";
    private static final String IMPORT_TYPE_ONE = "1";
    private static final String IMPORT_TYPE_TWO = "2";
    @Autowired
    private FscRefundPayClaimListQryAbilityService fscRefundPayClaimListQryAbilityService;
    @Autowired
    private FscRefundClaimListQryAbilityService fscRefundClaimListQryAbilityService;
    @Value(value="${allowImportRowNum:200}")
    private Integer allowImportRowNum;
    @Autowired
    private FscPayClaimMapper fscPayClaimMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;

    @PostMapping(value={"dealCreateImport"})
    public FscPayClaimDetailsImportAbilityRspBO dealCreateImport(@RequestBody FscPayClaimDetailsImportAbilityReqBO reqBO) {
        List excelData;
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba4\u9886\u5355id[claimId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal noClaimAmt = BigDecimal.ZERO;
        if ("0".equals(reqBO.getIsprofess())) {
            FscRecvClaimPO fscRecvClaimPO = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
            if (fscRecvClaimPO == null) {
                throw new FscBusinessException("191025", "\u8ba4\u9886\u5355\u67e5\u8be2\u5931\u8d25");
            }
            noClaimAmt = fscRecvClaimPO.getNoClaimAmt() != null ? fscRecvClaimPO.getNoClaimAmt() : BigDecimal.ZERO;
        } else {
            FscPayClaimPO fscPayClaimPO = new FscPayClaimPO();
            fscPayClaimPO.setClaimId(reqBO.getClaimId());
            FscPayClaimPO payClaimPO = this.fscPayClaimMapper.getModelBy(fscPayClaimPO);
            if (payClaimPO == null) {
                throw new FscBusinessException("191025", "\u8ba4\u9886\u5355\u67e5\u8be2\u5931\u8d25");
            }
            noClaimAmt = payClaimPO.getNoClaimAmt() != null ? payClaimPO.getNoClaimAmt() : BigDecimal.ZERO;
        }
        FscPayClaimDetailsImportAbilityRspBO rspBO = new FscPayClaimDetailsImportAbilityRspBO();
        this.verification(reqBO);
        File file = FileUtils.getExcelFileByUrl((String)reqBO.getFileUrl());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile("excel" + file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            excelData = ExcelUtils.getExcelData((MultipartFile)multipartFile, (Integer)1);
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u7684\u8ba4\u9886\u660e\u7ec6excel\u6570\u636e:{}", (Object)JSON.toJSONString((Object)excelData));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8ba4\u9886\u660e\u7ec6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new FscBusinessException("191025", "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)excelData)) {
            throw new FscBusinessException("191025", "\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        int size = excelData.size();
        if (size > this.allowImportRowNum) {
            throw new FscBusinessException("191025", "\u6700\u5927\u5141\u8bb8\u5bfc\u5165" + this.allowImportRowNum + "\u884c");
        }
        log.info("\u5bfc\u5165\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)excelData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        ArrayList<FscClaimDetailBO> fscClaimDetailBOList = new ArrayList<FscClaimDetailBO>();
        ArrayList<String> errorInfo = new ArrayList<String>();
        Date claimDate = new Date();
        if (IMPORT_TYPE_ONE.equals(reqBO.getImportType())) {
            Map fscClaimDetailBOMap;
            FscRefundClaimListQryAbilityRspBO abilityRspBO;
            FscRefundClaimListQryAbilityReqBO abilityReqBO;
            ArrayList objNoList = new ArrayList(size);
            for (int j = 0; j < size; ++j) {
                List excelDatum = (List)excelData.get(j);
                if (!StringUtils.isEmpty(excelDatum.get(15)) && !NULL_STR.equals(excelDatum.get(15))) {
                    objNoList.add(excelDatum.get(15));
                    continue;
                }
                errorInfo.add("\u7b2c" + (j + 1) + "\u884c\uff0c\u7b2c16\u5217\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List objIdList = JSON.parseArray((String)JSON.toJSONString(objNoList), Long.class);
            if ("0".equals(reqBO.getIsprofess())) {
                abilityReqBO = (FscRefundClaimListQryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscRefundClaimListQryAbilityReqBO.class);
                abilityReqBO.setRefundSourceIdList(objIdList);
                abilityReqBO.setPageNo(Integer.valueOf(-1));
                abilityReqBO.setPageSize(Integer.valueOf(-1));
                abilityReqBO.setTabId("1001");
                abilityRspBO = this.fscRefundClaimListQryAbilityService.qryRefundClaimList(abilityReqBO);
                fscClaimDetailBOMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(FscClaimDetailBO::getRefundSourceId, Function.identity()));
            } else {
                abilityReqBO = (FscRefundPayClaimListQryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscRefundPayClaimListQryAbilityReqBO.class);
                abilityReqBO.setRefundSourceIdList(objIdList);
                abilityReqBO.setPageNo(Integer.valueOf(-1));
                abilityReqBO.setPageSize(Integer.valueOf(-1));
                abilityReqBO.setTabId("1001");
                abilityRspBO = this.fscRefundPayClaimListQryAbilityService.qryRefundPayClaimList((FscRefundPayClaimListQryAbilityReqBO)abilityReqBO);
                fscClaimDetailBOMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(FscClaimDetailBO::getRefundSourceId, Function.identity()));
            }
            log.debug("\u6279\u91cf\u67e5\u8be2\u7cfb\u7edf\u9000\u6b3e\u8ba4\u9886\u5355map: {}", (Object)JSON.toJSONString(fscClaimDetailBOMap));
            for (int i = 0; i < size; ++i) {
                List excelDatum = (List)excelData.get(i);
                FscClaimDetailBO claimDetailBO = null;
                FscClaimDetailBO fscClaimDetailBO = new FscClaimDetailBO();
                if (!StringUtils.isEmpty(excelDatum.get(15)) && !NULL_STR.equals(excelDatum.get(15))) {
                    Long refundSourceId;
                    try {
                        refundSourceId = Long.valueOf((String)excelDatum.get(15));
                        fscClaimDetailBO.setRefundSourceId(refundSourceId);
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c15\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                    claimDetailBO = (FscClaimDetailBO)fscClaimDetailBOMap.get(refundSourceId);
                    if (claimDetailBO == null) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u672a\u67e5\u8be2\u5230\u7cfb\u7edf\u6570\u636e");
                        continue;
                    }
                }
                if (excelDatum.size() < 17) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u4e0d\u5b8c\u6574");
                    continue;
                }
                fscClaimDetailBO.setHandleUserName((String)excelDatum.get(1));
                fscClaimDetailBO.setHandleDeptName((String)excelDatum.get(2));
                fscClaimDetailBO.setClaimTypeStr((String)excelDatum.get(3));
                fscClaimDetailBO.setObjectNo((String)excelDatum.get(4));
                fscClaimDetailBO.setFscOrderNo((String)excelDatum.get(5));
                fscClaimDetailBO.setOrderCode((String)excelDatum.get(6));
                fscClaimDetailBO.setBillDate((String)excelDatum.get(7));
                if (!StringUtils.isEmpty(excelDatum.get(8)) && !NULL_STR.equals(excelDatum.get(8))) {
                    fscClaimDetailBO.setPayOrderNo((String)excelDatum.get(8));
                }
                if (!StringUtils.isEmpty(excelDatum.get(9)) && !NULL_STR.equals(excelDatum.get(9))) {
                    try {
                        fscClaimDetailBO.setAmount(new BigDecimal((String)excelDatum.get(9)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c10\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                if (!StringUtils.isEmpty(excelDatum.get(11)) && !NULL_STR.equals(excelDatum.get(11))) {
                    try {
                        fscClaimDetailBO.setClaimAmt(new BigDecimal((String)excelDatum.get(11)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c12\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                if (fscClaimDetailBO.getClaimAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u4e3a\u96f6");
                    continue;
                }
                if (claimDetailBO.getLeaveRefundAmt().compareTo(fscClaimDetailBO.getClaimAmt()) < 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u8d85\u8fc7\u5269\u4f59\u53ef\u8ba4\u9886\u91d1\u989d");
                    continue;
                }
                if (noClaimAmt.compareTo(fscClaimDetailBO.getClaimAmt()) < 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u8d85\u8fc7\u8ba4\u9886\u5355\u5269\u4f59\u53ef\u8ba4\u9886\u91d1\u989d");
                    continue;
                }
                BigDecimal leaveRefundAmt = claimDetailBO.getLeaveRefundAmt().subtract(fscClaimDetailBO.getClaimAmt());
                fscClaimDetailBO.setLeaveRefundAmt(leaveRefundAmt);
                fscClaimDetailBO.setClaimDate(claimDate);
                fscClaimDetailBO.setSysSource(Integer.valueOf(1));
                fscClaimDetailBO.setRefundSourceType(claimDetailBO.getRefundSourceType());
                noClaimAmt = noClaimAmt.subtract(fscClaimDetailBO.getClaimAmt());
                fscClaimDetailBOList.add(fscClaimDetailBO);
            }
            rspBO.setRows(fscClaimDetailBOList);
        } else {
            Map fscClaimDetailBOMap;
            FscRefundClaimListQryAbilityRspBO abilityRspBO;
            FscRefundClaimListQryAbilityReqBO abilityReqBO;
            ArrayList objNoList = new ArrayList(size);
            for (int j = 0; j < size; ++j) {
                List excelDatum = (List)excelData.get(j);
                if (!StringUtils.isEmpty(excelDatum.get(14)) && !NULL_STR.equals(excelDatum.get(14))) {
                    objNoList.add(excelDatum.get(14));
                    continue;
                }
                errorInfo.add("\u7b2c" + (j + 1) + "\u884c\uff0c\u7b2c15\u5217\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List objIdList = JSON.parseArray((String)JSON.toJSONString(objNoList), Long.class);
            if ("0".equals(reqBO.getIsprofess())) {
                abilityReqBO = (FscRefundClaimListQryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscRefundClaimListQryAbilityReqBO.class);
                abilityReqBO.setRefundSourceIdList(objIdList);
                abilityReqBO.setPageNo(Integer.valueOf(-1));
                abilityReqBO.setPageSize(Integer.valueOf(-1));
                abilityReqBO.setTabId("1002");
                abilityRspBO = this.fscRefundClaimListQryAbilityService.qryRefundClaimList(abilityReqBO);
                fscClaimDetailBOMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(FscClaimDetailBO::getRefundSourceId, Function.identity()));
            } else {
                abilityReqBO = (FscRefundPayClaimListQryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscRefundPayClaimListQryAbilityReqBO.class);
                abilityReqBO.setRefundSourceIdList(objIdList);
                abilityReqBO.setPageNo(Integer.valueOf(-1));
                abilityReqBO.setPageSize(Integer.valueOf(-1));
                abilityReqBO.setTabId("1002");
                abilityRspBO = this.fscRefundPayClaimListQryAbilityService.qryRefundPayClaimList((FscRefundPayClaimListQryAbilityReqBO)abilityReqBO);
                fscClaimDetailBOMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(FscClaimDetailBO::getRefundSourceId, Function.identity()));
            }
            log.debug("\u6279\u91cf\u67e5\u8be2\u7cfb\u7edf\u9000\u6b3e\u8ba4\u9886\u5355map: {}", (Object)JSON.toJSONString(fscClaimDetailBOMap));
            for (int i = 0; i < size; ++i) {
                List excelDatum = (List)excelData.get(i);
                FscClaimDetailBO claimDetailBO = null;
                FscClaimDetailBO fscClaimDetailBO = new FscClaimDetailBO();
                if (!StringUtils.isEmpty(excelDatum.get(14)) && !NULL_STR.equals(excelDatum.get(14))) {
                    Long refundSourceId;
                    try {
                        refundSourceId = Long.valueOf((String)excelDatum.get(14));
                        fscClaimDetailBO.setRefundSourceId(refundSourceId);
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c15\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                    claimDetailBO = (FscClaimDetailBO)fscClaimDetailBOMap.get(refundSourceId);
                    if (claimDetailBO == null) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u672a\u67e5\u8be2\u5230\u7cfb\u7edf\u6570\u636e");
                        continue;
                    }
                }
                if (excelDatum.size() < 16) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u4e0d\u5b8c\u6574");
                    continue;
                }
                fscClaimDetailBO.setHandleUserName((String)excelDatum.get(1));
                fscClaimDetailBO.setHandleDeptName((String)excelDatum.get(2));
                fscClaimDetailBO.setClaimTypeStr((String)excelDatum.get(3));
                if (!StringUtils.isEmpty(excelDatum.get(4)) && !NULL_STR.equals(excelDatum.get(4))) {
                    fscClaimDetailBO.setPayOrderNo((String)excelDatum.get(4));
                }
                fscClaimDetailBO.setOrderCode((String)excelDatum.get(5));
                fscClaimDetailBO.setBuyerName((String)excelDatum.get(6));
                if (!StringUtils.isEmpty(excelDatum.get(7)) && !NULL_STR.equals(excelDatum.get(7))) {
                    try {
                        fscClaimDetailBO.setAmount(new BigDecimal((String)excelDatum.get(7)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c8\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                if (!StringUtils.isEmpty(excelDatum.get(9)) && !NULL_STR.equals(excelDatum.get(9))) {
                    try {
                        fscClaimDetailBO.setClaimAmt(new BigDecimal((String)excelDatum.get(9)));
                    }
                    catch (Exception e) {
                        errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c10\u5217\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                        continue;
                    }
                }
                if (fscClaimDetailBO.getClaimAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u4e3a\u96f6");
                    continue;
                }
                if (claimDetailBO.getLeaveRefundAmt().compareTo(fscClaimDetailBO.getClaimAmt()) < 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u8d85\u8fc7\u5269\u4f59\u53ef\u8ba4\u9886\u91d1\u989d");
                    continue;
                }
                if (noClaimAmt.compareTo(fscClaimDetailBO.getClaimAmt()) < 0) {
                    errorInfo.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8ba4\u9886\u91d1\u989d\u8d85\u8fc7\u8ba4\u9886\u5355\u5269\u4f59\u53ef\u8ba4\u9886\u91d1\u989d");
                    continue;
                }
                BigDecimal leaveRefundAmt = claimDetailBO.getLeaveRefundAmt().subtract(fscClaimDetailBO.getClaimAmt());
                fscClaimDetailBO.setLeaveRefundAmt(leaveRefundAmt);
                fscClaimDetailBO.setPayerName((String)excelDatum.get(10));
                fscClaimDetailBO.setClaimDate(claimDate);
                fscClaimDetailBO.setSysSource(Integer.valueOf(1));
                fscClaimDetailBO.setRefundSourceType(claimDetailBO.getRefundSourceType());
                noClaimAmt = noClaimAmt.subtract(fscClaimDetailBO.getClaimAmt());
                fscClaimDetailBOList.add(fscClaimDetailBO);
            }
            rspBO.setRows(fscClaimDetailBOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setErrorInfo(errorInfo);
        return rspBO;
    }

    private void verification(FscPayClaimDetailsImportAbilityReqBO reqBO) {
        if (null == reqBO.getFileUrl() || "".equals(reqBO.getFileUrl())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fileUrl]\u4e3a\u7a7a");
        }
    }
}

