/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscBillGetYcPersonInfoAbilityService;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscGetStateListOfConfTabAbilityService;
import com.tydic.fsc.common.ability.api.FscPayClaimInfoListPageAbilityService;
import com.tydic.fsc.common.ability.bo.FscGetStateListOfConfTabAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscGetStateListOfConfTabAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscGetStateListOfConfTabBO;
import com.tydic.fsc.common.ability.bo.FscPayClaimDetailBO;
import com.tydic.fsc.common.ability.bo.FscPayClaimInfoListPageAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayClaimInfoListPageAbilityRspBO;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.po.FscClaimDetailInfoPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscPayClaimDetailPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcBuyerCustomerQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcBuyerCustomerQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcBuyerCustomerQueryAbilityRspBO;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayClaimInfoListPageAbilityService"})
public class FscPayClaimInfoListPageAbilityServiceImpl
implements FscPayClaimInfoListPageAbilityService {
    @Autowired
    private FscGetStateListOfConfTabAbilityService fscGetStateListOfConfTabAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private UmcBuyerCustomerQueryAbilityService umcBuyerCustomerQueryAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscBillGetYcPersonInfoAbilityService fscBillGetYcPersonInfoAbilityService;
    private static final Integer CONSTANT_NUM_ONE = 1;
    private static final Integer CONSTANT_NUM_TWO = 2;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    private final String INSP_TOTAL_SALE_MONEY = "inspTotalSaleMoney";

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryClaimInfoList"})
    public FscPayClaimInfoListPageAbilityRspBO qryClaimInfoList(@RequestBody FscPayClaimInfoListPageAbilityReqBO reqBO) {
        AbstractList claimDetailList;
        FscPayClaimInfoListPageAbilityRspBO rspBO = new FscPayClaimInfoListPageAbilityRspBO();
        FscPayClaimDetailPO queryVo = (FscPayClaimDetailPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscPayClaimDetailPO.class);
        ArrayList<FscGetStateListOfConfTabBO> confTabBOList = new ArrayList<FscGetStateListOfConfTabBO>();
        String tabCode = this.dealTab(reqBO, confTabBOList);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (!StringUtils.isEmpty((Object)reqBO.getBuyerNo())) {
            UmcBuyerCustomerQueryAbilityReqBO abilityReqBO = new UmcBuyerCustomerQueryAbilityReqBO();
            abilityReqBO.setCustomerId(Long.valueOf(reqBO.getBuyerNo()));
            UmcBuyerCustomerQueryAbilityRspBO abilityRspBO = this.umcBuyerCustomerQueryAbilityService.queryBuyerCustomer(abilityReqBO);
            if (abilityRspBO.getRespCode().equals("0000") && !StringUtils.isEmpty((Object)abilityRspBO.getBuyerNo())) {
                queryVo.setBuyerNo(abilityRspBO.getBuyerNo());
            } else {
                queryVo.setBuyerNo(reqBO.getBuyerNo());
            }
        }
        queryVo.setClaimId(reqBO.getClaimId());
        if ("1".equals(tabCode)) {
            queryVo.setBuyerNo(null);
            queryVo.setBuyerName(null);
            queryVo.setBuyName(reqBO.getCustomerName());
            queryVo.setOrderCode(reqBO.getOrderCode());
            this.parseSettleClaimType(reqBO.getClaimType(), queryVo);
            List claimPoList = this.fscPayClaimDetailMapper.getSettleClaimListPage(queryVo, page);
            Map<Long, FscOrderInvoicePO> invoicePOMap = null;
            if (!CollectionUtils.isEmpty((Collection)claimPoList)) {
                List fscOrderIds = claimPoList.stream().map(FscPayClaimDetailPO::getFscOrderId).collect(Collectors.toList());
                FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
                fscOrderInvoicePO.setFscOrderIdList(fscOrderIds);
                List invoiceList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO);
                if (!CollectionUtils.isEmpty((Collection)invoiceList)) {
                    invoicePOMap = invoiceList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, e -> e, (k1, k2) -> k1));
                }
            }
            ArrayList detailBoList = new ArrayList(claimPoList.size());
            for (FscPayClaimDetailPO fscClaimDetail : claimPoList) {
                FscPayClaimDetailBO fscClaimDetailBo = new FscPayClaimDetailBO();
                BeanUtils.copyProperties((Object)fscClaimDetail, (Object)fscClaimDetailBo);
                fscClaimDetailBo.setNoClaimAmt(fscClaimDetailBo.getAmount().subtract(fscClaimDetail.getTotalClaimAmt()));
                this.transformSettleClaimType(fscClaimDetail.getOrderSource(), fscClaimDetail.getOrderType(), fscClaimDetailBo);
                fscClaimDetailBo.setHandleUserName(reqBO.getName());
                fscClaimDetailBo.setHandleDeptName(reqBO.getOrgName());
                fscClaimDetailBo.setHandleUserId(reqBO.getUserId());
                fscClaimDetailBo.setHandleDeptId(reqBO.getOrgId());
                fscClaimDetailBo.setPersonNum(reqBO.getUserId());
                fscClaimDetailBo.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)fscClaimDetail.getSysSource()));
                if (!CollectionUtils.isEmpty(invoicePOMap)) {
                    fscClaimDetailBo.setBillTime(invoicePOMap.get(fscClaimDetail.getFscOrderId()).getBillTime());
                }
                detailBoList.add(fscClaimDetailBo);
            }
            BigDecimal noClaimAmt = this.fscOrderItemMapper.queryPayNoClaimAmountSum((FscClaimDetailInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)queryVo), FscClaimDetailInfoPO.class));
            HashMap<String, BigDecimal> sumFieldInfo = new HashMap<String, BigDecimal>(1);
            sumFieldInfo.put("inspTotalSaleMoney", noClaimAmt);
            rspBO.setSumFieldInfo(sumFieldInfo);
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRows((List)detailBoList);
        } else if ("2".equals(tabCode)) {
            if (StringUtils.isEmpty((Object)reqBO.getBuyerName())) {
                queryVo.setBuyerName(reqBO.getCustomerName());
            }
            this.parseAdvanceClaimType(reqBO.getClaimType(), queryVo);
            List fscClaimDetailPOList = this.fscPayClaimDetailMapper.getAdvanceClaimListPage(queryVo, page);
            claimDetailList = new LinkedList();
            for (FscPayClaimDetailPO row : fscClaimDetailPOList) {
                FscPayClaimDetailBO fscClaimDetailBO = new FscPayClaimDetailBO();
                fscClaimDetailBO = (FscPayClaimDetailBO)JSON.parseObject((String)JSONObject.toJSONString((Object)row), FscPayClaimDetailBO.class);
                this.transformAdviceClaimType(row.getOrderType(), fscClaimDetailBO, row.getShouldPayType());
                fscClaimDetailBO.setHandleUserName(reqBO.getName());
                fscClaimDetailBO.setHandleDeptName(reqBO.getOrgName());
                fscClaimDetailBO.setHandleUserId(reqBO.getUserId());
                fscClaimDetailBO.setHandleDeptId(reqBO.getOrgId());
                fscClaimDetailBO.setPersonNum(reqBO.getUserId());
                fscClaimDetailBO.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)fscClaimDetailBO.getSysSource()));
                claimDetailList.add(fscClaimDetailBO);
            }
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRows(claimDetailList);
            HashMap<String, BigDecimal> sumFieldInfo = new HashMap<String, BigDecimal>();
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO = (FscShouldPayPO)JSON.parseObject((String)JSONObject.toJSONString((Object)queryVo), FscShouldPayPO.class);
            sumFieldInfo.put("inspTotalSaleMoney", this.fscShouldPayMapper.qryPayShouldPayAmount(fscShouldPayPO));
            rspBO.setSumFieldInfo(sumFieldInfo);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getClaimDetailIds()) && ObjectUtil.isNotEmpty((Object)rspBO.getRows())) {
            Map<Long, FscPayClaimDetailBO> fscClaimDetailMap = rspBO.getRows().stream().collect(Collectors.toMap(FscPayClaimDetailBO::getClaimDetailId, e -> e));
            claimDetailList = new ArrayList();
            for (Long detailId : reqBO.getClaimDetailIds()) {
                if (!ObjectUtil.isNotEmpty((Object)fscClaimDetailMap.get(detailId))) continue;
                claimDetailList.add(fscClaimDetailMap.get(detailId));
            }
            rspBO.setRows(claimDetailList);
        }
        return rspBO;
    }

    private void parseAdvanceClaimType(String claimType, FscPayClaimDetailPO queryVo) {
        if (StringUtils.isEmpty((Object)claimType)) {
            Map typeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_PAY_TYPE_STATE");
            queryVo.setClaimTypeList(typeMap.keySet());
        } else {
            queryVo.setClaimTypeList(Collections.singleton(claimType));
        }
        if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode())) {
            queryVo.setOrderType(Integer.valueOf(5));
        } else if (claimType.equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode())) {
            queryVo.setOrderType(Integer.valueOf(0));
        } else if (claimType.equals(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode())) {
            queryVo.setOrderType(Integer.valueOf(2));
        } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCode())) {
            queryVo.setOrderType(Integer.valueOf(4));
        } else if (claimType.equals(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode())) {
            queryVo.setShouldPayType(Integer.valueOf(14));
        }
    }

    private void transformAdviceClaimType(Integer orderType, FscPayClaimDetailBO fscClaimDetailBO, Integer shouldPayType) {
        if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getSysSource()) && fscClaimDetailBO.getSysSource() == 2 && !StringUtils.isEmpty((Object)orderType)) {
            fscClaimDetailBO.setClaimType(orderType.toString());
            fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)orderType.toString()));
        }
        if (shouldPayType != null && shouldPayType == 14) {
            fscClaimDetailBO.setClaimType(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode());
            fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.MEM_FEE_CLAIM.getCodeDesc());
        }
        if (orderType != null) {
            if (orderType.equals(FscOrderTypeEnum.ELECTRONIC.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.AGREEMENT.getCode()) || orderType.equals(FscOrderTypeEnum.GOODS.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.INDIVIDUALLY.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCodeDesc());
            }
        }
    }

    private void parseSettleClaimType(String claimType, FscPayClaimDetailPO queryVo) {
        Map typeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_SETTLE_TYPE_STATE");
        queryVo.setClaimTypeList(typeMap.keySet());
        if (StringUtils.isEmpty((Object)claimType)) {
            queryVo.setOrderSource(null);
            queryVo.setOrderType(null);
        } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCode())) {
            queryVo.setOrderType(FscOrderTypeEnum.INDIVIDUALLY.getCode());
            queryVo.setOrderSource(null);
        } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode()) || claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode())) {
            queryVo.setOrderType(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode());
            queryVo.setOrderSource(null);
        } else if (claimType.equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode())) {
            queryVo.setOrderType(null);
            queryVo.setOrderSource(FscOrderSourceEnum.ELECTRIC_MARKET.getCode());
        } else if (claimType.equals(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode())) {
            queryVo.setOrderType(null);
            queryVo.setOrderSource(FscOrderSourceEnum.ELECTRIC_AREA.getCode());
        } else {
            queryVo.setOrderType(Integer.valueOf(-1));
            queryVo.setOrderSource(Integer.valueOf(-1));
        }
    }

    private void transformSettleClaimType(Integer orderSource, Integer orderType, FscPayClaimDetailBO fscClaimDetailBo) {
        if (!StringUtils.isEmpty((Object)fscClaimDetailBo.getSysSource()) && fscClaimDetailBo.getSysSource() == 2) {
            if (!StringUtils.isEmpty((Object)orderType)) {
                fscClaimDetailBo.setClaimType(orderType.toString());
                fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)orderType.toString()));
            }
        } else if (orderType != null && orderType.equals(FscOrderTypeEnum.INDIVIDUALLY.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCode());
        } else if (orderType != null && orderType.equals(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode());
        } else if (orderSource.equals(FscOrderSourceEnum.ELECTRIC_AREA.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode());
        } else if (orderSource.equals(FscOrderSourceEnum.ELECTRIC_MARKET.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode());
        }
    }

    private void dealClaimType(Integer orderType, Integer payType, FscClaimDetailBO fscClaimDetailBO) {
        if (CONSTANT_NUM_ONE.equals(orderType) && CONSTANT_NUM_ONE.equals(payType)) {
            fscClaimDetailBO.setClaimType(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCodeDesc());
        } else if (CONSTANT_NUM_ONE.equals(orderType) && CONSTANT_NUM_TWO.equals(payType)) {
            fscClaimDetailBO.setClaimType(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCodeDesc());
        } else if (CONSTANT_NUM_TWO.equals(orderType) && CONSTANT_NUM_ONE.equals(payType)) {
            fscClaimDetailBO.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCodeDesc());
        } else {
            fscClaimDetailBO.setClaimType("");
        }
    }

    private String dealTab(FscPayClaimInfoListPageAbilityReqBO reqBO, List<FscGetStateListOfConfTabBO> confTabBOList) {
        if (reqBO.getTabIds() != null && reqBO.getTabIds().size() > 0) {
            FscGetStateListOfConfTabAbilityReqBO tabAbilityReqBO = new FscGetStateListOfConfTabAbilityReqBO();
            tabAbilityReqBO.setTabIds(reqBO.getTabIds());
            FscGetStateListOfConfTabAbilityRspBO tabAbilityRspBO = this.fscGetStateListOfConfTabAbilityService.getStateList(tabAbilityReqBO);
            if ("0000".equals(tabAbilityRspBO.getRespCode())) {
                List tabBOList = tabAbilityRspBO.getConfTabStateBOList();
                for (FscGetStateListOfConfTabBO tabBO : tabBOList) {
                    confTabBOList.add(tabBO);
                    if (!tabBO.getTabId().equals(reqBO.getTabId()) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tabBO.getStatusCode())) continue;
                    return tabBO.getStatusCode();
                }
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u9875\u7b7e\u670d\u52a1\u5931\u8d25");
            }
        }
        return "1";
    }
}

