/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscPushMemPayFeeAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushMemPayFeeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushMemPayFeeAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscPushMemPayFeeBusiService;
import com.tydic.fsc.common.busi.bo.FscPushMemPayFeeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushMemPayFeeBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushMemPayFeeAbilityService"})
public class FscPushMemPayFeeAbilityServiceImpl
implements FscPushMemPayFeeAbilityService {
    @Autowired
    private FscPushMemPayFeeBusiService fscPushMemPayFeeBusiService;

    @PostMapping(value={"dealFscPushMemFee"})
    public FscPushMemPayFeeAbilityRspBO dealFscPushMemFee(@RequestBody FscPushMemPayFeeAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscPushMemPayFeeBusiReqBO busiReqBO = (FscPushMemPayFeeBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscPushMemPayFeeBusiReqBO.class));
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            busiReqBO.setFscOrderId(fscOrderId);
            FscPushMemPayFeeBusiRspBO busiRspBO = this.fscPushMemPayFeeBusiService.dealFscPushMemFee(busiReqBO);
            if (busiRspBO.getRespCode().equals("0000")) continue;
            sb.append("[").append(fscOrderId).append("]\u4f1a\u5458\u8d39\u63a8\u9001\u5931\u8d25\uff01").append(busiRspBO.getRespDesc());
        }
        FscPushMemPayFeeAbilityRspBO rspBO = new FscPushMemPayFeeAbilityRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private void valid(FscPushMemPayFeeAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4ed8\u6b3e\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

