/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyInvoiceBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyInvoiceBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyInvoiceBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscUnifyAttachmentBO;
import com.tydic.fsc.common.ability.bo.FscUnifySettleBO;
import com.tydic.fsc.common.ability.bo.FscUnifySettleInvoiceBO;
import com.tydic.fsc.common.ability.bo.FscUnifySettleItemBO;
import com.tydic.fsc.common.ability.bo.FscUnifySettleMaterialBO;
import com.tydic.fsc.common.ability.bo.FscUnifySettleWriteOffBO;
import com.tydic.fsc.common.busi.api.FscPushUnifyFailBusiService;
import com.tydic.fsc.common.busi.api.FscPushUnifyInvoiceBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyFailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyInvoiceBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyInvoiceBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderItemRhRelationMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscPurWriteOffMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderItemRhRelationPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscPurWriteOffPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.PebUocUnifyContractQryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushUnifyInvoiceBillAbilityService"})
public class FscPushUnifyInvoiceBillAbilityServiceImpl
implements FscPushUnifyInvoiceBillAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushUnifyInvoiceBillAbilityServiceImpl.class);
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Autowired
    private PebUocUnifyContractQryAbilityService pebUocUnifyContractQryAbilityService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscPurWriteOffMapper fscPurWriteOffMapper;
    @Autowired
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscOrderItemRhRelationMapper fscOrderItemRhRelationMapper;
    @Autowired
    private FscPushUnifyInvoiceBillBusiService fscPushUnifyInvoiceBillBusiService;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscPushUnifyFailBusiService fscPushUnifyFailBusiService;
    @Value(value="${UNIFY_PAY_TERMS:16}")
    private String payTerms;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Value(value="${UNIFY_EXP_TYPE:\u8bbe\u5907\u91c7\u8d2d}")
    private String expType;
    @Value(value="${UNIFY_EXP_TYPE_ID:161}")
    private String expTypeId;
    @Value(value="${UNIFY_SHIPMENT_TYPE:STANDARD}")
    private String shipmentType;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyInvoiceBill"})
    public FscPushUnifyInvoiceBillAbilityRspBO dealPushUnifyInvoiceBill(@RequestBody FscPushUnifyInvoiceBillAbilityReqBO reqBO) {
        FscPushUnifyInvoiceBillBusiReqBO pushReqBO;
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getType())) {
            orderPO.setType(reqBO.getType());
        }
        try {
            pushReqBO = this.buildPushDataInfo(reqBO, orderPO);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u7ed3\u7b97\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
            FscPushUnifyFailBusiReqBO failBusiReqBO = new FscPushUnifyFailBusiReqBO();
            failBusiReqBO.setFscOrderId(orderPO.getFscOrderId());
            failBusiReqBO.setFailMsg(e.getMessage());
            failBusiReqBO.setPushType(FscConstants.FscPurchasePushType.SETTLE);
            this.fscPushUnifyFailBusiService.dealPushUnifyFail(failBusiReqBO);
            this.sendMq(reqBO.getFscOrderId());
            FscPushUnifyInvoiceBillAbilityRspBO rspBO = new FscPushUnifyInvoiceBillAbilityRspBO();
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        FscPushUnifyInvoiceBillBusiRspBO pushRspBO = this.fscPushUnifyInvoiceBillBusiService.dealPushUnifyInvoiceBill(pushReqBO);
        this.sendMq(reqBO.getFscOrderId());
        return (FscPushUnifyInvoiceBillAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)pushRspBO)), FscPushUnifyInvoiceBillAbilityRspBO.class);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyInvoiceBatch"})
    public FscPushUnifyInvoiceBillAbilityRspBO dealPushUnifyInvoiceBatch(@RequestBody FscPushUnifyInvoiceBillAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355id\u96c6\u5408[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscPushUnifyInvoiceBillAbilityReqBO billAbilityReqBO = new FscPushUnifyInvoiceBillAbilityReqBO();
            billAbilityReqBO.setFscOrderId(fscOrderId);
            FscPushUnifyInvoiceBillAbilityRspBO rspBO = this.dealPushUnifyInvoiceBill(billAbilityReqBO);
            if (rspBO.getRespCode().equals("0000")) continue;
            sb.append("\u7ed3\u7b97\u5355[").append(fscOrderId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(rspBO.getRespDesc());
        }
        FscPushUnifyInvoiceBillAbilityRspBO rspBO = new FscPushUnifyInvoiceBillAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPushUnifyInvoiceBillBusiReqBO buildPushDataInfo(FscPushUnifyInvoiceBillAbilityReqBO reqBO, FscOrderPO orderPO) {
        Boolean invoiceTypeFlag = false;
        if (FscConstants.SettlePlatform.YES_Y.equals(orderPO.getSettlePlatform())) {
            FscOrderInvoicePO invoicePo = new FscOrderInvoicePO();
            invoicePo.setFscOrderId(reqBO.getFscOrderId());
            invoicePo = this.fscOrderInvoiceMapper.getModelBy(invoicePo);
            invoiceTypeFlag = "01".equals(invoicePo.getInvoiceType());
        }
        FscPushUnifyInvoiceBillBusiReqBO pushReqBO = new FscPushUnifyInvoiceBillBusiReqBO();
        FscUnifySettleBO settleBO = new FscUnifySettleBO();
        this.buildSettleInfo(orderPO, settleBO);
        ArrayList<FscUnifySettleItemBO> settleItemBOList = new ArrayList<FscUnifySettleItemBO>();
        ArrayList<FscUnifySettleWriteOffBO> writeOffBOList = new ArrayList<FscUnifySettleWriteOffBO>();
        this.buildSettleItemInfo(orderPO, settleBO, settleItemBOList, writeOffBOList, invoiceTypeFlag);
        List<FscUnifySettleInvoiceBO> invoiceBoList = this.buildInvoiceInfo(orderPO, settleBO, invoiceTypeFlag);
        ArrayList<FscUnifyAttachmentBO> attachmentBOList = new ArrayList<FscUnifyAttachmentBO>();
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setFscOrderId(orderPO.getFscOrderId());
        List attachmentList = this.fscAttachmentMapper.getList(attachmentPO);
        settleBO.setDOC_COUNT(Integer.valueOf(attachmentList.size()));
        for (FscAttachmentPO fscAttachmentPO : attachmentList) {
            PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            uploadAbilityReqBO.setFileName(fscAttachmentPO.getAttachmentName());
            uploadAbilityReqBO.setFileUrl(fscAttachmentPO.getAttachmentUrl());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(uploadAbilityRspBO.getRespCode(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
            }
            FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
            attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
            attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            attachmentBO.setDOC_FORMAT(fscAttachmentPO.getAttachmentName().substring(fscAttachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            attachmentBO.setEG_BILL_NUM(orderPO.getOrderNo());
            attachmentBO.setUUID("zjht");
            attachmentBO.setDOC_TYPE("8017");
            attachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBO.setUSER_NAME(settleBO.getPERSON_NAME());
            attachmentBO.setUPLOAD_TIME(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBOList.add(attachmentBO);
        }
        pushReqBO.setToken(settleBO.getToken());
        settleBO.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)settleBO);
        jsonObject.put("invline", invoiceBoList);
        jsonObject.put("fileList", attachmentBOList);
        jsonObject.put("linePerpay", writeOffBOList);
        jsonObject.put("conLine", settleItemBOList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setFscOrderId(reqBO.getFscOrderId());
        return pushReqBO;
    }

    private void buildSettleItemInfo(FscOrderPO orderPO, FscUnifySettleBO settleBO, List<FscUnifySettleItemBO> settleItemBOList, List<FscUnifySettleWriteOffBO> writeOffBOList, Boolean invoiceTypeFlag) {
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal unTaxAmt = BigDecimal.ZERO;
        FscOrderItemPO itemPO = new FscOrderItemPO();
        itemPO.setFscOrderId(orderPO.getFscOrderId());
        List orderItemList = this.fscOrderItemMapper.getUnifyList(itemPO);
        FscOrderItemRhRelationPO rhRelationPO = new FscOrderItemRhRelationPO();
        rhRelationPO.setFscOrderId(orderPO.getFscOrderId());
        List rhRelationList = this.fscOrderItemRhRelationMapper.getList(rhRelationPO);
        HashMap rhMap = new HashMap(rhRelationList.size());
        for (FscOrderItemRhRelationPO fscOrderItemRhRelationPO : rhRelationList) {
            FscUnifySettleMaterialBO materialBO = new FscUnifySettleMaterialBO();
            materialBO.setEG_BALANCE_NUM(orderPO.getOrderNo());
            materialBO.setORG_ID(settleBO.getORG_ID());
            materialBO.setORG_NAME(settleBO.getORG_NAME());
            materialBO.setMATCH_AMOUNT(fscOrderItemRhRelationPO.getAmount().setScale(2, RoundingMode.HALF_UP));
            materialBO.setMATCH_NUM(fscOrderItemRhRelationPO.getNum());
            materialBO.setPO_UNIT_PRICE(fscOrderItemRhRelationPO.getPrice().setScale(6, RoundingMode.HALF_UP));
            materialBO.setPO_HEADER_ID(fscOrderItemRhRelationPO.getErpOrderId());
            materialBO.setPO_LINE_ID(fscOrderItemRhRelationPO.getErpLineId());
            materialBO.setRCV_TRANSACTION_ID(fscOrderItemRhRelationPO.getParentTransactionId());
            materialBO.setSHIPMENT_TYPE_DSP(this.shipmentType);
            materialBO.setPO_LINE_LOCATION_ID(fscOrderItemRhRelationPO.getExt1());
            if (rhMap.get(fscOrderItemRhRelationPO.getOrderItemId()) == null) {
                ArrayList<FscUnifySettleMaterialBO> materialList = new ArrayList<FscUnifySettleMaterialBO>();
                materialList.add(materialBO);
                rhMap.put(fscOrderItemRhRelationPO.getOrderItemId(), materialList);
                continue;
            }
            ((List)rhMap.get(fscOrderItemRhRelationPO.getOrderItemId())).add(materialBO);
        }
        HashMap<String, List> materialMap = new HashMap<String, List>();
        HashMap<String, FscOrderItemPO> orderItemPOMap = new HashMap<String, FscOrderItemPO>();
        HashSet<Long> orderIdSet = new HashSet<Long>();
        HashMap<Long, FscOrderRelationPO> contractMap = new HashMap<Long, FscOrderRelationPO>();
        for (FscOrderItemPO fscOrderItemPO : orderItemList) {
            FscOrderRelationPO relationPO;
            taxAmt = taxAmt.add(fscOrderItemPO.getTaxAmt().setScale(2, RoundingMode.HALF_UP));
            unTaxAmt = unTaxAmt.add(fscOrderItemPO.getUntaxAmt().setScale(2, RoundingMode.HALF_UP));
            String key = fscOrderItemPO.getOrderId() + "-" + fscOrderItemPO.getTaxRate().toPlainString();
            if (orderItemPOMap.get(key) == null) {
                orderItemPOMap.put(key, fscOrderItemPO);
            } else {
                FscOrderItemPO orderItemPO = (FscOrderItemPO)orderItemPOMap.get(key);
                orderItemPO.setAmt(orderItemPO.getAmt().add(fscOrderItemPO.getAmt()));
                orderItemPO.setUntaxAmt(orderItemPO.getUntaxAmt().add(fscOrderItemPO.getUntaxAmt()));
                orderItemPO.setTaxAmt(orderItemPO.getTaxAmt().add(fscOrderItemPO.getTaxAmt()));
                orderItemPOMap.put(key, orderItemPO);
            }
            List materialBOS = (List)rhMap.get(fscOrderItemPO.getOrderItemId());
            if (materialMap.get(key) == null) {
                materialMap.put(key, materialBOS);
            } else {
                ((List)materialMap.get(key)).addAll(materialBOS);
            }
            if (contractMap.get(fscOrderItemPO.getContractId()) == null) {
                relationPO = new FscOrderRelationPO();
                relationPO.setContractId(fscOrderItemPO.getContractId());
                relationPO.setContractNo(fscOrderItemPO.getContractNo());
                relationPO.setSettleAmt(fscOrderItemPO.getAmt());
                relationPO.setContractName(fscOrderItemPO.getContractName());
                relationPO.setVrContractNo(fscOrderItemPO.getVrContractNo());
                relationPO.setUnifyContractType(fscOrderItemPO.getUnifyContractType());
                relationPO.setErpOrderId(fscOrderItemPO.getErpOrderId());
                contractMap.put(fscOrderItemPO.getContractId(), relationPO);
            } else {
                relationPO = (FscOrderRelationPO)contractMap.get(fscOrderItemPO.getContractId());
                relationPO.setSettleAmt(relationPO.getSettleAmt().add(fscOrderItemPO.getAmt()));
                contractMap.put(fscOrderItemPO.getContractId(), relationPO);
            }
            orderIdSet.add(fscOrderItemPO.getOrderId());
        }
        ArrayList<Long> orderIdList = new ArrayList<Long>(orderIdSet.size());
        orderIdList.addAll(orderIdSet);
        settleBO.setTAX_AMOUNT(invoiceTypeFlag != false ? BigDecimal.ZERO : taxAmt);
        settleBO.setAMOUNT_NOTAX(invoiceTypeFlag != false ? settleBO.getAMOUNT() : unTaxAmt);
        List invoicedAmtList = this.fscOrderItemMapper.sumOrderAmtByOrderIds(orderIdList);
        Map<Long, BigDecimal> invoicedMap = invoicedAmtList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, FscOrderItemPO::getAmt));
        FscDicDictionaryExernalPO dicExternalPo = new FscDicDictionaryExernalPO();
        dicExternalPo.setPCode("FSC_UNIFY_TAX_RATE_ID");
        List taxIdList = this.fscDicDictionaryExernalMapper.getListByCondition(dicExternalPo);
        Map<String, String> taxIdMap = taxIdList.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
        FscOrderPayDetailPO payDetailPO = new FscOrderPayDetailPO();
        payDetailPO.setOrderIdList(orderIdList);
        List paidAmtList = this.fscOrderPayDetailMapper.getSpecialOrderPaidAmt(payDetailPO);
        Map<Long, BigDecimal> paidAmtMap = paidAmtList.stream().collect(Collectors.toMap(FscOrderPayDetailPO::getOrderId, FscOrderPayDetailPO::getPayAmount));
        UocSalesSingleDetailsListQueryReqBO salesSingleDetailsListQueryReqBO = new UocSalesSingleDetailsListQueryReqBO();
        salesSingleDetailsListQueryReqBO.setOrderId((Long)orderIdList.get(0));
        salesSingleDetailsListQueryReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        salesSingleDetailsListQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        UocSalesSingleDetailsListQueryRspBO salesSingleDetailsListQueryRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(salesSingleDetailsListQueryReqBO);
        if (!salesSingleDetailsListQueryRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(salesSingleDetailsListQueryRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + salesSingleDetailsListQueryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)salesSingleDetailsListQueryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        BigDecimal quality = BigDecimal.ZERO;
        UocPebChildOrderAbilityBO childOrderAbilityBO = (UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)salesSingleDetailsListQueryRspBO.getRows().get(0)).getChildOrderList().get(0);
        if (!CollectionUtils.isEmpty((Collection)childOrderAbilityBO.getPayList())) {
            for (UocPhasePayListBO uocPhasePayListBO : childOrderAbilityBO.getPayList()) {
                if (!uocPhasePayListBO.getPayType().equals(FscPayTypeEnum.WARRANTY.getCode())) continue;
                quality = quality.add(uocPhasePayListBO.getNodePayRatio());
            }
        }
        HashMap<Long, String> orderContractMap = new HashMap<Long, String>();
        for (String key : orderItemPOMap.keySet()) {
            FscOrderItemPO orderItemPO = (FscOrderItemPO)orderItemPOMap.get(key);
            FscUnifySettleItemBO settleItemBO = new FscUnifySettleItemBO();
            FscOrderRelationPO relationPO = (FscOrderRelationPO)contractMap.get(orderItemPO.getContractId());
            if (relationPO == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)relationPO.getContractNo())) {
                settleItemBO.setCONTRACT_NUM(relationPO.getVrContractNo());
                settleItemBO.setEG_CONTRACT_NUM(relationPO.getVrContractNo());
            } else {
                settleItemBO.setCONTRACT_NUM(relationPO.getContractNo());
                settleItemBO.setEG_CONTRACT_NUM(relationPO.getContractNo());
            }
            if (!StringUtils.isEmpty((Object)relationPO.getContractName())) {
                settleItemBO.setCONTRACT_NAME(relationPO.getContractName());
            } else {
                settleItemBO.setCONTRACT_NAME(relationPO.getContractNo());
            }
            orderContractMap.put(orderItemPO.getOrderId(), settleItemBO.getCONTRACT_NUM());
            settleItemBO.setCONTRACT_AMT(relationPO.getSettleAmt());
            BigDecimal totalBal = invoicedMap.get(orderItemPO.getOrderId());
            settleItemBO.setTOTAL_BAL(totalBal == null ? BigDecimal.ZERO : totalBal);
            BigDecimal paidAmt = paidAmtMap.get(orderItemPO.getOrderId());
            settleItemBO.setTOTAL_PAY(paidAmt == null ? BigDecimal.ZERO : paidAmt);
            settleItemBO.setPOORDER_IDS(orderItemPO.getErpOrderId());
            settleItemBO.setPOORDER_NUM(orderItemPO.getUnifyOrderNo());
            settleItemBO.setAMOUNT_INTAX(orderItemPO.getAmt());
            settleItemBO.setTAX_RATE(invoiceTypeFlag != false ? BigDecimal.ZERO : orderItemPO.getTaxRate().multiply(new BigDecimal(100)));
            settleItemBO.setTAX_RATE_ID(taxIdMap.get(orderItemPO.getTaxRate().multiply(new BigDecimal(100)).stripTrailingZeros().toString()));
            settleItemBO.setTAX_AMOUNT(invoiceTypeFlag != false ? BigDecimal.ZERO : orderItemPO.getTaxAmt());
            settleItemBO.setAMOUNT_NOTAX(invoiceTypeFlag != false ? settleItemBO.getAMOUNT_INTAX() : orderItemPO.getUntaxAmt());
            settleItemBO.setORG_ID(settleBO.getORG_ID());
            settleItemBO.setORG_NAME(settleBO.getORG_NAME());
            if (orderPO.getOrderSource().toString().equals("2")) {
                if (!StringUtils.isEmpty((Object)settleBO.getYN_PO()) && settleBO.getYN_PO().equals("Y")) {
                    settleItemBO.setEXP_TYPE(this.expType);
                    settleItemBO.setEXP_TYPE_ID(this.expTypeId);
                }
            } else if (orderItemPO.getUnifyContractType().equals("EQUIPMENT")) {
                settleItemBO.setEXP_TYPE(this.expType);
                settleItemBO.setEXP_TYPE_ID(this.expTypeId);
            }
            if (quality.compareTo(BigDecimal.ZERO) == 0) {
                settleItemBO.setDEPOSIT_AMT(BigDecimal.ZERO);
            } else {
                settleItemBO.setDEPOSIT_AMT(orderItemPO.getAmt().multiply(quality).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
            }
            settleItemBO.setEG_BALANCE_NUM(settleBO.getEG_BALANCE_NUM());
            settleItemBO.setPAY_TERMS(this.payTerms);
            if (!"\u8bbe\u5907\u6b3e".equals(settleBO.getVENDOR_SITE_CODE())) {
                BigDecimal rhUntaxAmt = BigDecimal.ZERO;
                if (materialMap.get(key) != null) {
                    for (FscUnifySettleMaterialBO materialBO : (List)materialMap.get(key)) {
                        rhUntaxAmt = rhUntaxAmt.add(materialBO.getMATCH_AMOUNT());
                    }
                    if (rhUntaxAmt.compareTo(BigDecimal.ZERO) != 0 && rhUntaxAmt.compareTo(settleItemBO.getAMOUNT_NOTAX()) != 0) {
                        BigDecimal balanceAmt;
                        if (settleItemBO.getAMOUNT_NOTAX().compareTo(rhUntaxAmt) > 0) {
                            balanceAmt = settleItemBO.getAMOUNT_NOTAX().subtract(rhUntaxAmt);
                            ((FscUnifySettleMaterialBO)((List)materialMap.get(key)).get(0)).setMATCH_AMOUNT(((FscUnifySettleMaterialBO)((List)materialMap.get(key)).get(0)).getMATCH_AMOUNT().add(balanceAmt));
                        }
                        if (settleItemBO.getAMOUNT_NOTAX().compareTo(rhUntaxAmt) < 0) {
                            balanceAmt = rhUntaxAmt.subtract(settleItemBO.getAMOUNT_NOTAX());
                            ((FscUnifySettleMaterialBO)((List)materialMap.get(key)).get(0)).setMATCH_AMOUNT(((FscUnifySettleMaterialBO)((List)materialMap.get(key)).get(0)).getMATCH_AMOUNT().subtract(balanceAmt));
                        }
                    }
                }
                settleItemBO.setPoLineList((List)materialMap.get(key));
            }
            settleItemBOList.add(settleItemBO);
        }
        FscPurWriteOffPO writeOffPO = new FscPurWriteOffPO();
        writeOffPO.setFscOrderId(orderPO.getFscOrderId());
        List writeOffPOS = this.fscPurWriteOffMapper.getList(writeOffPO);
        for (FscPurWriteOffPO writeOff : writeOffPOS) {
            FscUnifySettleWriteOffBO writeOffBO = new FscUnifySettleWriteOffBO();
            writeOffBO.setAMOUNT(writeOff.getWriteOffAmount());
            writeOffBO.setCONTRACT_NUM((String)orderContractMap.get(writeOff.getOrderId()));
            writeOffBO.setEG_BALANCE_NUM(orderPO.getOrderNo());
            writeOffBO.setEG_PREPAY_NUM(writeOff.getPayOrderNo());
            writeOffBO.setORG_ID(settleBO.getORG_ID());
            writeOffBOList.add(writeOffBO);
        }
        if (CollectionUtils.isEmpty(writeOffBOList)) {
            List changeRelationList;
            ArrayList writeRelationPOList = new ArrayList();
            List chargeRelationList = this.fscOrderWriteRelationMapper.getPurWriteOffInfo(orderPO.getFscOrderId());
            if (!CollectionUtils.isEmpty((Collection)chargeRelationList)) {
                writeRelationPOList.addAll(chargeRelationList);
            }
            if (!CollectionUtils.isEmpty((Collection)(changeRelationList = this.fscOrderWriteRelationMapper.getChangeWriteOffInfo(orderPO.getFscOrderId())))) {
                writeRelationPOList.addAll(changeRelationList);
            }
            for (FscOrderWriteRelationPO fscOrderWriteRelationPO : writeRelationPOList) {
                FscUnifySettleWriteOffBO writeOffBO = new FscUnifySettleWriteOffBO();
                writeOffBO.setAMOUNT(fscOrderWriteRelationPO.getWriteOffAmount());
                writeOffBO.setCONTRACT_NUM((String)orderContractMap.get(fscOrderWriteRelationPO.getOrderId()));
                writeOffBO.setEG_BALANCE_NUM(orderPO.getOrderNo());
                writeOffBO.setEG_PREPAY_NUM(fscOrderWriteRelationPO.getChangeChargeNo());
                writeOffBO.setORG_ID(settleBO.getORG_ID());
                writeOffBOList.add(writeOffBO);
            }
        }
    }

    private void buildSettleInfo(FscOrderPO orderPO, FscUnifySettleBO settleBO) {
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(orderPO.getFscOrderId());
        orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6269\u5c55\u76f8\u5173\u4fe1\u606f\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(orderExtPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        FscDicDictionaryExernalPO dicExternalPo = new FscDicDictionaryExernalPO();
        dicExternalPo.setPCode("FSC_UNIFY_IS_EQUIP_PURCHASE");
        List taxIdList = this.fscDicDictionaryExernalMapper.getListByCondition(dicExternalPo);
        Map<String, String> ynMap = taxIdList.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
        settleBO.setCOM_CODE(orderExtPO.getUnifyComCode());
        settleBO.setBILL_DATE(DateUtil.dateToStr((Date)orderPO.getCreateTime()));
        settleBO.setVENDOR_NUM(orderExtPO.getSupplierErpCode());
        settleBO.setVENDOR_NAME(orderPO.getPayeeName());
        settleBO.setVENDOR_SITE_CODE(orderExtPO.getVendorSiteName());
        settleBO.setPERSON_ID(orderExtPO.getUnifyUserId());
        settleBO.setPERSON_NAME(orderExtPO.getUnifyUserName());
        settleBO.setDEPT_ID(orderExtPO.getUnifyDeptId());
        settleBO.setDEPT_NAME(orderExtPO.getUnifyDeptName());
        settleBO.setAMOUNT(orderPO.getTotalCharge());
        if (orderExtPO.getIsEquipPurchase() != null && orderExtPO.getIsEquipPurchase() == 1) {
            settleBO.setYN_PO(ynMap.get(orderExtPO.getIsEquipPurchase().toString()));
        }
        settleBO.setPREPAY_AMT(BigDecimal.ZERO);
        settleBO.setDESCRIPTIONS(orderPO.getInvoiceRemark());
        settleBO.setORG_ID(orderExtPO.getUnifyOrgId());
        settleBO.setORG_NAME(orderExtPO.getUnifyOrgName());
        settleBO.setSTATUS("N");
        settleBO.setSTATUS_DIS("\u65b0\u5efa");
        if (!StringUtils.isEmpty((Object)orderPO.getType()) && "1".equals(orderPO.getType())) {
            settleBO.setSTATUS("Y");
            settleBO.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
        }
        settleBO.setEG_BALANCE_NUM(orderPO.getOrderNo());
        settleBO.setEG_BALANCE_ID(orderPO.getFscOrderId());
        settleBO.setUSER_ID(Long.valueOf(orderExtPO.getExt1()));
        settleBO.setToken(tokenQryAbilityRspBO.getData());
    }

    private List<FscUnifySettleInvoiceBO> buildInvoiceInfo(FscOrderPO orderPO, FscUnifySettleBO settleBO, Boolean invoiceTypeFlag) {
        ArrayList<FscUnifySettleInvoiceBO> invoiceList = new ArrayList<FscUnifySettleInvoiceBO>();
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setFscOrderId(orderPO.getFscOrderId());
        List invoicePoList = this.fscInvoiceMapper.getList(invoicePO);
        for (FscInvoicePO fscInvoicePO : invoicePoList) {
            FscUnifySettleInvoiceBO settleInvoiceBO = new FscUnifySettleInvoiceBO();
            settleInvoiceBO.setAMOUNT_INTAX(fscInvoicePO.getAmt());
            settleInvoiceBO.setTAX_AMOUNT(invoiceTypeFlag != false ? BigDecimal.ZERO : fscInvoicePO.getTaxAmt());
            settleInvoiceBO.setAMOUNT_NOTAX(invoiceTypeFlag != false ? settleInvoiceBO.getAMOUNT_INTAX() : fscInvoicePO.getUntaxAmt());
            settleInvoiceBO.setINVOICE_DATE(fscInvoicePO.getBillDate());
            settleInvoiceBO.setINVOICE_NUM(fscInvoicePO.getInvoiceNo());
            settleInvoiceBO.setINVOICE_ID(fscInvoicePO.getUnifyInvoiceId());
            settleInvoiceBO.setEG_BILL_NUM(settleBO.getEG_BALANCE_NUM());
            settleInvoiceBO.setORG_ID(settleBO.getORG_ID());
            settleInvoiceBO.setORG_NAME(settleBO.getORG_NAME());
            invoiceList.add(settleInvoiceBO);
        }
        return invoiceList;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

