/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bo.FscClaimDetailChangeBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimChangeCreateAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimChangeCreateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimChangeCreateAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimChangeCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimChangeCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimChangeCreateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.exception.FscBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRecvClaimChangeCreateAbilityService"})
public class FscRecvClaimChangeCreateAbilityServiceImpl
implements FscRecvClaimChangeCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimChangeCreateAbilityServiceImpl.class);
    @Autowired
    private FscRecvClaimChangeCreateBusiService fscRecvClaimChangeCreateBusiService;
    @Resource(name="fscPushYcRecvClaimChangeMqServiceProvider")
    private ProxyMessageProducer fscPushYcRecvClaimChangeMqServiceProvider;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC}")
    private String pushTopic;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG}")
    private String pushTag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"dealCreate"})
    public FscRecvClaimChangeCreateAbilityRspBO dealCreate(@RequestBody FscRecvClaimChangeCreateAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscRecvClaimChangeCreateBusiReqBO busiReqBO = (FscRecvClaimChangeCreateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscRecvClaimChangeCreateBusiReqBO.class));
        FscRecvClaimChangeCreateBusiRspBO busiRspBO = this.fscRecvClaimChangeCreateBusiService.dealCreate(busiReqBO);
        log.info("----------------------------\u6536\u6b3e\u8ba4\u9886\u53d8\u66f4\u51fa\u53c2\u4e3a\uff1a" + JSONObject.toJSON((Object)((Object)busiRspBO)));
        if ("0000".equals(busiRspBO.getRespCode()) && !CollectionUtils.isEmpty(busiRspBO.getConfirmedList())) {
            try {
                FscClaimChangeConfirmBusiRspBO rspBO = new FscClaimChangeConfirmBusiRspBO();
                rspBO.setChangeIdList(busiRspBO.getConfirmedList());
                this.sendMqs(rspBO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscRecvClaimChangeCreateAbilityRspBO)JSONObject.parseObject((String)respString, FscRecvClaimChangeCreateAbilityRspBO.class);
    }

    private void sendMqs(FscClaimChangeConfirmBusiRspBO busiRspBO) {
        ProxySendResult proxySendResult = this.fscPushYcRecvClaimChangeMqServiceProvider.send(new ProxyMessage(this.pushTopic, this.pushTag, JSONObject.toJSONString(busiRspBO.getChangeIdList())));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeStateFailLog(JSONObject.toJSONString(busiRspBO.getChangeIdList()));
        }
    }

    private void valid(FscRecvClaimChangeCreateAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!FscConstants.FscOrderOperType.save.equals(reqBO.getOperationType()) && !FscConstants.FscOrderOperType.commit.equals(reqBO.getOperationType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operationType]\u53ea\u80fd\u662f" + FscConstants.FscOrderOperType.save + "\u6216" + FscConstants.FscOrderOperType.commit);
        }
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba4\u9886\u5355id[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeAmt() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u91d1\u989d[changeAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeDate() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u8d77\u53d8\u66f4\u65e5\u671f[changeDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeDeptId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u90e8\u95e8id[changeDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChangeDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u90e8\u95e8[changeDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeUserId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u4ebaid[changeUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChangeUserName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u4eba[changeUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailChangeList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u660e\u7ec6[changeList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BigDecimal changeAmt = reqBO.getDetailChangeList().stream().map(FscClaimDetailChangeBO::getChangeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (reqBO.getChangeAmt().compareTo(changeAmt) != 0) {
            throw new FscBusinessException("191000", "\u53d8\u66f4\u660e\u7ec6\u53d8\u66f4\u91d1\u989d\u4e4b\u548c\u4e0e\u53d8\u66f4\u5355\u53d8\u66f4\u91d1\u989d\u4e0d\u5339\u914d");
        }
        for (FscClaimDetailChangeBO bo : reqBO.getDetailChangeList()) {
            if (bo.getSysSource() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u6765\u6e90[sysSource]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeSource() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u540e\u6765\u6e90[changeSource]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getClaimDetailId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6id[claimDetailId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeAmt() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u660e\u7ec6\u53d8\u66f4\u91d1\u989d[changeAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeClaimType() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u8ba4\u9886\u7c7b\u578b[changeClaimType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!FscSystemSourceEnum.YG.getCode().equals(bo.getChangeSource())) continue;
            if (bo.getChangeFscOrderId() == null && bo.getChangeOrderId() == null && bo.getChangeAccountId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ed3\u7b97\u5355id\u3001\u8ba2\u5355id\u3001\u8d26\u6237\u9884\u5b58\u6b3eid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeFscOrderId() != null && StringUtils.isEmpty((Object)bo.getChangeFscOrderNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ed3\u7b97\u5355\u53f7[changeFscOrderNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getChangeFscOrderId() != null && StringUtils.isEmpty((Object)bo.getChangeAcceptId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u5165\u5e93\u5355\u53f7[changeAcceptId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getChangeOrderId() != null && StringUtils.isEmpty((Object)bo.getChangeOrderCode())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u8ba2\u5355\u7f16\u53f7[changeOrderCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeOrderId() != null && StringUtils.isEmpty((Object)bo.getChangeShouldPayId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u4ed8\u6b3e\u5355id[changeShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeAccountId() == null || !StringUtils.isEmpty((Object)bo.getChangeAccountNo())) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u9884\u5b58\u6b3e\u8d26\u6237[changeAccountNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @PostMapping(value={"dealCreateWrite"})
    public FscRecvClaimChangeCreateAbilityRspBO dealCreateWrite(@RequestBody FscRecvClaimChangeCreateAbilityReqBO reqBO) {
        this.validWrite(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscRecvClaimChangeCreateBusiReqBO busiReqBO = (FscRecvClaimChangeCreateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscRecvClaimChangeCreateBusiReqBO.class));
        FscRecvClaimChangeCreateBusiRspBO busiRspBO = new FscRecvClaimChangeCreateBusiRspBO();
        if (FscConstants.FscWriteQueryType.ADVANCE.equals(reqBO.getQueryType())) {
            busiRspBO = this.fscRecvClaimChangeCreateBusiService.dealCreateAdvanceWrite(busiReqBO);
        } else if (FscConstants.FscWriteQueryType.ORDER.equals(reqBO.getQueryType())) {
            busiRspBO = this.fscRecvClaimChangeCreateBusiService.dealCreateOrderWrite(busiReqBO);
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        if ("0000".equals(busiRspBO.getRespCode())) {
            this.sendMq(busiRspBO);
        }
        return (FscRecvClaimChangeCreateAbilityRspBO)JSONObject.parseObject((String)respString, FscRecvClaimChangeCreateAbilityRspBO.class);
    }

    private void sendMq(FscRecvClaimChangeCreateBusiRspBO busiRspBO) {
        ProxySendResult proxySendResult = this.fscPushYcRecvClaimChangeMqServiceProvider.send(new ProxyMessage(this.pushTopic, this.pushTag, JSONObject.toJSONString(new ArrayList<Long>(Collections.singleton(busiRspBO.getChangeId())))));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeStateFailLog(JSONObject.toJSONString(new ArrayList<Long>(Collections.singleton(busiRspBO.getChangeId()))));
        }
        if (!CollectionUtils.isEmpty((Collection)busiRspBO.getFscOrderIds())) {
            FscComOrderListSyncAbilityReqBO reqBO = new FscComOrderListSyncAbilityReqBO();
            reqBO.setIsThread(Boolean.valueOf(false));
            reqBO.setFscOrderIds(busiRspBO.getFscOrderIds());
            reqBO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
            this.fscComOrderSyncAbilityService.dealSyncAllOrder(reqBO);
        }
    }

    private void writeStateFailLog(String objNo) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(objNo);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_CLAIM_CHANGE_SETTLE_PUSH_YC_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void validWrite(FscRecvClaimChangeCreateAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba4\u9886\u5355id[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeDate() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u8d77\u53d8\u66f4\u65e5\u671f[changeDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeDeptId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u90e8\u95e8id[changeDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChangeDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u90e8\u95e8[changeDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeUserId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u4ebaid[changeUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChangeUserName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u4eba[changeUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailChangeList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u660e\u7ec6[changeList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscClaimDetailChangeBO bo : reqBO.getDetailChangeList()) {
            if (bo.getChangeFscOrderId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355id[changeFscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)bo.getChangeFscOrderNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355\u53f7[changeFscOrderNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getOrderId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getOrderCode() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355\u7f16\u53f7[orderCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeAmt() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u91d1\u989d[changeAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getTotalCharge() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355\u91d1\u989d[totalCharge]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getOrderAmount() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u8ba2\u5355\u91d1\u989d[orderAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getBuynerNo() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e70\u53d7\u4eba\u7f16\u53f7[buynerNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)bo.getBuynerName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e70\u53d7\u4eba[buynerName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getWriteOffAmount() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5df2\u6838\u9500\u91d1\u989d[writeOffAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getPayerName() != null) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u65b9\u540d\u79f0[payerName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

