/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscRefundBillDeleteTaskAbilityService;
import com.tydic.fsc.common.ability.bo.FscRefundBillDeleteTaskAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRefundBillDeleteTaskAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRefundBillDeleteBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundBillDeleteBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundBillDeleteBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRefundBillDeleteTaskAbilityService"})
public class FscRefundBillDeleteTaskAbilityServiceImpl
implements FscRefundBillDeleteTaskAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Value(value="${REFUND_BILL_DELETE_LIMIT:100}")
    private Integer limit;
    @Autowired
    private FscRefundBillDeleteBusiService fscRefundBillDeleteBusiService;

    @PostMapping(value={"dealRefundBillTask"})
    public FscRefundBillDeleteTaskAbilityRspBO dealRefundBillTask(@RequestBody FscRefundBillDeleteTaskAbilityReqBO reqBO) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -6);
        String dataStr = dateFormat.format(calendar.getTime());
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.DELETE);
        ArrayList<Integer> orderFlows = new ArrayList<Integer>();
        orderFlows.add(FscConstants.OrderFlow.REFUND_INVOICE);
        orderFlows.add(FscConstants.OrderFlow.TRAFFIC_REFUND_INVOICE);
        refundPO.setOrderFlows(orderFlows);
        refundPO.setDelDate(dataStr);
        refundPO.setLimit(this.limit);
        List refundPOList = this.fscOrderRefundMapper.getList(refundPO);
        if (CollectionUtils.isEmpty((Collection)refundPOList)) {
            return new FscRefundBillDeleteTaskAbilityRspBO();
        }
        List<Long> refundIdList = refundPOList.stream().map(FscOrderRefundPO::getRefundId).collect(Collectors.toList());
        FscRefundBillDeleteBusiReqBO busiReqBO = new FscRefundBillDeleteBusiReqBO();
        busiReqBO.setRefundIds(refundIdList);
        FscRefundBillDeleteBusiRspBO busiRspBO = this.fscRefundBillDeleteBusiService.dealRefundBillDelete(busiReqBO);
        return (FscRefundBillDeleteTaskAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscRefundBillDeleteTaskAbilityRspBO.class);
    }
}

