/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.common.ability.api.FscSettleWriteOffAbilityService;
import com.tydic.fsc.common.ability.bo.FscSettleWriteOffAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSettleWriteOffAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscSettleWriteOffDetailAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscSettleWriteBackBusiService;
import com.tydic.fsc.common.busi.bo.FscSettleWriteBackBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSettleWriteBackBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscSettleWriteOffDetailMapper;
import com.tydic.fsc.dao.FscSettleWriteOffMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscSettleWriteOffDetailPO;
import com.tydic.fsc.po.FscSettleWriteOffPO;
import com.tydic.uoc.base.utils.CommUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscSettleWriteOffAbilityService"})
public class FscSettleWriteOffAbilityServiceImpl
implements FscSettleWriteOffAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscSettleWriteOffAbilityServiceImpl.class);
    @Autowired
    private FscSettleWriteOffMapper fscSettleWriteOffMapper;
    @Autowired
    private FscSettleWriteOffDetailMapper fscSettleWriteOffDetailMapper;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Value(value="${Bill_TAX_YC_SYS_URL:http://39.106.83.78:8001/OSN/api/invoiceApply/v1}")
    private String Bill_TAX_YC_SYS_URL;
    @Autowired
    private FscSettleWriteBackBusiService fscBackbusiService;
    @Value(value="${FLAG:false}")
    private Boolean flag;

    @PostMapping(value={"getPageList"})
    public FscSettleWriteOffAbilityRspBO getPageList(@RequestBody FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteOffAbilityRspBO rsp = new FscSettleWriteOffAbilityRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List list = this.fscSettleWriteOffMapper.getPageList((FscSettleWriteOffPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSettleWriteOffPO.class), page);
        rsp.setRows(list);
        rsp.setTotal(Integer.valueOf(page.getTotalPages()));
        rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            rsp.setPageNo(reqBO.getPageNo());
        }
        return rsp;
    }

    @PostMapping(value={"getById"})
    public FscSettleWriteOffAbilityRspBO getById(@RequestBody FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteOffAbilityRspBO rsp = new FscSettleWriteOffAbilityRspBO();
        rsp.setT((Object)this.fscSettleWriteOffMapper.queryById(reqBO.getHeaderId()));
        return rsp;
    }

    @PostMapping(value={"insertOrUpdate"})
    public FscSettleWriteOffAbilityRspBO insertOrUpdate(@RequestBody FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteOffAbilityRspBO rspBO = new FscSettleWriteOffAbilityRspBO();
        if (StringUtils.isEmpty((String)reqBO.getBillNumber())) {
            String settleNumber = this.createCode(reqBO.getSettleNumber(), reqBO.getSettleId());
            reqBO.setBillNumber(settleNumber);
        }
        rspBO.setFlag(false);
        if (reqBO.getHeaderId() == null) {
            Long scopeId = Sequence.getInstance().nextId();
            reqBO.setCreateTime(new Date());
            reqBO.setUpdateTime(new Date());
            reqBO.setHeaderId(scopeId);
            reqBO.setCreateUserName(reqBO.getOccupation());
            reqBO.setUpdateUserName(reqBO.getOccupation());
            FscSettleWriteOffPO fscInvoicePoolPO = (FscSettleWriteOffPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSettleWriteOffPO.class);
            int isInsert = this.fscSettleWriteOffMapper.insert(fscInvoicePoolPO);
            if (isInsert < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u6838\u9500\u5355\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            rspBO.setCode("0000");
        } else {
            reqBO.setUpdateUserName(reqBO.getOccupation());
            reqBO.setUpdateTime(new Date());
            FscSettleWriteOffPO fscInvoicePoolPO = (FscSettleWriteOffPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSettleWriteOffPO.class);
            int isInsert = this.fscSettleWriteOffMapper.update(fscInvoicePoolPO);
            if (isInsert < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u6838\u9500\u5355\u4fee\u6539\u5931\u8d25\uff01");
            }
            rspBO.setCode("0000");
        }
        for (FscSettleWriteOffDetailAbilityReqBO detail : reqBO.getList()) {
            if (detail.getLineId() == null) {
                Long scopeId = Sequence.getInstance().nextId();
                detail.setLineId(scopeId);
                detail.setHeaderId(reqBO.getHeaderId());
                detail.setCreateTime(new Date());
                detail.setUpdateTime(new Date());
                FscSettleWriteOffDetailPO details = (FscSettleWriteOffDetailPO)JSON.parseObject((String)JSON.toJSONString((Object)detail), FscSettleWriteOffDetailPO.class);
                this.fscSettleWriteOffDetailMapper.insert(details);
                continue;
            }
            detail.setHeaderId(reqBO.getHeaderId());
            detail.setUpdateTime(new Date());
            FscSettleWriteOffDetailPO details = (FscSettleWriteOffDetailPO)JSON.parseObject((String)JSON.toJSONString((Object)detail), FscSettleWriteOffDetailPO.class);
            this.fscSettleWriteOffDetailMapper.update(details);
        }
        FscSettleWriteOffAbilityRspBO rspsBO = this.pushYc(reqBO);
        reqBO.setAuthPermission(null);
        rspBO.setT((Object)reqBO);
        rspBO.setRespCode(rspsBO.getRespCode());
        rspBO.setRespDesc(rspsBO.getRespDesc());
        return rspBO;
    }

    public FscSettleWriteOffAbilityRspBO pushYc(FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteOffAbilityRspBO rspBO = new FscSettleWriteOffAbilityRspBO();
        if (this.flag.booleanValue()) {
            try {
                JSONObject jsonObject = new JSONObject();
                JSONObject header = new JSONObject();
                header.put("HEADER_ID", (Object)"");
                header.put("BILL_NUMBER", (Object)reqBO.getBillNumber());
                header.put("CUSTOMER_NAME", (Object)reqBO.getCustomerName());
                header.put("CUSTOMER_ID", (Object)this.getCustomerId(reqBO.getCustomerName()));
                header.put("THIS_WRITE_OFF_AMOUNT", (Object)reqBO.getThisWriteOffAmount());
                header.put("PERSON_NAME", (Object)reqBO.getPersonName());
                header.put("PERSON_ID", (Object)reqBO.getPersonId());
                header.put("DEPT_NAME", (Object)reqBO.getDeptName());
                header.put("DEPT_ID", (Object)reqBO.getDeptId());
                header.put("SETTLE_NUMBER", (Object)reqBO.getSettleNumber());
                header.put("SETTLE_ID", (Object)reqBO.getSettleId());
                header.put("WRITE_OFF_TYPE", (Object)reqBO.getWriteOffType());
                header.put("TESCO_ID", (Object)reqBO.getHeaderId());
                jsonObject.put("settleReceivable", (Object)header);
                JSONArray lineArray = new JSONArray();
                for (FscSettleWriteOffDetailAbilityReqBO detail : reqBO.getList()) {
                    JSONObject line = new JSONObject();
                    line.put("LINE_ID", (Object)"");
                    line.put("PRE_CLAIM_ID", (Object)"");
                    line.put("CLAIM_ID", (Object)detail.getClaimDetailId());
                    line.put("AMOUNT", (Object)detail.getThisWriteOffAmount());
                    line.put("TESCO_ID", (Object)detail.getLineId());
                    lineArray.add((Object)line);
                }
                jsonObject.put("settleReceivableLine", (Object)lineArray);
                log.info("\u8c03\u7528\u4e1a\u8d22\u7ed3\u7b97\u6838\u9500\u5165\u53c2\uff1a" + jsonObject.toJSONString());
                String res = FscSettleWriteOffAbilityServiceImpl.sendPost(this.Bill_TAX_YC_SYS_URL + "?respId=145950&userId=" + reqBO.getPersonId() + "&respId=147250&p_type=SavebaseInfo&p_switch=Tesco&HEADER_ID=8", "jsonMap=" + jsonObject.toJSONString());
                log.info("\u8c03\u7528\u4e1a\u8d22\u7ed3\u7b97\u6838\u9500\u51fa\u53c2\uff1a" + res);
                FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
                logAbilityReqBO.setCreateTime(new Date());
                logAbilityReqBO.setObjectId(reqBO.getHeaderId());
                logAbilityReqBO.setObjectNo(reqBO.getBillNumber());
                logAbilityReqBO.setType(FscConstants.FscPushType.SETTLE);
                logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)jsonObject));
                if (res != null) {
                    JSONArray js = JSONArray.parseArray((String)res);
                    if (js.get(0) != null && js.get(0).equals("Y")) {
                        logAbilityReqBO.setStatus(FscConstants.FscPushStatus.SUCCESS);
                        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u63a8\u9001\u4e1a\u8d22\u6210\u529f\uff01" + js.get(1));
                        this.dealWriteData(reqBO);
                        FscSettleWriteOffPO settleWrite = new FscSettleWriteOffPO();
                        settleWrite.setHeaderId(reqBO.getHeaderId());
                        settleWrite.setPurchasePushStatus("1");
                        this.fscSettleWriteOffMapper.update(settleWrite);
                    }
                    logAbilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
                    this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
                    rspBO.setRespCode("190000");
                    rspBO.setRespDesc("\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01" + js.get(1));
                }
                logAbilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
                this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u4e1a\u8d22\u5931\u8d25: " + CommUtils.dealStackTrace((Exception)e));
                throw new FscBusinessException("190000", "\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01");
            }
        } else {
            this.dealWriteData(reqBO);
        }
        return rspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, String string) {
        String result = "";
        BufferedReader bufferedReader = null;
        PrintWriter out = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            long l = System.currentTimeMillis();
            System.out.println(l);
            connection.setRequestProperty("Cookie", "SESSIONID=" + l);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            out = new PrintWriter(connection.getOutputStream());
            out.print(string);
            out.flush();
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            while (null != (line = bufferedReader.readLine())) {
                result = result + line;
            }
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01\uff01\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public String getCustomerId(String customerName) {
        try {
            log.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\uff1a" + customerName);
            FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
            custInfoReqBO.setCustomerName(customerName);
            FscGetErpCustInfoRspBO erpCustInfo = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
            if (!erpCustInfo.getRespCode().equals("0000")) {
                throw new FscBusinessException(erpCustInfo.getRespCode(), erpCustInfo.getRespDesc());
            }
            return erpCustInfo.getCustAccountId();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("190000", "\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    public String createCode(String settleNumber, Long settleId) {
        String count = this.fscSettleWriteOffMapper.selectMaxOrderNum(settleId);
        return settleNumber + "-HX-" + count;
    }

    @PostMapping(value={"getSettleList"})
    public FscSettleWriteOffAbilityRspBO getSettleList(@RequestBody FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteOffAbilityRspBO rsp = new FscSettleWriteOffAbilityRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List list = this.fscSettleWriteOffMapper.getSettleList((FscSettleWriteOffPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSettleWriteOffPO.class), page);
        rsp.setRows(list);
        rsp.setTotal(Integer.valueOf(page.getTotalPages()));
        rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            rsp.setPageNo(reqBO.getPageNo());
        }
        return rsp;
    }

    @PostMapping(value={"pushY"})
    public FscSettleWriteOffAbilityRspBO pushY(@RequestBody FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteOffAbilityRspBO rsp = new FscSettleWriteOffAbilityRspBO();
        FscSettleWriteOffPO header = this.fscSettleWriteOffMapper.queryById(reqBO.getHeaderId());
        FscSettleWriteOffDetailPO line = new FscSettleWriteOffDetailPO();
        line.setHeaderId(reqBO.getHeaderId());
        List lineList = this.fscSettleWriteOffDetailMapper.getList(line);
        header.setList(lineList);
        FscSettleWriteOffAbilityReqBO req = (FscSettleWriteOffAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)header), FscSettleWriteOffAbilityReqBO.class);
        FscSettleWriteOffAbilityRspBO rspsBO = this.pushYc(req);
        reqBO.setAuthPermission(null);
        rsp.setRespCode(rspsBO.getRespCode());
        rsp.setRespDesc(rspsBO.getRespDesc());
        return rsp;
    }

    @PostMapping(value={"receiveYcStatus"})
    public FscSettleWriteOffAbilityRspBO receiveYcStatus(@RequestBody FscSettleWriteOffAbilityReqBO reqBO) {
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setObjectId((Long)reqBO.getHeaderIds().get(0));
        logAbilityReqBO.setType(FscConstants.FscPushType.FSC_ORDER_POSTING_STATUS);
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)reqBO.getHeaderIds()));
        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
        FscSettleWriteOffPO po = new FscSettleWriteOffPO();
        po.setPostingStatus("1");
        po.setPostingDate(new Date());
        po.setHeaderIds(reqBO.getHeaderIds());
        this.fscSettleWriteOffMapper.update(po);
        FscSettleWriteOffAbilityRspBO rspBO = new FscSettleWriteOffAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealWriteData(FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteBackBusiReqBO busiReqBO = new FscSettleWriteBackBusiReqBO();
        busiReqBO.setList(reqBO.getList());
        busiReqBO.setFscOrderId(reqBO.getSettleId());
        busiReqBO.setThisWriteOffAmount(reqBO.getThisWriteOffAmount());
        FscSettleWriteBackBusiRspBO rspBO = this.fscBackbusiService.writeBack(busiReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new FscBusinessException("190000", rspBO.getRespDesc());
        }
        log.info("\u4fee\u6539\u6838\u9500\u8865\u5f55\u72b6\u6001");
        FscSettleWriteOffPO settleWrite = new FscSettleWriteOffPO();
        settleWrite.setHeaderId(reqBO.getHeaderId());
        settleWrite.setPurchasePushStatus("1");
        this.fscSettleWriteOffMapper.update(settleWrite);
    }

    @PostMapping(value={"dealWriteOff"})
    public FscSettleWriteOffAbilityRspBO dealWriteOff(@RequestBody FscSettleWriteOffAbilityReqBO reqBO) {
        FscSettleWriteOffAbilityRspBO rspBO = new FscSettleWriteOffAbilityRspBO();
        FscSettleWriteOffPO header = this.fscSettleWriteOffMapper.queryById(reqBO.getHeaderId());
        FscSettleWriteOffDetailPO line = new FscSettleWriteOffDetailPO();
        line.setHeaderId(reqBO.getHeaderId());
        List lineList = this.fscSettleWriteOffDetailMapper.getList(line);
        header.setList(lineList);
        FscSettleWriteOffAbilityReqBO req = (FscSettleWriteOffAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)header), FscSettleWriteOffAbilityReqBO.class);
        this.dealWriteData(req);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

