/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.common.ability.api.FscSyncYcSettleClaimDataAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushClaimDetailBO;
import com.tydic.fsc.common.ability.bo.FscSyncYcSettleClaimDataAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncYcSettleClaimDataAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscSyncYcSettleClaimDataReturnBo;
import com.tydic.fsc.common.busi.api.FscSyncYcSettleClaimDataBusiService;
import com.tydic.fsc.common.busi.bo.FscSyncYcSettleClaimDataBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSyncYcSettleClaimDataBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscPushClaimDetailMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscPushClaimDetailPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscSyncYcSettleClaimDataAbilityService"})
public class FscSyncYcSettleClaimDataAbilityServiceImpl
implements FscSyncYcSettleClaimDataAbilityService {
    @Autowired
    private FscSyncYcSettleClaimDataBusiService fscSyncYcSettleClaimDataBusiService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    public FscPushClaimDetailMapper fscPushClaimDetailMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;

    @PostMapping(value={"pushSettleClaimData"})
    public FscSyncYcSettleClaimDataAbilityRspBO pushSettleClaimData(@RequestBody FscSyncYcSettleClaimDataAbilityReqBO reqBO) {
        this.valid(reqBO);
        List fscOrderNoList = reqBO.getFscPushClaimDetailBOS().stream().map(FscPushClaimDetailBO::getFscOrderNo).collect(Collectors.toList());
        FscPushClaimDetailPo detailPo = new FscPushClaimDetailPo();
        detailPo.setFscOrderNos(fscOrderNoList);
        List list = this.fscPushClaimDetailMapper.getList(detailPo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            String desc = list.stream().map(FscPushClaimDetailPo::getFscOrderNo).collect(Collectors.joining(","));
            throw new FscBusinessException("198888", desc + "\u5df2\u7ecf\u5b58\u5728\u4e0d\u80fd\u91cd\u590d\u63a8\u9001 ");
        }
        ArrayList<FscSyncYcSettleClaimDataReturnBo> returnBos = new ArrayList<FscSyncYcSettleClaimDataReturnBo>();
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        for (FscPushClaimDetailBO bo : reqBO.getFscPushClaimDetailBOS()) {
            logAbilityReqBO.setCreateTime(new Date());
            logAbilityReqBO.setObjectId(bo.getFscOrderId());
            logAbilityReqBO.setObjectNo(bo.getFscOrderNo());
            logAbilityReqBO.setType(FscConstants.FscPushType.PUSH_CLAIM_CHANGE);
            logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)bo));
            this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
            FscSyncYcSettleClaimDataBusiReqBO busiReqBO = (FscSyncYcSettleClaimDataBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)bo), FscSyncYcSettleClaimDataBusiReqBO.class));
            this.tranType(bo, busiReqBO);
            FscSyncYcSettleClaimDataBusiRspBO busiRspBO = this.fscSyncYcSettleClaimDataBusiService.pushSettleClaimData(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) continue;
            FscSyncYcSettleClaimDataReturnBo returnBo = new FscSyncYcSettleClaimDataReturnBo();
            returnBo.setYcId(busiReqBO.getFscOrderId());
            returnBo.setYgId(busiRspBO.getYgId());
            returnBos.add(returnBo);
        }
        FscSyncYcSettleClaimDataAbilityRspBO rspBO = new FscSyncYcSettleClaimDataAbilityRspBO();
        rspBO.setReturnBos(returnBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void tranType(FscPushClaimDetailBO bo, FscSyncYcSettleClaimDataBusiReqBO busiReqBO) {
        if (!ObjectUtils.isEmpty((Object)bo.getClaimTypeCode())) {
            if (bo.getClaimTypeCode().equals("SELF_ELECTRONIC_MARKET")) {
                busiReqBO.setClaimType(Convert.toInt((Object)FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_OLD_CLAIM.getCode()));
            } else if (bo.getClaimTypeCode().equals("SELF_OPERATED")) {
                busiReqBO.setClaimType(Convert.toInt((Object)FscClaimTypeEnum.PROPRIETARY_SETTLE_OLD_CLAIM.getCode()));
            } else if (bo.getClaimTypeCode().equals("SELF_ORDER_CONTRACT")) {
                busiReqBO.setClaimType(Convert.toInt((Object)FscClaimTypeEnum.PROPRIETARY_RECV_OLD_CLAIM.getCode()));
            }
        }
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getExernalCode, FscDicDictionaryExernalPO::getCode));
    }

    private void valid(FscSyncYcSettleClaimDataAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscPushClaimDetailBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[FscPushClaimDetailBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscPushClaimDetailBO bo : reqBO.getFscPushClaimDetailBOS()) {
            if (ObjectUtils.isEmpty((Object)bo.getFscOrderId())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[FscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)bo.getFscOrderNo())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[FscOrderNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)bo.getSettleAmt())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[SettleAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)bo.getHandleDeptId())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[HandleDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)bo.getHandleDeptName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[HandleDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)bo.getHandleUserId())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[HandleUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!ObjectUtils.isEmpty((Object)bo.getHandleUserName())) continue;
            throw new FscBusinessException("198888", "\u5165\u53c2[HandleUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

