/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscUnifyRecallFlowAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUnifyRecallFlowAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUnifyRecallFlowAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscUnifyRecallFlowBusiService;
import com.tydic.fsc.common.busi.bo.FscUnifyRecallFlowBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscUnifyRecallFlowBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscUnifyRecallFlowAbilityService"})
public class FscUnifyRecallFlowAbilityServiceImpl
implements FscUnifyRecallFlowAbilityService {
    @Autowired
    private FscUnifyRecallFlowBusiService fscUnifyRecallFlowBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"dealRecallFlow"})
    public FscUnifyRecallFlowAbilityRspBO dealRecallFlow(@RequestBody FscUnifyRecallFlowAbilityReqBO reqBO) {
        this.valid(reqBO);
        ArrayList<Long> faildFscOrderIds = new ArrayList<Long>();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            try {
                FscUnifyRecallFlowBusiReqBO busiReqBO = (FscUnifyRecallFlowBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscUnifyRecallFlowBusiReqBO.class));
                busiReqBO.setFscOrderId(fscOrderId);
                FscUnifyRecallFlowBusiRspBO busiRspBO = this.fscUnifyRecallFlowBusiService.dealRecallFlow(busiReqBO);
                if (!"0000".equals(busiRspBO.getRespCode())) {
                    faildFscOrderIds.add(fscOrderId);
                } else {
                    this.sendMq(fscOrderId);
                }
                FscComOrderListSyncAbilityReqBO abilityReqBO = new FscComOrderListSyncAbilityReqBO();
                abilityReqBO.setFscOrderId(fscOrderId);
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(abilityReqBO);
            }
            catch (Exception e) {
                faildFscOrderIds.add(fscOrderId);
            }
        }
        FscUnifyRecallFlowAbilityRspBO rspBO = new FscUnifyRecallFlowAbilityRspBO();
        if (!CollectionUtils.isEmpty(faildFscOrderIds)) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u7ed3\u7b97\u5355\uff1a" + ((Object)faildFscOrderIds).toString() + "\u64a4\u56de\u5931\u8d25");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void valid(FscUnifyRecallFlowAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

