/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscAccountBillListBo;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillService;
import com.tydic.fsc.common.ability.api.FscAccountBillListQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscEncodedSerialGetPublicAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeProBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.common.enums.DeleteYnEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMainMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountMainPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.umc.general.ability.api.UmcBuyerCustomerQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountChargeProBusiServiceImpl
implements FscAccountChargeProBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargeProBusiServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountMainMapper fscAccountMainMapper;
    @Autowired
    private FscPushYcRecvClaimBillService fscPushYcRecvClaimBillService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private UmcBuyerCustomerQueryAbilityService umcBuyerCustomerQueryAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscEncodedSerialGetPublicAbilityService fscEncodedSerialGetPublicAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountBillListQueryAbilityService fscAccountBillListQueryAbilityService;
    private static final Integer TAB_ID = 60001;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    public FscAccountChargeBusiRspBO dealAccountCharge(FscAccountChargeBusiReqBO reqBO) {
        BigDecimal overdraftAmout;
        if (StringUtils.isEmpty((Object)reqBO.getAccountId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8d26\u6237id[accountId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
            throw new FscBusinessException("190000", "\u5165\u53c2claimNo\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryByClaimNo(reqBO.getClaimNo());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u76f8\u5173\u4fe1\u606f!");
        }
        if (fscRecvClaimPo.getClaimStatus().equals(FscClaimStatusEnum.CLAIM.getCode())) {
            throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886!");
        }
        if (reqBO.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) > 0) {
            throw new FscBusinessException("190000", "\u9884\u5b58\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\uff01");
        }
        if ((FscConstants.ChargeAccount.COMPANY.equals(reqBO.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(reqBO.getChargeAccount())) && reqBO.getCompanyChargeAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new FscBusinessException("190000", "\u516c\u53f8\u5145\u503c\u65f6\uff0c\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ((FscConstants.ChargeAccount.UNION.equals(reqBO.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(reqBO.getChargeAccount())) && reqBO.getUnionChargeAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new FscBusinessException("190000", "\u5de5\u4f1a\u5145\u503c\u65f6\uff0c\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountMainPO mainQueryVo = new FscAccountMainPO();
        if (null == reqBO.getChargeAccount()) {
            mainQueryVo.setBusiType("1");
        }
        mainQueryVo.setOrgCode(this.operationOrgCode);
        mainQueryVo.setBusiType("1");
        FscAccountMainPO fscAccountMainPo = this.fscAccountMainMapper.getModelBy(mainQueryVo);
        if (fscAccountMainPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5f00\u53d1\u516c\u53f8\u4e3b\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setId(reqBO.getAccountId());
        queryVo.setBusiType("1");
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        if (fscAccountPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setEnable(Integer.valueOf(1));
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (fscMerchantPo.getMerchantId() != null) {
            FscMerchantPO merchantElectricity = new FscMerchantPO();
            merchantElectricity.setPayBusiSceneRangeLike("1");
            merchantElectricity.setParentId(fscMerchantPo.getMerchantId());
            merchantElectricity.setDelFlag(FscConstants.DicDelFlag.NO);
            merchantElectricity.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            merchantElectricity.setPayObjId(fscAccountPo.getOrgId());
            merchantElectricity.setEnable(Integer.valueOf(1));
            merchantElectricity = this.fscMerchantMapper.getModelBy(merchantElectricity);
            if (merchantElectricity != null) {
                fscMerchantPo = merchantElectricity;
            }
            if (!FscConstants.FscPayType.FSC_PAY_TYPE_ADVANCE.equals(fscMerchantPo.getPayType())) {
                throw new FscBusinessException("198888", "\u5145\u503c\u8d26\u6237\u7ed3\u7b97\u6a21\u5f0f\u4e0d\u662f\u9884\u5b58\u6b3e\u652f\u4ed8\uff0c\u65e0\u6cd5\u5145\u503c\uff01");
            }
        }
        if ((overdraftAmout = fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount()).subtract(fscAccountPo.getDistributeAdvanceAmount())).compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal chargeAmount = reqBO.getChargeAmount();
            FscAccountBillListQueryAbilityReqBO fscAccountBillListQueryAbilityReqBO = new FscAccountBillListQueryAbilityReqBO();
            fscAccountBillListQueryAbilityReqBO.setAccountId(fscAccountPo.getId());
            fscAccountBillListQueryAbilityReqBO.setIsOverPay(Integer.valueOf(0));
            fscAccountBillListQueryAbilityReqBO.setPageNo(Integer.valueOf(-1));
            fscAccountBillListQueryAbilityReqBO.setPageSize(Integer.valueOf(-1));
            ArrayList<Integer> tabIdList = new ArrayList<Integer>();
            tabIdList.add(TAB_ID);
            fscAccountBillListQueryAbilityReqBO.setTabIdList(tabIdList);
            fscAccountBillListQueryAbilityReqBO.setTabId(TAB_ID);
            FscAccountBillListQueryAbilityRspBO fscAccountBillListQueryAbilityRspBO = this.fscAccountBillListQueryAbilityService.qryAccountBillList(fscAccountBillListQueryAbilityReqBO);
            if (!"0000".equals(fscAccountBillListQueryAbilityRspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u900f\u652f\u5f85\u8fd8\u8d26\u5355\u5f02\u5e38\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)fscAccountBillListQueryAbilityRspBO.getRows())) {
                ArrayList<FscPayLogPO> backList = new ArrayList<FscPayLogPO>();
                for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListQueryAbilityRspBO.getRows()) {
                    if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                    FscPayLogPO fscPayLogPO = new FscPayLogPO();
                    fscPayLogPO.setAccountId(fscAccountPo.getId());
                    fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                    ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                    busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
                    busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
                    fscPayLogPO.setBusiCategoryList(busiCategoryList);
                    fscPayLogPO.setIsOverPay(Integer.valueOf(0));
                    fscPayLogPO.setOrderBy("overdraft_amt asc");
                    List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
                    if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) continue;
                    Date reimbursementDate = new Date();
                    for (FscPayLogPO po : fscPayLogPOList) {
                        if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                        FscPayLogPO backPayLog = new FscPayLogPO();
                        backPayLog.setId(po.getId());
                        backPayLog.setBusiOrderId(po.getBusiOrderId());
                        backPayLog.setBusiOrderNo(po.getBusiOrderNo());
                        BigDecimal notBackAmt = po.getOverdraftAmt().subtract(po.getReimbursementAmount());
                        if (chargeAmount.compareTo(notBackAmt) >= 0) {
                            backPayLog.setReimbursementAmount(notBackAmt);
                            chargeAmount = chargeAmount.subtract(notBackAmt);
                            backPayLog.setReimbursementDate(reimbursementDate);
                        } else {
                            backPayLog.setReimbursementAmount(chargeAmount);
                            chargeAmount = BigDecimal.ZERO;
                        }
                        backList.add(backPayLog);
                    }
                }
                if (!CollectionUtils.isEmpty(backList)) {
                    this.fscPayLogMapper.updateBack(backList);
                }
            }
        }
        FscAccountChargeBusiRspBO rspBO = new FscAccountChargeBusiRspBO();
        rspBO.setClaimId(fscRecvClaimPo.getClaimId());
        FscAccountChargePO fscAccountChargePo = new FscAccountChargePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountChargePo);
        FscEncodedSerialGetPublicAbilityReqBO fscEncodedSerialGetPublicAbilityReqBO = new FscEncodedSerialGetPublicAbilityReqBO();
        fscEncodedSerialGetPublicAbilityReqBO.setCenter("FSC");
        fscEncodedSerialGetPublicAbilityReqBO.setEncodedRuleCode("ADVANCE_DEPOSIT_NO");
        fscEncodedSerialGetPublicAbilityReqBO.setNum(Integer.valueOf(1));
        fscEncodedSerialGetPublicAbilityReqBO.setOrgType("-1");
        FscEncodedSerialGetPublicAbilityRspBO fscEncodedSerialGetPublicAbilityRspBO = this.fscEncodedSerialGetPublicAbilityService.getEncodedSerialPublic(fscEncodedSerialGetPublicAbilityReqBO);
        if ("0000".equals(fscEncodedSerialGetPublicAbilityRspBO.getRespCode())) {
            fscAccountChargePo.setAdvanceDepositNo(fscEncodedSerialGetPublicAbilityRspBO.getSerialNo());
        }
        if (null != reqBO.getChargeAccount()) {
            fscAccountChargePo.setBusiType(Integer.valueOf("4"));
        } else {
            fscAccountChargePo.setBusiType(Integer.valueOf("1"));
        }
        fscAccountChargePo.setUseDeptCode(fscAccountPo.getOrgCode());
        fscAccountChargePo.setUseDeptId(fscAccountPo.getOrgId());
        fscAccountChargePo.setUseDeptName(fscAccountPo.getOrgName());
        fscAccountChargePo.setChargeDeptCode(fscAccountMainPo.getOrgCode());
        fscAccountChargePo.setChargeDeptId(StringUtils.isEmpty((Object)fscAccountMainPo.getOrgId()) ? null : Long.valueOf(fscAccountMainPo.getOrgId()));
        fscAccountChargePo.setChargeDeptName(fscAccountMainPo.getOrgName());
        fscAccountChargePo.setRecvBankAccount(fscAccountMainPo.getBankAccount());
        fscAccountChargePo.setRecvDeptName(fscAccountMainPo.getOrgName());
        fscAccountChargePo.setRecvDeptCode(fscAccountMainPo.getOrgCode());
        fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_PASS);
        fscAccountChargePo.setPayTime(new Date());
        fscAccountChargePo.setPayDeptName(fscAccountPo.getOrgName());
        fscAccountChargePo.setPayBankAccountName(fscAccountPo.getBankAccount());
        fscAccountChargePo.setPayBankName(fscAccountPo.getBankName());
        fscAccountChargePo.setUserId(reqBO.getUserId());
        fscAccountChargePo.setUserName(reqBO.getName());
        fscAccountChargePo.setCreateTime(new Date());
        fscAccountChargePo.setClaimNo(reqBO.getClaimNo());
        fscAccountChargePo.setChargeId(Long.valueOf(Sequence.getInstance().nextId()));
        fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
        fscAccountChargePo.setAuditTime(new Date());
        ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>(reqBO.getAttachmentList().size());
        for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setObjId(fscAccountChargePo.getChargeId());
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAY_EVIDENCE);
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentObjType.PAY_EVIDENCE);
            attachmentList.add(fscAttachmentPo);
        }
        if (!CollectionUtils.isEmpty(attachmentList)) {
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        FscAccountSerialPO serialPo = new FscAccountSerialPO();
        serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
        serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
        Integer serialNumber = 0;
        if (serialPo != null) {
            serialNumber = serialPo.getSerialNumber();
        }
        ArrayList<FscClaimDetailPO> detailPOList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscClaimDetailBO> pushDetailList = new ArrayList<FscClaimDetailBO>();
        Object[] objectArray = new Object[1];
        serialNumber = serialNumber + 1;
        objectArray[0] = serialNumber;
        String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
        FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
        fscClaimDetailPo.setDetailNo(detailNo);
        fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
        fscClaimDetailPo.setClaimAmt(fscAccountChargePo.getChargeAmount());
        fscClaimDetailPo.setClaimDate(new Date());
        fscClaimDetailPo.setClaimId(fscRecvClaimPo.getClaimId());
        if (null != reqBO.getChargeAccount()) {
            fscClaimDetailPo.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode());
        } else {
            fscClaimDetailPo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
        }
        fscClaimDetailPo.setCustomerNo(Long.valueOf(fscAccountPo.getOrgCode()));
        fscClaimDetailPo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
        fscClaimDetailPo.setCustomerNo(StringUtils.isEmpty((Object)fscAccountPo.getOrgCode()) ? null : Long.valueOf(fscAccountPo.getOrgCode()));
        fscClaimDetailPo.setCustomerName(fscAccountPo.getOrgName());
        fscClaimDetailPo.setHandleDeptId(reqBO.getDeptId());
        fscClaimDetailPo.setHandleDeptName(reqBO.getDeptName());
        fscClaimDetailPo.setHandleUserId(reqBO.getUserId());
        fscClaimDetailPo.setHandleUserName(reqBO.getName());
        fscClaimDetailPo.setStatus("1");
        fscClaimDetailPo.setObjectId(fscAccountChargePo.getChargeId());
        fscClaimDetailPo.setObjectNo(fscAccountChargePo.getAdvanceDepositNo().toString());
        fscClaimDetailPo.setSysSource(Integer.valueOf(1));
        fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
        detailPOList.add(fscClaimDetailPo);
        FscClaimDetailBO detailBO = new FscClaimDetailBO();
        BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)detailBO);
        pushDetailList.add(detailBO);
        rspBO.setPushDetailBOList(pushDetailList);
        int count = this.fscClaimDetailMapper.insertBatch(detailPOList);
        if (count < 0) {
            throw new FscBusinessException("190000", "\u9884\u5b58\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        fscAccountChargePo.setClaimDetailId(fscClaimDetailPo.getClaimDetailId());
        int insert = this.fscAccountChargeMapper.insert(fscAccountChargePo);
        if (insert < 0) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u8d26\u6237\u5145\u503c\u5931\u8d25\uff01");
        }
        if (serialPo == null) {
            serialPo = new FscAccountSerialPO();
            serialPo.setSerialNumber(serialNumber);
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
            this.fscAccountSerialMapper.insert(serialPo);
        } else {
            serialPo.setSerialNumber(serialNumber);
            this.fscAccountSerialMapper.update(serialPo);
        }
        if (fscAccountChargePo.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) == 0) {
            fscRecvClaimPo.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
            fscRecvClaimPo.setNoClaimAmt(BigDecimal.ZERO);
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
        } else {
            fscRecvClaimPo.setNoClaimAmt(fscRecvClaimPo.getNoClaimAmt().subtract(fscAccountChargePo.getChargeAmount()));
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        }
        fscRecvClaimPo.setUpdateTime(new Date());
        fscRecvClaimPo.setIsSup(Integer.valueOf(1));
        this.fscRecvClaimMapper.update(fscRecvClaimPo);
        BigDecimal returnedAmount = null;
        if (null == reqBO.getChargeAccount()) {
            fscAccountPo.setAdvanceAmount(fscAccountPo.getAdvanceAmount().add(fscAccountChargePo.getChargeAmount()));
            returnedAmount = BigDecimal.ZERO;
            if (fscAccountPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                returnedAmount = fscAccountPo.getOverdraftAmount();
                fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().compareTo(fscAccountChargePo.getChargeAmount()) > 0 ? fscAccountPo.getOverdraftAmount().subtract(fscAccountChargePo.getChargeAmount()) : BigDecimal.ZERO);
                returnedAmount = returnedAmount.subtract(fscAccountPo.getOverdraftAmount());
            }
        } else {
            returnedAmount = BigDecimal.ZERO;
            if (FscConstants.ChargeAccount.COMPANY.equals(reqBO.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(reqBO.getChargeAccount())) {
                fscAccountPo.setCompanyAdvanceAmount(fscAccountPo.getCompanyAdvanceAmount().add(reqBO.getCompanyChargeAmount()));
                BigDecimal CompanyReturnedAmount = BigDecimal.ZERO;
                if (fscAccountPo.getCompanyOverdraft().compareTo(BigDecimal.ZERO) > 0) {
                    CompanyReturnedAmount = fscAccountPo.getCompanyOverdraft();
                    fscAccountPo.setCompanyOverdraftAmount(fscAccountPo.getCompanyOverdraftAmount().compareTo(reqBO.getCompanyChargeAmount()) > 0 ? fscAccountPo.getCompanyOverdraftAmount().subtract(reqBO.getCompanyChargeAmount()) : BigDecimal.ZERO);
                    CompanyReturnedAmount = returnedAmount.subtract(fscAccountPo.getCompanyOverdraftAmount());
                    returnedAmount = returnedAmount.add(CompanyReturnedAmount);
                }
            }
            if (FscConstants.ChargeAccount.UNION.equals(reqBO.getChargeAccount()) || FscConstants.ChargeAccount.ALL.equals(reqBO.getChargeAccount())) {
                fscAccountPo.setUnionAdvanceAmount(fscAccountPo.getUnionAdvanceAmount().add(reqBO.getUnionChargeAmount()));
                if (fscAccountPo.getUnionOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal UnionReturnedAmount = fscAccountPo.getUnionOverdraftAmount();
                    fscAccountPo.setUnionOverdraftAmount(fscAccountPo.getUnionOverdraftAmount().compareTo(reqBO.getUnionChargeAmount()) > 0 ? fscAccountPo.getUnionOverdraftAmount().subtract(reqBO.getUnionChargeAmount()) : BigDecimal.ZERO);
                    UnionReturnedAmount = returnedAmount.subtract(fscAccountPo.getUnionOverdraftAmount());
                    returnedAmount = returnedAmount.add(UnionReturnedAmount);
                }
            }
            this.createChargeDetail(reqBO, fscAccountPo, fscAccountChargePo);
        }
        fscAccountPo.setReturnedAmount(returnedAmount);
        this.fscAccountMapper.updateAmountByCharge(fscAccountPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void createChargeDetail(FscAccountChargeBusiReqBO reqBO, FscAccountPO fscAccountPo, FscAccountChargePO fscAccountChargePo) {
        FscAccountChargeDetailPO fscAccountChargeDetailPO = new FscAccountChargeDetailPO();
        fscAccountChargeDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscAccountChargeDetailPO.setChargeId(fscAccountChargePo.getChargeId());
        fscAccountChargeDetailPO.setAdvanceDepositNo(fscAccountChargePo.getAdvanceDepositNo());
        fscAccountChargeDetailPO.setAccountId(reqBO.getAccountId());
        fscAccountChargeDetailPO.setUseDeptId(fscAccountPo.getOrgId());
        fscAccountChargeDetailPO.setUseDeptCode(fscAccountPo.getOrgCode());
        fscAccountChargeDetailPO.setUseDeptName(fscAccountPo.getOrgName());
        fscAccountChargeDetailPO.setCreateId(reqBO.getUserId());
        fscAccountChargeDetailPO.setCreateTime(new Date());
        fscAccountChargeDetailPO.setUpdateId(reqBO.getUserId());
        fscAccountChargeDetailPO.setUpdateTime(new Date());
        fscAccountChargeDetailPO.setDeleteYn(DeleteYnEnum.NORMAL.getCode());
        fscAccountChargeDetailPO.setChargeAccount(reqBO.getChargeAccount());
        fscAccountChargeDetailPO.setCompanyAmount(reqBO.getCompanyChargeAmount());
        fscAccountChargeDetailPO.setUnionAmount(reqBO.getUnionChargeAmount());
        this.fscAccountChargeDetailMapper.insert(fscAccountChargeDetailPO);
    }
}

