/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.common.busi.api.FscBillPayRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscBillPayRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillPayRefundApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscBillPayRefundApprovalBusiServiceImpl
implements FscBillPayRefundApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundApprovalBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    public static final String PASS = "0";
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;

    @Override
    public FscBillPayRefundApprovalBusiRspBO dealPayRefundApproval(FscBillPayRefundApprovalBusiReqBO reqBO) {
        FscBillPayRefundApprovalBusiRspBO rspBO = new FscBillPayRefundApprovalBusiRspBO();
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundId(reqBO.getRefundId());
        fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
        if (fscOrderRefundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u4fe1\u606f\u3002");
        }
        rspBO.setRefundPO(fscOrderRefundPO);
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        rspBO.setIsPush(false);
        if (finish.booleanValue()) {
            FscOrderRefundPO passUpdatePO = new FscOrderRefundPO();
            passUpdatePO.setRefundId(reqBO.getRefundId());
            if (PASS.equals(auditResult)) {
                passUpdatePO.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
                if (FscConstants.FscTradeMode.TRADE_MODEL.equals(fscOrderRefundPO.getTradeMode()) || FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(fscOrderRefundPO.getTradeMode()) && this.operationSupId.equals(fscOrderRefundPO.getPayeeId().toString())) {
                    rspBO.setIsPush(true);
                }
            } else {
                passUpdatePO.setAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
            }
            this.fscOrderRefundMapper.update(passUpdatePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscBillPayRefundApprovalBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getRefundId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.REFUND_PAY;
        String stepId = this.fscOrderRefundMapper.selectStepId(reqBO.getRefundId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(paramMap);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }
}

