/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscClaimChangeConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscClaimChangeConfirmBusiServiceImpl
implements FscClaimChangeConfirmBusiService {
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;

    @Override
    public FscClaimChangeConfirmBusiRspBO dealClaimChangeConfirm(FscClaimChangeConfirmBusiReqBO reqBO) {
        FscClaimChangeConfirmBusiRspBO rspBO = new FscClaimChangeConfirmBusiRspBO();
        FscClaimDetailChangePO fscClaimDetailChangePO = new FscClaimDetailChangePO();
        fscClaimDetailChangePO.setChangeDetailIdList(reqBO.getChangeDetailIdList());
        List detailChangeList = this.fscClaimDetailChangeMapper.queryAll(fscClaimDetailChangePO);
        if (!CollectionUtils.isEmpty((Collection)detailChangeList)) {
            for (FscClaimDetailChangePO po : detailChangeList) {
                if (po.getConfirmStatus() == FscConstants.ChangeConfirmStatus.RETURN) {
                    throw new FscBusinessException("198888", "\u8ba4\u9886\u53d8\u66f4\u7f16\u53f7\u4e3a\uff1a" + po.getChangeNo() + " \u5df2\u7ecf\u88ab\u9000\u56de");
                }
                if (po.getConfirmStatus() != FscConstants.ChangeConfirmStatus.CANCEL) continue;
                throw new FscBusinessException("198888", "\u8ba4\u9886\u53d8\u66f4\u7f16\u53f7\u4e3a\uff1a" + po.getChangeNo() + " \u5df2\u7ecf\u88ab\u53d6\u6d88");
            }
        }
        List<Long> changeIdList = detailChangeList.stream().map(FscClaimDetailChangePO::getChangeId).collect(Collectors.toList());
        ArrayList<Long> confirmedList = new ArrayList<Long>();
        this.updateChangeStatus(reqBO, changeIdList, confirmedList);
        rspBO.setChangeIdList(confirmedList);
        return rspBO;
    }

    private void updateChangeStatus(FscClaimChangeConfirmBusiReqBO reqBO, List<Long> changeIdList, List<Long> confirmedList) {
        Date now = new Date();
        FscClaimDetailChangePO detailChangePO = new FscClaimDetailChangePO();
        detailChangePO.setChangeDetailIdList(reqBO.getChangeDetailIdList());
        detailChangePO.setConfirmStatus(FscConstants.ChangeConfirmStatus.CONFIRMED);
        detailChangePO.setConfirmDate(now);
        detailChangePO.setConfirmUserId(reqBO.getUserId());
        detailChangePO.setConfirmUserName(reqBO.getName());
        int result = this.fscClaimDetailChangeMapper.updateConfirmStatus(detailChangePO);
        if (result != reqBO.getChangeDetailIdList().size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u53d8\u66f4\u660e\u7ec6\u72b6\u6001\u5931\u8d25\uff01");
        }
        FscClaimDetailChangePO fscClaimDetailChangePO = new FscClaimDetailChangePO();
        fscClaimDetailChangePO.setChangeIdList(changeIdList);
        List detailChangeList = this.fscClaimDetailChangeMapper.queryAll(fscClaimDetailChangePO);
        HashMap<Long, Integer> changeStatusMap = new HashMap<Long, Integer>();
        for (Object po : detailChangeList) {
            Integer confirmStatus = (Integer)changeStatusMap.get(po.getChangeId());
            if (confirmStatus == null || FscConstants.ChangeConfirmStatus.CANCEL.equals(confirmStatus)) {
                changeStatusMap.put(po.getChangeId(), po.getConfirmStatus());
                continue;
            }
            if (!FscConstants.ChangeConfirmStatus.CONFIRMED.equals(confirmStatus) || FscConstants.ChangeConfirmStatus.CANCEL.equals(po.getConfirmStatus())) continue;
            changeStatusMap.put(po.getChangeId(), po.getConfirmStatus());
        }
        ArrayList<Long> confirmingList = new ArrayList<Long>();
        for (Long changeId : changeStatusMap.keySet()) {
            if (FscConstants.ChangeConfirmStatus.CONFIRMED.equals(changeStatusMap.get(changeId))) {
                confirmedList.add(changeId);
                continue;
            }
            confirmingList.add(changeId);
        }
        FscRecvClaimChangePO fscRecvClaimChangePO = new FscRecvClaimChangePO();
        fscRecvClaimChangePO.setConfirmDate(now);
        if (!CollectionUtils.isEmpty(confirmingList)) {
            fscRecvClaimChangePO.setChangeIdList(confirmingList);
            fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.PART_CONFIRMED);
            result = this.fscRecvClaimChangeMapper.updateBillStatus(fscRecvClaimChangePO);
            if (result != confirmingList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u53d8\u66f4\u5355\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(confirmedList)) {
            fscRecvClaimChangePO.setChangeIdList(confirmedList);
            fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.CONFIRMED);
            result = this.fscRecvClaimChangeMapper.updateBillStatus(fscRecvClaimChangePO);
            if (result != confirmedList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u53d8\u66f4\u5355\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
    }
}

