/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentExtensionBO;
import com.tydic.fsc.common.ability.bo.FscAttachmentExtensionBO;
import com.tydic.fsc.common.ability.bo.FscClaimCreateNewYCCashAbilityBO;
import com.tydic.fsc.common.ability.bo.FscClaimCreateNewYCCashAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscClaimCreateNewYCCashAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscClaimCreateNewYCCashBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscClaimCreateNewYCCashBusiServiceImpl
implements FscClaimCreateNewYCCashBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimCreateNewYCCashBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${receive.yc.cash.filter.enable:true}")
    private Boolean flag;
    @Value(value="${receive.yc.cash.bankA:0200004219200044858}")
    private String filterBankA;
    @Value(value="${receive.yc.cash.customerA:\u8d22\u4ed8\u901a\u652f\u4ed8\u79d1\u6280\u6709\u9650\u516c\u53f8}")
    private String filterCustomerA;
    @Value(value="${receive.yc.cash.bankB:110060224018010044276}")
    private String filterBankB;
    @Value(value="${receive.yc.cash.customerB1:\u94f6\u8054\u5546\u52a1\u80a1\u4efd\u6709\u9650\u516c\u53f8}")
    private String filterCustomerB1;
    @Value(value="${receive.yc.cash.customerB2:\u4e0a\u6d77\u94f6\u8054\u7535\u5b50\u652f\u4ed8\u670d\u52a1\u6709\u9650\u516c\u53f8}")
    private String filterCustomerB2;
    @Value(value="${receive.yc.cash.bankC1:344156031822}")
    private String filterBankC1;
    @Value(value="${receive.yc.cash.bankC2:336356031826}")
    private String filterBankC2;
    @Value(value="${receive.yc.cash.customerC1:\u4e2d\u56fd\u4e2d\u7164\u80fd\u6e90\u96c6\u56e2\u6709\u9650\u516c\u53f8}")
    private String filterCustomerC1;
    @Value(value="${receive.yc.cash.customerC2:\u4e2d\u56fd\u4e2d\u7164\u80fd\u6e90\u80a1\u4efd\u6709\u9650\u516c\u53f8}")
    private String filterCustomerC2;

    @Override
    @FscDuplicateCommitLimit
    public FscClaimCreateNewYCCashAbilityRspBO createNewYCCash(FscClaimCreateNewYCCashAbilityReqBO reqBO) {
        int count;
        FscRecvClaimPO queryVo = new FscRecvClaimPO();
        queryVo.setSerialNumberList(reqBO.getInfoBos().stream().map(obj -> obj.getSerialNumber()).collect(Collectors.toList()));
        queryVo.setExcludeRecvStatus(FscClaimRecvStatusEnum.DELETE.getCode());
        List list = this.fscRecvClaimMapper.queryAll(queryVo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", ((FscRecvClaimPO)list.get(0)).getSerialNumber() + "\u94f6\u884c\u6d41\u6c34\u53f7\u91cd\u590d\uff01");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("COLLECTION_CLAIM");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(reqBO.getInfoBos().size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        LinkedList<AttachmentExtensionBO> extensionAddList = new LinkedList<AttachmentExtensionBO>();
        ArrayList<FscRecvClaimPO> claimPOS = new ArrayList<FscRecvClaimPO>();
        List infoBos = reqBO.getInfoBos();
        Date date = new Date();
        for (int i = 0; i < reqBO.getInfoBos().size(); ++i) {
            FscClaimCreateNewYCCashAbilityBO infoBo = (FscClaimCreateNewYCCashAbilityBO)infoBos.get(i);
            FscRecvClaimPO po = (FscRecvClaimPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)infoBo), FscRecvClaimPO.class);
            if (this.flag.booleanValue() && (po.getBankAccount().trim().equals(this.filterBankA) && po.getCustomerName().trim().equals(this.filterCustomerA) || po.getBankAccount().trim().equals(this.filterBankB) && (po.getCustomerName().trim().equals(this.filterCustomerB1) || po.getCustomerName().trim().equals(this.filterCustomerB2)) || (po.getBankAccount().trim().equals(this.filterBankC1) || po.getBankAccount().trim().equals(this.filterBankC2)) && !po.getCustomerName().trim().equals(this.filterCustomerC1) && !po.getCustomerName().trim().equals(this.filterCustomerC2))) continue;
            po.setClaimId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setClaimNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(i));
            po.setNoClaimAmt(po.getRecvAmt());
            po.setCreateTime(date);
            po.setUpdateTime(date);
            po.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            po.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
            po.setStatus(FscConstants.pushState.NO_PUSH);
            if (StringUtils.isEmpty((Object)infoBo.getCurrency())) {
                po.setCurrency("CNY");
            }
            po.setSerialNumberId(infoBo.getHeaderId());
            claimPOS.add(po);
            if (CollectionUtils.isEmpty((Collection)infoBo.getAttachmentExtensionBOS())) continue;
            for (FscAttachmentExtensionBO attachmentExtensionBO : infoBo.getAttachmentExtensionBOS()) {
                AttachmentExtensionBO bo = new AttachmentExtensionBO();
                bo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                bo.setObjId(po.getClaimId());
                bo.setAttachmentType(FscConstants.AttachmentType.CLAIM);
                bo.setCreateTime(date);
                bo.setCreateUser(attachmentExtensionBO.getCreateUser());
                bo.setFormatType(attachmentExtensionBO.getFormatType());
                bo.setFileSize(attachmentExtensionBO.getFileSize());
                bo.setAttachmentName(attachmentExtensionBO.getAttachmentName());
                bo.setAttachmentUrl(attachmentExtensionBO.getAttachmentUrl());
                extensionAddList.add(bo);
            }
        }
        if (!CollectionUtils.isEmpty(claimPOS)) {
            this.fscRecvClaimMapper.insertDraftBatch(claimPOS);
        }
        if (!CollectionUtils.isEmpty(extensionAddList) && (count = this.fscAttachmentMapper.insertExtensionByBatch(extensionAddList)) == 0) {
            throw new FscBusinessException("190000", "\u6dfb\u52a0\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        FscClaimCreateNewYCCashAbilityRspBO rspBO = new FscClaimCreateNewYCCashAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

