/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscDraftReleaseOccReqBO;
import com.tydic.fsc.busibase.external.api.esb.FscDraftReleaseOccService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimDraftCreateBO;
import com.tydic.fsc.common.busi.api.FscClaimCreateYCDractBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimCreateYCDractBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimCreateYCDractBusiRspBO;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscRecvTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.UmcOperationRecvBankPageListQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscClaimCreateYCDractBusiServiceImpl
implements FscClaimCreateYCDractBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimCreateYCDractBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private UmcOperationRecvBankPageListQueryAbilityService umcOperationRecvBankPageListQueryAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscDraftReleaseOccService fscDraftReleaseOccService;
    @Value(value="${BANK_ACCOUNT_DRAFT:1121001001001-0047}")
    private String bankAccount;
    @Value(value="${fsc.member.invoice.agentAccount:10228059}")
    private String agent;

    @Override
    public FscClaimCreateYCDractBusiRspBO createYcdract(FscClaimCreateYCDractBusiReqBO reqBO) {
        FscRecvClaimPO queryVo = new FscRecvClaimPO();
        queryVo.setSerialNumberList(reqBO.getInfoBos().stream().map(obj -> obj.getSerialNumber()).collect(Collectors.toList()));
        queryVo.setExcludeRecvStatus(FscClaimRecvStatusEnum.DELETE.getCode());
        List list = this.fscRecvClaimMapper.queryAll(queryVo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", ((FscRecvClaimPO)list.get(0)).getSerialNumber() + "\u94f6\u884c\u6d41\u6c34\u53f7\u91cd\u590d\uff01");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("COLLECTION_CLAIM");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(reqBO.getInfoBos().size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        ArrayList<FscRecvClaimPO> claimPOS = new ArrayList<FscRecvClaimPO>();
        List<FscRecvClaimDraftCreateBO> infoBos = reqBO.getInfoBos();
        Date date = new Date();
        for (int i = 0; i < reqBO.getInfoBos().size(); ++i) {
            FscRecvClaimDraftCreateBO infoBo = infoBos.get(i);
            FscRecvClaimPO po = new FscRecvClaimPO();
            BeanUtils.copyProperties((Object)infoBo, (Object)po);
            po.setClaimId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setClaimNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(i));
            po.setRecvType(FscRecvTypeEnum.SHOULD_RECV.getCode());
            po.setRecvAmt(new BigDecimal(infoBo.getRecvAmt()));
            po.setNoClaimAmt(po.getRecvAmt());
            po.setHandleUserId(Long.valueOf(Long.parseLong(infoBo.getHandleUserId())));
            po.setHandleDeptId(Long.valueOf(Long.parseLong(infoBo.getHandledeptId())));
            po.setHandleDeptName(infoBo.getHandledeptName());
            po.setMaintainUserId(po.getHandleUserId());
            po.setMaintainUserName(po.getHandleUserName());
            po.setMaintainDeptId(po.getHandleDeptId());
            po.setMaintainDeptName(po.getHandleDeptName());
            po.setCustomerNo(Long.valueOf(Long.parseLong(infoBo.getCustomerNo())));
            po.setNoClaimAmt(po.getRecvAmt());
            po.setCreateTime(date);
            po.setUpdateTime(date);
            po.setRecvDate(date);
            po.setRecvStatus("102");
            po.setClaimStatus("0");
            po.setStatus(Integer.valueOf(0));
            po.setCurrency("CNY");
            po.setAccountBranch("\u7968\u636e\u94f6\u884c");
            claimPOS.add(po);
        }
        this.fscRecvClaimMapper.insertDraftBatch(claimPOS);
        FscDraftReleaseOccReqBO releaseOccReqBO = new FscDraftReleaseOccReqBO();
        releaseOccReqBO.setDraftList(claimPOS.stream().map(x -> x.getLedgerId()).collect(Collectors.toList()));
        releaseOccReqBO.setYcUserId(((FscRecvClaimPO)claimPOS.get(0)).getHandleUserId() + "");
        releaseOccReqBO.setType("3");
        releaseOccReqBO.setAgentAccount(this.agent);
        this.fscDraftReleaseOccService.draftReleaseOcc(releaseOccReqBO);
        FscClaimCreateYCDractBusiRspBO rspBO = new FscClaimCreateYCDractBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void pushYc(Long claimId) {
        FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
        abilityReqBO.setClaimId(claimId);
        FscPushYcRecvClaimBillAbilityRspBO abilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            FscRecvClaimPO updateVo = new FscRecvClaimPO();
            updateVo.setClaimId(claimId);
            updateVo.setStatus(Integer.valueOf(0));
            this.fscRecvClaimMapper.update(updateVo);
        } else {
            FscRecvClaimPO updateVo = new FscRecvClaimPO();
            updateVo.setClaimId(claimId);
            updateVo.setStatus(Integer.valueOf(1));
            this.fscRecvClaimMapper.update(updateVo);
        }
    }
}

